/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.utils;

import java.text.DecimalFormat;

public class DataSizeConverter {
    private static final double ONE_K = 1024.0;

    public static String getSize(long bytes) {
        DataSizeObject obj = DataSizeConverter.convertToAppropriateUnit(bytes);
        String ret = obj.getSizeString() + " " + (Object)((Object)obj.getUnit());
        return ret;
    }

    public static DataSizeObject convertToAppropriateUnit(long bytes) {
        if ((double)bytes < 1024.0) {
            return new DataSizeObject(String.valueOf(bytes), UNIT.UNIT_BYTE);
        }
        double sizeInKb = (double)bytes / 1024.0;
        DecimalFormat df = new DecimalFormat("###.00");
        if (Double.compare(sizeInKb, 1024.0) < 0) {
            return new DataSizeObject(df.format(sizeInKb), UNIT.UNIT_KILOBYTE);
        }
        double sizeInMb = sizeInKb / 1024.0;
        if (Double.compare(sizeInMb, 1024.0) < 0) {
            return new DataSizeObject(df.format(sizeInMb), UNIT.UNIT_MEGABYTE);
        }
        double sizeInGb = sizeInMb / 1024.0;
        return new DataSizeObject(df.format(sizeInGb), UNIT.UNIT_GIGABYTE);
    }

    public static class DataSizeObject {
        private final String sizeStr;
        private final UNIT unit;

        public DataSizeObject(String sizeStr, UNIT unit) {
            this.sizeStr = sizeStr;
            this.unit = unit;
        }

        public String getSizeString() {
            return this.sizeStr;
        }

        public UNIT getUnit() {
            return this.unit;
        }
    }

    public static enum UNIT {
        UNIT_BYTE("Byte"),
        UNIT_KILOBYTE("KB"),
        UNIT_MEGABYTE("MB"),
        UNIT_GIGABYTE("GB");

        private String unit;

        private UNIT(String unit) {
            this.unit = unit;
        }

        public String toString() {
            return this.unit;
        }
    }
}

