/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtil {
    public static String computeSHA1(File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        MessageDigest mdMD5 = MessageDigest.getInstance("SHA1");
        return HashUtil.compute(file, mdMD5);
    }

    public static String computeMD5(File file) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        MessageDigest mdMD5 = MessageDigest.getInstance("MD5");
        return HashUtil.compute(file, mdMD5);
    }

    private static String compute(File file, MessageDigest md) throws NoSuchAlgorithmException, FileNotFoundException, IOException {
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            String string = sb.toString();
            return string;
        }
    }
}

