/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDKVersionUtil {
    private static final Logger logger = LoggerFactory.getLogger(JDKVersionUtil.class);

    public static void versionCheckOrExit(int major, int build) {
        String[] vers = System.getProperty("java.version").split("\\.");
        try {
            int idx;
            int jdkBuild;
            int jdkMajor = Integer.parseInt(vers[1]);
            if (jdkMajor < major) {
                logger.error("Current jdk version is :" + System.getProperty("java.version") + " but minimal required is major:" + major + "and build:" + build);
                System.exit(-1);
            }
            if ((jdkBuild = Integer.parseInt(vers[2].substring((idx = vers[2].indexOf("_")) + 1))) < build) {
                logger.error("Current jdk version is :" + System.getProperty("java.version") + " but minimal required is major:" + major + "and build:" + build);
                System.exit(-1);
            }
        }
        catch (Exception ex) {
            logger.error("unknown jdk version");
        }
    }
}

