/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleProcessUtil {
    private static final Logger logger = LoggerFactory.getLogger(SingleProcessUtil.class);

    public static void acquireOrExit(String appName) {
        File f = new File("." + appName);
        f.deleteOnExit();
        try {
            FileChannel fc;
            if (!f.exists() && !f.createNewFile()) {
                System.exit(-1);
            }
            if ((fc = new RandomAccessFile(f, "rw").getChannel()).tryLock() == null) {
                System.out.println("App " + appName + " has started");
                System.exit(-1);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        fc.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            System.exit(-1);
        }
    }
}

