/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.util.Callback;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.SelectedEntityMenuItem;
import myencyclopedia.model.Entity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityList
extends BorderPane {
    TreeMap<Long, Entity> allTreeMap;
    ObservableList<Entity> listDisplayed = FXCollections.observableArrayList();
    protected GUIListener listener;
    protected TextField filterField;
    protected ListView<Entity> list = new ListView();
    final int ROW_HEIGHT = 24;
    public static final String EVENT_SELECTED = "EntityList_selected";
    public static final String EVENT_DEFAULT_ACTION = "EntityList_default";
    public static final String EVENT_DEFAULT_ACTION_CONTROL = "EntityList_default_control";
    public static final String EVENT_OPEN = "EntityList_open";
    public static final String EVENT_DELETE = "EntityList_delete";
    private static final Logger logger = LoggerFactory.getLogger(EntityList.class);

    public EntityList(GUIListener callback, final Class<? extends ListCell> listCellCls) {
        this(callback);
        this.list.setCellFactory((Callback)new Callback<ListView<Entity>, ListCell<Entity>>(){

            public ListCell<Entity> call(ListView<Entity> listView) {
                ListCell cell = null;
                try {
                    cell = (ListCell)listCellCls.newInstance();
                }
                catch (Exception ex) {
                    logger.error("", (Throwable)ex);
                }
                return cell;
            }
        });
    }

    public EntityList(final GUIListener callback) {
        this.list.setPrefHeight(74.0);
        this.listener = callback;
        this.allTreeMap = new TreeMap();
        this.list.setItems(this.listDisplayed);
        this.list.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Entity>(){

            public void changed(ObservableValue<? extends Entity> ov, Entity oldEn, Entity newEn) {
                callback.dispatch(new GUIEvent((Object)EntityList.this, EntityList.EVENT_SELECTED, (Object)newEn));
            }
        });
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    EntityList.this.launchSelectedItem(event.isControlDown());
                }
            }
        });
        this.filterField = new TextField();
        this.filterField.setPromptText("Filter");
        this.filterField.textProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldVal, Object newVal) {
                EntityList.this.filter((String)newVal);
            }
        });
        this.filterField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ESCAPE) {
                    EntityList.this.filterField.setText("");
                } else if (keyEvent.getCode() == KeyCode.DOWN) {
                    if (EntityList.this.list.isVisible() && EntityList.this.list.getItems().size() > 0) {
                        EntityList.this.list.getSelectionModel().select(0);
                        EntityList.this.list.requestFocus();
                    }
                } else if (keyEvent.getCode() == KeyCode.ENTER && EntityList.this.list.isVisible() && EntityList.this.list.getItems().size() > 0) {
                    EntityList.this.list.getSelectionModel().select(0);
                    EntityList.this.launchSelectedItem(keyEvent.isControlDown());
                }
            }
        });
        this.setCenter((Node)this.list);
        this.setTop((Node)this.filterField);
    }

    public void setEnableFilter(boolean enabled) {
        this.filterField.setVisible(enabled);
    }

    public void enableContextMenu() {
        final ContextMenu contextMenu = new ContextMenu();
        MenuItem menuOpen = new MenuItem("Open");
        menuOpen.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                EntityList.this.listener.dispatch(new GUIEvent((Object)EntityList.this, EntityList.EVENT_OPEN, (Object)((Entity)EntityList.this.list.getSelectionModel().getSelectedItem())));
            }
        });
        MenuItem menuModify = new MenuItem("Modify");
        MenuItem menuDelete = new MenuItem("Delete");
        menuDelete.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                EntityList.this.listener.dispatch(new GUIEvent((Object)EntityList.this, EntityList.EVENT_DELETE, (Object)((Entity)EntityList.this.list.getSelectionModel().getSelectedItem())));
            }
        });
        contextMenu.getItems().addAll((Object[])new MenuItem[]{menuOpen, menuModify, menuDelete});
        this.list.setContextMenu(contextMenu);
        this.list.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                contextMenu.show((Node)EntityList.this, event.getScreenX(), event.getScreenY());
                event.consume();
            }
        });
    }

    private void launchSelectedItem(boolean isControlDown) {
        Entity item = (Entity)this.list.getSelectionModel().getSelectedItem();
        if (item != null) {
            this.listener.dispatch(new GUIEvent((Object)this, isControlDown ? EVENT_DEFAULT_ACTION_CONTROL : EVENT_DEFAULT_ACTION, (Object)item));
        }
    }

    public void setMenuItems(SelectedEntityMenuItem ... items) {
        final ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll((Object[])items);
        for (final SelectedEntityMenuItem item : items) {
            item.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent t) {
                    Entity en = (Entity)EntityList.this.list.getSelectionModel().getSelectedItem();
                    if (en != null) {
                        item.handle(en);
                    }
                }
            });
        }
        this.list.setContextMenu(contextMenu);
        this.list.setOnContextMenuRequested((EventHandler)new EventHandler<ContextMenuEvent>(){

            public void handle(ContextMenuEvent event) {
                contextMenu.show((Node)EntityList.this, event.getScreenX(), event.getScreenY());
                event.consume();
            }
        });
    }

    public ListView<Entity> getListView() {
        return this.list;
    }

    public Collection<Entity> getItems() {
        return this.allTreeMap.values();
    }

    public void itemsReset() {
        this.allTreeMap.clear();
        this.listDisplayed.clear();
    }

    public void itemsAdd(List<? extends Entity> list) {
        if (!this.filterField.getText().isEmpty()) {
            String txt = this.filterField.getText().toLowerCase();
            Iterator<? extends Entity> it = list.iterator();
            while (it.hasNext()) {
                Entity en = it.next();
                if (!en.toString().toLowerCase().contains(txt)) continue;
                if (this.allTreeMap.putIfAbsent(en.getId(), en) == null) {
                    this.listDisplayed.add((Object)en);
                    continue;
                }
                it.remove();
            }
        } else {
            Iterator<? extends Entity> it = list.iterator();
            while (it.hasNext()) {
                Entity en = it.next();
                if (this.allTreeMap.putIfAbsent(en.getId(), en) == null) {
                    this.listDisplayed.add((Object)en);
                    continue;
                }
                it.remove();
            }
        }
    }

    public boolean itemAdd(Entity entity) {
        boolean ret = false;
        if (!this.filterField.getText().isEmpty()) {
            String txt = this.filterField.getText().toLowerCase();
            if (entity.toString().toLowerCase().contains(txt) && this.allTreeMap.putIfAbsent(entity.getId(), entity) == null) {
                this.listDisplayed.add((Object)entity);
                ret = true;
            }
        } else if (this.allTreeMap.putIfAbsent(entity.getId(), entity) == null) {
            this.listDisplayed.add((Object)entity);
            ret = true;
        }
        return ret;
    }

    public boolean itemDelete(Entity entity) {
        Entity entityDisplayed = this.allTreeMap.remove(entity.getId());
        if (entityDisplayed != null) {
            this.listDisplayed.remove((Object)entityDisplayed);
        }
        return entityDisplayed != null;
    }

    public boolean itemRefresh(Entity entity) {
        Entity entityDisplayed = this.allTreeMap.remove(entity.getId());
        if (entityDisplayed != null) {
            int idx = this.listDisplayed.indexOf((Object)entityDisplayed);
            if (idx != -1) {
                this.listDisplayed.remove(idx);
                this.listDisplayed.add(idx, (Object)entity);
                this.allTreeMap.put(entity.getId(), entity);
            } else {
                logger.error("error in itemRefresh");
            }
            return true;
        }
        return false;
    }

    public Entity getSelectedEntity() {
        Entity item = (Entity)this.list.getSelectionModel().getSelectedItem();
        return item;
    }

    public TextField getTextField() {
        return this.filterField;
    }

    public void filter(String txt) {
        txt = txt.toLowerCase();
        LinkedList<Entity> tempList = new LinkedList<Entity>();
        for (Entity en : this.allTreeMap.values()) {
            if (!en.toString().toLowerCase().contains(txt)) continue;
            tempList.add(en);
        }
        this.listDisplayed.clear();
        this.listDisplayed.setAll(tempList);
    }
}

