/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.converter;

import myencyclopedia.model.common.StringConverter;

public class DoubleConverter
implements StringConverter<Double> {
    private static final DoubleConverter theConverter = new DoubleConverter(true);
    private static final DoubleConverter theConverterNonEmpty = new DoubleConverter(false);
    private boolean isEmptyAllowed;

    private DoubleConverter(boolean isEmptyAllowed) {
        this.isEmptyAllowed = isEmptyAllowed;
    }

    public static DoubleConverter getConverter(boolean allowEmpty) {
        if (allowEmpty) {
            return theConverter;
        }
        return theConverterNonEmpty;
    }

    public String toString(Double object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public Double fromString(String str) throws StringConverter.ConversionException {
        if (this.isEmptyAllowed && (str == null || str.trim().isEmpty())) {
            return null;
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ex) {
            throw new StringConverter.ConversionException((Throwable)ex);
        }
    }
}

