/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.Spec;
import myencyclopedia.common.gui.entity.SpecElement;
import myencyclopedia.common.gui.entity.table.EntityPropertyValueFactory;
import myencyclopedia.model.Entity;
import myencyclopedia.model.common.StringConverter;
import myencyclopedia.model.hbn.HBAbstractEntity;

public class EntityTable
extends VBox {
    protected TableView<Entity> table;
    protected GUIListener listener;
    protected List<String> propertyList;
    protected List<TableColumn> columnList;
    protected TextField filterField;
    protected ObservableList<Entity> listDisplayed = FXCollections.observableArrayList();
    protected LinkedList<Entity> listAll;
    protected Map<Class, Spec> mapSpec = new HashMap<Class, Spec>();

    protected EntityTable() {
        this.table = new TableView();
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.filterField = new TextField();
        this.filterField.setPromptText("Filter");
        this.filterField.textProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldVal, Object newVal) {
                EntityTable.this.filter((String)newVal);
            }
        });
        VBox.setVgrow(this.table, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.filterField, this.table});
    }

    public EntityTable(GUIListener callback) {
        this();
        this.listener = callback;
    }

    public void addSpec(Spec ... specList) {
        for (Spec spec : specList) {
            this.mapSpec.put(spec.getEntityClass(), spec);
        }
    }

    public void bind(Class<? extends HBAbstractEntity> cls, Map<SpecElement, Integer> widthMap) {
        this.columnList = new ArrayList<TableColumn>();
        Spec spec = this.mapSpec.get(cls);
        if (spec == null) {
            spec = new Spec(cls);
            spec.buildDefaultEmbedded();
            this.mapSpec.put(spec.getEntityClass(), spec);
        }
        for (SpecElement specElement : spec.getEmbedded()) {
            Integer width;
            TableColumn col = new TableColumn(specElement.getDisplayName());
            StringConverter sf = spec.getStringFactoryFor(specElement);
            col.setCellValueFactory(new EntityPropertyValueFactory(specElement.getName(), sf));
            if (widthMap != null && (width = widthMap.get(specElement)) != null) {
                col.setPrefWidth((double)width.intValue());
            }
            col.setCellFactory(TextFieldTableCell.forTableColumn());
            this.columnList.add(col);
        }
        this.listAll = new LinkedList();
        this.table.setItems(this.listDisplayed);
        this.table.getColumns().addAll((Object[])this.columnList.toArray(new TableColumn[0]));
        this.table.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    Entity item = (Entity)EntityTable.this.table.getSelectionModel().getSelectedItem();
                    EntityTable.this.listener.dispatch(new GUIEvent((Object)EntityTable.this, "default", (Object)item));
                }
            }
        });
    }

    public void bind(Class<? extends HBAbstractEntity> cls) {
        this.bind(cls, null);
    }

    public Entity getSelectedEntity() {
        return (Entity)this.table.getSelectionModel().getSelectedItem();
    }

    private boolean contains(Entity en, String searchTxt) {
        for (TableColumn col : this.table.getColumns()) {
            Object value = col.getCellData((Object)en);
            if (value == null || !value.toString().toLowerCase().contains(searchTxt)) continue;
            return true;
        }
        return false;
    }

    public void filter(String txt) {
        txt = txt.toLowerCase();
        LinkedList<Entity> tempList = new LinkedList<Entity>();
        for (Entity en : this.listAll) {
            if (!this.contains(en, txt)) continue;
            tempList.add(en);
        }
        this.listDisplayed.clear();
        this.listDisplayed.setAll(tempList);
    }

    public List<Entity> getItems() {
        return this.listAll;
    }

    public void itemsReset() {
        this.listAll.clear();
        this.listDisplayed.clear();
    }

    public void itemsAddAll(List<? extends Entity> list) {
        if (!this.filterField.getText().isEmpty()) {
            String txt = this.filterField.getText().toLowerCase();
            for (Entity entity : list) {
                if (entity.toString().toLowerCase().contains(txt)) {
                    this.listDisplayed.add((Object)entity);
                }
                this.listAll.add(entity);
            }
        } else {
            this.listAll.addAll(list);
            this.listDisplayed.addAll(list);
        }
    }

    public void itemAdd(Entity entity) {
        if (!this.filterField.getText().isEmpty()) {
            String txt = this.filterField.getText().toLowerCase();
            if (entity.toString().toLowerCase().contains(txt)) {
                this.listDisplayed.add((Object)entity);
            }
            this.listAll.add(entity);
        } else {
            this.listAll.add(entity);
            this.listDisplayed.add((Object)entity);
        }
    }
}

