/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view;

import java.util.List;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.entity.SpecElement;
import myencyclopedia.common.gui.entity.SpecProperty;
import myencyclopedia.common.gui.entity.SpecRelation;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.model.Entity;
import myencyclopedia.model.Relation;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.common.StringConverter;

public abstract class AbstractEditorRenderer
implements Cloneable {
    protected boolean isRenderer = true;
    protected StringConverter stringConverter;
    protected Entity entity;
    protected SpecElement specEle;
    protected boolean allowEditor;
    protected EntityView owner;

    public void setEntityView(EntityView owner) {
        this.owner = owner;
    }

    public void bind(Entity entity, SpecElement specElement) {
        this.entity = entity;
        this.specEle = specElement;
    }

    public void bind(Entity entity) {
        this.entity = entity;
    }

    public void setMode(boolean isRenderer) {
        if (!isRenderer && !this.allowEditor) {
            return;
        }
        this.isRenderer = isRenderer;
        this.owner.setActiveAbstractEditorRenderer(isRenderer ? null : this);
        this.postSetMode(isRenderer);
    }

    public String fromObjToString(Object obj) {
        if (this.stringConverter != null) {
            return this.stringConverter.toString(obj);
        }
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public Object fromStringToObj(String str) throws StringConverter.ConversionException {
        if (this.stringConverter != null) {
            return this.stringConverter.fromString(str);
        }
        return str;
    }

    public void postSetMode(boolean isRenderer) {
    }

    public void allowEditor(boolean allow) {
        this.allowEditor = allow;
    }

    public abstract Region getComponent();

    public abstract void loadObject(Object var1);

    public abstract boolean forceCommit();

    public void validateAndCommit(Object input) throws StringConverter.ConversionException {
        Object obj = input;
        if (this.stringConverter != null && input != null) {
            obj = this.stringConverter.fromString(input.toString());
        }
        this.commit(obj);
    }

    public void commit(Object obj) {
        String propName = this.specEle.getName();
        if (this.specEle instanceof SpecProperty) {
            this.entity.setPropertyValue(propName, obj);
        } else {
            SpecRelation specR = (SpecRelation)this.specEle;
            if (specR.isCollection()) {
                RelationCollection r = (RelationCollection)this.entity.getRelation(this.specEle.getName());
                if (obj instanceof List) {
                    r.setTargets((List)obj);
                } else if (obj instanceof Object[]) {
                    r.setTargets((Entity[])obj);
                }
            } else {
                Relation r = this.entity.getRelation(this.specEle.getName());
                r.setTarget(obj);
            }
        }
        this.owner.notifyCommittedEvent(this.specEle);
    }

    public void setStringConverter(StringConverter converter) {
        this.stringConverter = converter;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }
}

