/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.EntityValidator;
import myencyclopedia.common.gui.entity.Spec;
import myencyclopedia.common.gui.entity.SpecElement;
import myencyclopedia.common.gui.entity.SpecProperty;
import myencyclopedia.common.gui.entity.SpecRelation;
import myencyclopedia.common.gui.entity.converter.DoubleConverter;
import myencyclopedia.common.gui.entity.converter.FloatConverter;
import myencyclopedia.common.gui.entity.converter.IntegerConverter;
import myencyclopedia.common.gui.entity.converter.LongConverter;
import myencyclopedia.common.gui.entity.converter.ShortConverter;
import myencyclopedia.common.gui.entity.view.AbstractClassPane;
import myencyclopedia.common.gui.entity.view.AbstractEditor;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.common.gui.entity.view.AbstractRenderer;
import myencyclopedia.common.gui.entity.view.AbstractStageEditor;
import myencyclopedia.common.gui.entity.view.Editor;
import myencyclopedia.common.gui.entity.view.EntityAndSpecEle;
import myencyclopedia.common.gui.entity.view.Mapping;
import myencyclopedia.common.gui.entity.view.RegistryAER;
import myencyclopedia.common.gui.entity.view.RegistryComposition;
import myencyclopedia.common.gui.entity.view.Renderer;
import myencyclopedia.common.gui.entity.view.predefined.CheckBoxEditor;
import myencyclopedia.common.gui.entity.view.predefined.CheckBoxEditorRenderer;
import myencyclopedia.common.gui.entity.view.predefined.CheckBoxRenderer;
import myencyclopedia.common.gui.entity.view.predefined.ListViewEditor;
import myencyclopedia.common.gui.entity.view.predefined.ListViewEditorRenderer;
import myencyclopedia.common.gui.entity.view.predefined.ListViewRenderer;
import myencyclopedia.common.gui.entity.view.predefined.TextFieldEditor;
import myencyclopedia.common.gui.entity.view.predefined.TextFieldEditorRenderer;
import myencyclopedia.common.gui.entity.view.predefined.TextFieldRenderer;
import myencyclopedia.model.Entity;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.common.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityView<T extends Entity>
extends BorderPane {
    protected Map<Class, Spec> mapClassToSpec;
    protected VBox vbox;
    protected GUIListener listener;
    protected boolean needRebuild = true;
    protected Class lastEntityClass;
    protected Map<Label, EntityAndSpecEle> mapLabel;
    protected static final Logger logger = LoggerFactory.getLogger(EntityView.class);
    protected Map<SpecElement, Editor> mapSpecToEditor;
    protected Map<SpecElement, AbstractEditorRenderer> mapSpecToEditorRenderer;
    protected Map<SpecElement, Renderer> mapSpecToRenderer;
    protected Map<Class, AbstractClassPane> mapClassToPane;
    protected T theEntity;
    protected boolean collapsible = true;
    protected boolean hasError = false;
    protected boolean displayEntityToString = false;
    protected TitledPane rootTp;
    protected RegistryAER regAER = new RegistryAER();
    protected RegistryComposition registryComposition = new RegistryComposition();
    private static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-entity");
    private Map<SpecRelation, DELETE_BUTTON_POLICY> mapDeletePolicy;
    private Map<SpecRelation, List<Object>> mapNewlyCreated;
    public static final String EVENT_UPDATED = "EntityView_updated";
    public static final String EVENT_ADD = "EntityView_add";
    public static final String EVENT_DELETE = "EntityView_delete";
    public static final String EVENT_COMMITTED = "EntityView_committed";
    protected Editor activeEditor = null;
    protected AbstractEditorRenderer activeEditorRenderer = null;
    protected EntityValidator entityValidator;

    public EntityView() {
        this.mapClassToSpec = new HashMap<Class, Spec>();
        this.vbox = new VBox();
        this.setCenter((Node)this.vbox);
        this.mapLabel = new HashMap<Label, EntityAndSpecEle>();
        this.mapSpecToRenderer = new HashMap<SpecElement, Renderer>();
        this.mapSpecToEditor = new HashMap<SpecElement, Editor>();
        this.mapSpecToEditorRenderer = new HashMap<SpecElement, AbstractEditorRenderer>();
        this.mapClassToPane = new HashMap<Class, AbstractClassPane>();
        this.mapDeletePolicy = new HashMap<SpecRelation, DELETE_BUTTON_POLICY>();
    }

    public EntityView(Class cls) {
        this(new Spec(cls).buildDefaultEmbedded());
    }

    public EntityView(Spec ... specList) {
        this();
        for (Spec spec : specList) {
            this.mapClassToSpec.put(spec.getEntityClass(), spec);
        }
    }

    public void addSpec(Spec ... specList) {
        for (Spec spec : specList) {
            this.mapClassToSpec.put(spec.getEntityClass(), spec);
        }
        this.needRebuild = true;
    }

    public void setEntityValidator(EntityValidator validator) {
        this.entityValidator = validator;
    }

    public void setGUIListener(GUIListener listener) {
        this.listener = listener;
    }

    public void setEntity(T entity) {
        this.theEntity = entity;
        this.mapNewlyCreated = new HashMap<SpecRelation, List<Object>>();
        Spec spec = this.mapClassToSpec.get(entity.getClass());
        if (spec.getStandAlone().length > 0 || this.needRebuild || !entity.getClass().equals(this.lastEntityClass)) {
            this.buildComponents(entity);
        } else {
            this.rootTp.setText(spec.getDisplayName());
            if (this.displayEntityToString) {
                this.rootTp.setText(this.rootTp.getText() + ": " + entity.toString());
            }
            for (EntityAndSpecEle tuple : this.mapLabel.values()) {
                tuple.entity = entity;
            }
            this.regAER.reloadAllRenderers((Entity)entity);
            this.registryComposition.reloadAllRenderers((Entity)entity);
            this.clearError();
        }
    }

    public Entity getEntity() {
        return this.theEntity;
    }

    public boolean validateEntity() {
        this.clearError();
        if (this.activeEditorRenderer != null && !this.activeEditorRenderer.forceCommit()) {
            EntityValidator.ValidationError error = new EntityValidator.ValidationError(this.activeEditorRenderer.entity, this.activeEditorRenderer.specEle.getName(), "Cannot commit");
            this.markError(error);
            return false;
        }
        if (this.activeEditor != null && !this.activeEditor.forceCommit()) {
            AbstractEditor editor = (AbstractEditor)this.activeEditor;
            EntityValidator.ValidationError error = new EntityValidator.ValidationError(editor.entity, editor.specEle.getName(), "Cannot commit");
            this.markError(error);
            return false;
        }
        if (this.entityValidator == null) {
            return true;
        }
        List<EntityValidator.ValidationError> ret = this.entityValidator.validate(this.theEntity);
        if (ret == null) {
            return true;
        }
        for (EntityValidator.ValidationError error : ret) {
            this.markError(error);
        }
        return false;
    }

    public EntityView addMapping(SpecElement specElement, Mapping mapping) {
        if (mapping.getEditorRenderer() != null) {
            this.mapSpecToEditorRenderer.put(specElement, mapping.getEditorRenderer());
        }
        if (mapping.getEditor() != null) {
            this.mapSpecToEditor.put(specElement, mapping.getEditor());
        }
        if (mapping.getRenderer() != null) {
            this.mapSpecToRenderer.put(specElement, mapping.getRenderer());
        }
        this.needRebuild = true;
        return this;
    }

    public void setMapping(HashMap<SpecElement, Mapping> mapping) {
        for (Map.Entry<SpecElement, Mapping> entry : mapping.entrySet()) {
            this.addMapping(entry.getKey(), entry.getValue());
        }
        this.needRebuild = true;
    }

    public EntityView setClassPane(Class cls, AbstractClassPane p) {
        this.mapClassToPane.put(cls, p);
        return this;
    }

    public EntityView setRenderer(SpecElement specEle, Renderer r) {
        this.mapSpecToRenderer.put(specEle, r);
        this.needRebuild = true;
        return this;
    }

    public EntityView setEditorRenderer(SpecElement specEle, AbstractEditorRenderer r) {
        this.mapSpecToEditorRenderer.put(specEle, r);
        this.needRebuild = true;
        return this;
    }

    public EntityView setEditor(SpecElement specEle, Editor editor) {
        this.mapSpecToEditor.put(specEle, editor);
        this.needRebuild = true;
        return this;
    }

    public void setCollapsible(boolean option) {
        this.needRebuild = true;
        this.collapsible = option;
    }

    public void setDeleteButtonPolicy(SpecRelation specRelation, DELETE_BUTTON_POLICY policy) {
        this.mapDeletePolicy.put(specRelation, policy);
    }

    public List getNewlyCreatedObjects(SpecRelation specRelation) {
        return this.mapNewlyCreated.get(specRelation);
    }

    public void enableDisplayEntityToString(boolean enable) {
        this.displayEntityToString = enable;
    }

    protected void clearError() {
        if (this.hasError) {
            for (Label lbl : this.mapLabel.keySet()) {
                lbl.setTooltip(null);
                lbl.setBackground(Background.EMPTY);
            }
            this.hasError = false;
        }
    }

    protected void markError(EntityValidator.ValidationError error) {
        this.hasError = true;
        Class<?> cls = error.getEntity().getClass();
        Spec spec = this.mapClassToSpec.get(cls);
        if (spec == null) {
            return;
        }
        SpecElement ele = spec.get(error.getCompName());
        if (ele == null) {
            return;
        }
        for (Map.Entry<Label, EntityAndSpecEle> entry : this.mapLabel.entrySet()) {
            if (entry.getValue().entity != error.getEntity() || !entry.getValue().specEle.equals(ele)) continue;
            Label lbl = entry.getKey();
            Tooltip tooltip = new Tooltip();
            tooltip.setText(error.getErrorMessage());
            lbl.setTooltip(tooltip);
            lbl.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.RED, null, null)}));
        }
    }

    public void refresh(Entity entity, SpecElement specElement) {
        if (!this.registryComposition.reloadRenderer(entity, specElement)) {
            this.regAER.reloadRenderer(entity, specElement);
        }
    }

    public void switchToEditor(final Renderer renderer) {
        final RegistryComposition.EditorAndRendererRegistry registry = this.registryComposition.get(renderer);
        final Editor editor = registry.getEditor();
        if (editor == null) {
            return;
        }
        editor.bind(registry.getEntity(), registry.getSpecEle());
        this.activeEditor = editor;
        if (editor instanceof AbstractStageEditor) {
            AbstractStageEditor stageEditor = (AbstractStageEditor)editor;
            Object obj = this.registryComposition.getAssociatedValue(renderer);
            stageEditor.loadEditorObject(obj);
            stageEditor.show();
            stageEditor.activate();
        } else {
            renderer.beginRendererTransition();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    GridPane grid = registry.getGrid();
                    grid.getChildren().remove((Object)renderer.getRendererControl());
                    grid.add((Node)editor.getEditorControl(), 1, registry.getIndex());
                    Object obj = EntityView.this.registryComposition.getAssociatedValue(renderer);
                    editor.loadEditorObject(obj);
                }
            });
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    renderer.endRendererTransition();
                }
            });
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    editor.activate();
                }
            });
        }
    }

    public void switchToRenderer(final Editor editor, final Entity entity) {
        final RegistryComposition.EditorAndRendererRegistry registry = this.registryComposition.get(editor, entity);
        final Renderer renderer = registry.getRenderer();
        this.activeEditor = null;
        if (editor instanceof AbstractStageEditor) {
            Object obj = this.registryComposition.getAssociatedValue(editor, entity);
            renderer.loadRendererObject(obj);
        } else {
            editor.beginEditorTransition();
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    GridPane grid = registry.getGrid();
                    grid.getChildren().remove((Object)editor.getEditorControl());
                    grid.add((Node)renderer.getRendererControl(), 1, registry.getIndex());
                    Object obj = EntityView.this.registryComposition.getAssociatedValue(editor, entity);
                    renderer.loadRendererObject(obj);
                }
            });
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    editor.endEditorTransition();
                }
            });
        }
    }

    void setActiveAbstractEditorRenderer(AbstractEditorRenderer editorRenderer) {
        this.activeEditorRenderer = editorRenderer;
    }

    void notifyCommittedEvent(SpecElement specEle) {
        if (this.listener != null) {
            this.listener.dispatch(new GUIEvent((Object)this, EVENT_COMMITTED, (Object)specEle));
        }
    }

    private TitledPane mapEntity(Entity entity, Spec spec, SpecRelation relation, boolean hasControlBtn) {
        TitledPane tp = new TitledPane();
        tp.setText(spec.getDisplayName());
        if (this.displayEntityToString) {
            tp.setText(tp.getText() + ": " + entity.toString());
        }
        tp.setCollapsible(this.collapsible);
        if (this.mapClassToPane.containsKey(entity.getClass())) {
            AbstractClassPane classPane = null;
            try {
                classPane = this.mapClassToPane.get(entity.getClass()).clone();
            }
            catch (CloneNotSupportedException ex) {
                logger.error("", (Throwable)ex);
            }
            classPane.setObject(entity);
            Pane pane = classPane.getPane();
            Button btnDelete = this.addDeleteButtonIfNecessary(tp, entity, relation, hasControlBtn);
            BorderPane borderPane = new BorderPane();
            borderPane.setCenter((Node)pane);
            if (btnDelete != null) {
                borderPane.setBottom((Node)btnDelete);
            }
            tp.setContent((Node)borderPane);
            return tp;
        }
        GridPane grid = new GridPane();
        ColumnConstraints column1 = new ColumnConstraints();
        ColumnConstraints column2 = new ColumnConstraints();
        column2.setHgrow(Priority.ALWAYS);
        grid.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        int i = 0;
        for (SpecElement specElement : spec.getEmbedded()) {
            String name = specElement.getName();
            Object obj = null;
            obj = specElement instanceof SpecProperty ? entity.getPropertyValue(name) : entity.getRelation(name).getTarget();
            Label lblPropName = new Label(specElement.getDisplayName());
            lblPropName.setBackground(Background.EMPTY);
            this.putToMapLabel(entity, specElement, lblPropName);
            grid.add((Node)lblPropName, 0, i);
            StringConverter converter = spec.getStringFactoryFor(specElement);
            AbstractEditorRenderer editorRenderer = this.mapSpecToEditorRenderer.get(specElement);
            if (editorRenderer == null) {
                if (specElement.isModifiable() && this.mapSpecToEditor.get(specElement) == null && this.mapSpecToRenderer.get(specElement) == null) {
                    editorRenderer = this.getDefaultEditorRenderer(specElement);
                }
            } else if (hasControlBtn) {
                try {
                    editorRenderer = (AbstractEditorRenderer)editorRenderer.clone();
                }
                catch (CloneNotSupportedException ex) {
                    logger.error("AbstractEditorRenderer cannot be cloned", (Throwable)ex);
                }
            }
            if (editorRenderer != null) {
                this.regAER.register(editorRenderer, entity, specElement);
                editorRenderer.setEntityView(this);
                editorRenderer.allowEditor(specElement.isModifiable());
                editorRenderer.getComponent().setId("re_" + name);
                editorRenderer.bind(entity, specElement);
                editorRenderer.setMode(true);
                if (converter != null) {
                    editorRenderer.setStringConverter(converter);
                }
                editorRenderer.loadObject(obj);
                grid.add((Node)editorRenderer.getComponent(), 1, i);
                ++i;
                continue;
            }
            Renderer renderer = this.mapSpecToRenderer.get(specElement);
            Editor editor = this.mapSpecToEditor.get(specElement);
            if (renderer == null) {
                renderer = this.getDefaultRenderer(specElement);
            } else if (hasControlBtn) {
                try {
                    renderer = (Renderer)renderer.clone();
                }
                catch (CloneNotSupportedException ex) {
                    logger.error("Renderer cannot be cloned", (Throwable)ex);
                }
            }
            if (editor == null && specElement.isModifiable()) {
                editor = this.getDefaultEditor(specElement);
            }
            if (converter != null) {
                renderer.setStringConverter(converter);
                if (editor != null) {
                    editor.setStringConverter(converter);
                }
            }
            Region rendererComponent = renderer.getRendererControl();
            Region editorComponent = editor == null ? null : editor.getEditorControl();
            rendererComponent.setId("r_" + name);
            if (editorComponent != null) {
                editorComponent.setId("e_" + name);
            }
            renderer.loadRendererObject(obj);
            this.registryComposition.register(renderer, editor, entity, specElement, grid, i);
            renderer.setEntityView(this);
            if (editor != null) {
                editor.bind(entity, specElement);
                editor.setEntityView(this);
            }
            if (editorComponent == null || editorComponent instanceof Control || editorComponent instanceof Pane) {
                // empty if block
            }
            grid.add((Node)rendererComponent, 1, i);
            ++i;
        }
        Button btnDelete = this.addDeleteButtonIfNecessary(tp, entity, relation, hasControlBtn);
        if (btnDelete != null) {
            grid.add((Node)btnDelete, 0, i);
        }
        tp.setContent((Node)grid);
        return tp;
    }

    private Button addDeleteButtonIfNecessary(final TitledPane tp, final Entity entity, final SpecRelation relation, boolean hasControlBtn) {
        if (hasControlBtn) {
            boolean isDeleteBtnEnabled = false;
            if (DELETE_BUTTON_POLICY.SHOW_NEW.equals((Object)this.mapDeletePolicy.get(relation))) {
                List<Object> newCreatedList = this.mapNewlyCreated.get(relation);
                if (newCreatedList != null) {
                    for (Object obj : newCreatedList) {
                        if (obj != entity) continue;
                        isDeleteBtnEnabled = true;
                        break;
                    }
                } else {
                    isDeleteBtnEnabled = false;
                }
            } else {
                isDeleteBtnEnabled = true;
            }
            if (isDeleteBtnEnabled) {
                Button btnDelete = new Button(rb.getString("EntityView.Delete"));
                btnDelete.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent e) {
                        Boolean allowed = (Boolean)EntityView.this.listener.dispatch(new GUIEvent((Object)EntityView.this, EntityView.EVENT_DELETE, (Object)entity));
                        if (Boolean.FALSE.equals(allowed)) {
                            return;
                        }
                        EntityView.this.vbox.getChildren().remove((Object)tp);
                        RelationCollection r = (RelationCollection)EntityView.this.theEntity.getRelation(relation.getName());
                        r.removeTarget(entity);
                    }
                });
                return btnDelete;
            }
        }
        return null;
    }

    private void buildComponents(T entity) {
        TitledPane tp;
        this.mapLabel = new HashMap<Label, EntityAndSpecEle>();
        this.needRebuild = false;
        this.lastEntityClass = entity.getClass();
        this.vbox.getChildren().clear();
        this.registryComposition.reset();
        this.regAER.reset();
        Spec spec = this.mapClassToSpec.get(entity.getClass());
        this.rootTp = tp = this.mapEntity((Entity)entity, spec, null, false);
        this.vbox.getChildren().add((Object)tp);
        SpecRelation[] moreRelations = spec.getStandAlone();
        if (moreRelations.length == 0) {
            return;
        }
        for (final SpecRelation relation : moreRelations) {
            Spec rSpec;
            Object obj = entity.getRelation(relation.getName()).getTarget();
            if (relation.isDislayChildren()) {
                Object[] list;
                Button btnAdd = new Button(rb.getString("EntityView.Add") + relation.getDisplayName());
                btnAdd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent e) {
                        Object newObj = EntityView.this.listener.dispatch(new GUIEvent((Object)EntityView.this, EntityView.EVENT_ADD, (Object)relation));
                        if (newObj == null) {
                            return;
                        }
                        ArrayList<Object> lst = (ArrayList<Object>)EntityView.this.mapNewlyCreated.get(relation);
                        if (lst == null) {
                            lst = new ArrayList<Object>();
                            EntityView.this.mapNewlyCreated.put(relation, lst);
                        }
                        lst.add(newObj);
                        Spec subSpec = EntityView.this.mapClassToSpec.get(newObj.getClass());
                        if (subSpec != null) {
                            TitledPane pane = EntityView.this.mapEntity((Entity)newObj, subSpec, relation, true);
                            EntityView.this.vbox.getChildren().add((Object)pane);
                        }
                    }
                });
                this.vbox.getChildren().add((Object)new Separator());
                this.vbox.getChildren().add((Object)btnAdd);
                if (obj == null) continue;
                for (Object sub : list = (Object[])obj) {
                    Spec subSpec = this.mapClassToSpec.get(sub.getClass());
                    if (subSpec == null) continue;
                    TitledPane pane = this.mapEntity((Entity)sub, subSpec, relation, true);
                    this.vbox.getChildren().add((Object)pane);
                }
                continue;
            }
            if (obj == null || (rSpec = this.mapClassToSpec.get(obj.getClass())) == null) continue;
            this.mapEntity((Entity)obj, rSpec, null, false);
        }
    }

    private void putToMapLabel(Entity en, SpecElement element, Label lbl) {
        EntityAndSpecEle tuple = new EntityAndSpecEle(en, element);
        this.mapLabel.put(lbl, tuple);
    }

    public AbstractEditorRenderer getDefaultEditorRenderer(SpecElement specElement) {
        if (specElement instanceof SpecProperty) {
            SpecProperty prop = (SpecProperty)specElement;
            if (Boolean.class.equals((Object)prop.getType())) {
                return new CheckBoxEditorRenderer();
            }
            if (List.class.equals((Object)prop.getType())) {
                return new ListViewEditorRenderer();
            }
            TextFieldEditorRenderer tf = new TextFieldEditorRenderer();
            Object converter = null;
            if (Integer.class.equals((Object)prop.getType())) {
                converter = IntegerConverter.getConverter(true);
            } else if (Long.class.equals((Object)prop.getType())) {
                converter = LongConverter.getConverter(true);
            } else if (Short.class.equals((Object)prop.getType())) {
                converter = ShortConverter.getConverter(true);
            } else if (Float.class.equals((Object)prop.getType())) {
                converter = FloatConverter.getConverter(true);
            } else if (Double.class.equals((Object)prop.getType())) {
                converter = DoubleConverter.getConverter(true);
            }
            tf.setStringConverter((StringConverter)converter);
            return tf;
        }
        SpecRelation rel = (SpecRelation)specElement;
        if (rel.isCollection()) {
            return new ListViewEditorRenderer();
        }
        return new TextFieldEditorRenderer();
    }

    public AbstractEditor getDefaultEditor(SpecElement specElement) {
        if (specElement instanceof SpecProperty) {
            SpecProperty prop = (SpecProperty)specElement;
            if (Boolean.class.equals((Object)prop.getType())) {
                return new CheckBoxEditor();
            }
            if (List.class.equals((Object)prop.getType())) {
                return new ListViewEditor();
            }
            TextFieldEditor editor = new TextFieldEditor();
            Object converter = null;
            if (Integer.class.equals((Object)prop.getType())) {
                converter = IntegerConverter.getConverter(true);
            } else if (Long.class.equals((Object)prop.getType())) {
                converter = LongConverter.getConverter(true);
            } else if (Short.class.equals((Object)prop.getType())) {
                converter = ShortConverter.getConverter(true);
            } else if (Float.class.equals((Object)prop.getType())) {
                converter = FloatConverter.getConverter(true);
            } else if (Double.class.equals((Object)prop.getType())) {
                converter = DoubleConverter.getConverter(true);
            }
            editor.setStringConverter((StringConverter)converter);
            return editor;
        }
        SpecRelation rel = (SpecRelation)specElement;
        if (rel.isCollection()) {
            return new ListViewEditor();
        }
        return new TextFieldEditor();
    }

    public AbstractRenderer getDefaultRenderer(SpecElement specElement) {
        if (specElement instanceof SpecProperty) {
            SpecProperty prop = (SpecProperty)specElement;
            if (Boolean.class.equals((Object)prop.getType())) {
                return new CheckBoxRenderer();
            }
            if (List.class.equals((Object)prop.getType())) {
                return new ListViewRenderer();
            }
            return new TextFieldRenderer();
        }
        SpecRelation rel = (SpecRelation)specElement;
        if (rel.isCollection()) {
            return new ListViewRenderer();
        }
        return new TextFieldRenderer();
    }

    public static enum DELETE_BUTTON_POLICY {
        SHOW_ALWAYS,
        SHOW_NEW;

    }
}

