/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view;

import java.util.HashMap;
import java.util.Map;
import myencyclopedia.common.gui.entity.SpecElement;
import myencyclopedia.common.gui.entity.SpecProperty;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.model.Entity;

class RegistryAER {
    private Map<AbstractEditorRenderer, AbstractEditorRendererRegistry> map = new HashMap<AbstractEditorRenderer, AbstractEditorRendererRegistry>();

    RegistryAER() {
    }

    public void register(AbstractEditorRenderer editorRenderer, Entity entity, SpecElement specEle) {
        AbstractEditorRendererRegistry registry = new AbstractEditorRendererRegistry(editorRenderer, entity, specEle);
        this.map.put(editorRenderer, registry);
    }

    public Object getAssociatedValue(AbstractEditorRenderer editorRenderer) {
        AbstractEditorRendererRegistry registry = this.map.get(editorRenderer);
        if (registry.specEle instanceof SpecProperty) {
            return registry.entity.getPropertyValue(registry.specEle.getName());
        }
        return registry.entity.getRelation(registry.specEle.getName()).getTarget();
    }

    public boolean reloadRenderer(Entity entity, SpecElement specElement) {
        AbstractEditorRenderer er = null;
        for (Map.Entry<AbstractEditorRenderer, AbstractEditorRendererRegistry> entry : this.map.entrySet()) {
            AbstractEditorRendererRegistry registry = entry.getValue();
            if (registry.entity != entity || !registry.specEle.equals(specElement)) continue;
            er = entry.getKey();
        }
        if (er != null) {
            er.loadObject(this.getAssociatedValue(er));
            return true;
        }
        return false;
    }

    public void reloadAllRenderers(Entity entity) {
        for (Map.Entry<AbstractEditorRenderer, AbstractEditorRendererRegistry> entry : this.map.entrySet()) {
            AbstractEditorRendererRegistry registry = entry.getValue();
            registry.editorRenderer.bind(entity);
            registry.entity = entity;
        }
        for (AbstractEditorRenderer er : this.map.keySet()) {
            er.loadObject(this.getAssociatedValue(er));
        }
    }

    public void reset() {
        this.map = new HashMap<AbstractEditorRenderer, AbstractEditorRendererRegistry>();
    }

    class AbstractEditorRendererRegistry {
        private AbstractEditorRenderer editorRenderer;
        private Entity entity;
        private SpecElement specEle;

        AbstractEditorRendererRegistry(AbstractEditorRenderer editorRenderer, Entity entity, SpecElement specEle) {
            this.editorRenderer = editorRenderer;
            this.entity = entity;
            this.specEle = specEle;
        }
    }
}

