/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view;

import java.util.HashMap;
import java.util.Map;
import javafx.scene.layout.GridPane;
import myencyclopedia.common.gui.entity.SpecElement;
import myencyclopedia.common.gui.entity.SpecProperty;
import myencyclopedia.common.gui.entity.view.Editor;
import myencyclopedia.common.gui.entity.view.Renderer;
import myencyclopedia.model.Entity;

class RegistryComposition {
    private Map<Renderer, EditorAndRendererRegistry> map = new HashMap<Renderer, EditorAndRendererRegistry>();

    RegistryComposition() {
    }

    public void register(Renderer renderer, Editor editor, Entity entity, SpecElement specEle, GridPane grid, int idx) {
        EditorAndRendererRegistry registry = new EditorAndRendererRegistry(renderer, editor, entity, specEle, grid, idx);
        this.map.put(renderer, registry);
    }

    public boolean reloadRenderer(Entity entity, SpecElement specElement) {
        Renderer r = null;
        for (Map.Entry<Renderer, EditorAndRendererRegistry> entry : this.map.entrySet()) {
            EditorAndRendererRegistry registry = entry.getValue();
            if (registry.entity != entity || !registry.specEle.equals(specElement)) continue;
            r = entry.getKey();
        }
        if (r != null) {
            r.loadRendererObject(this.getAssociatedValue(r));
            return true;
        }
        return false;
    }

    public void reloadAllRenderers(Entity entity) {
        for (Map.Entry<Renderer, EditorAndRendererRegistry> entry : this.map.entrySet()) {
            EditorAndRendererRegistry registry = entry.getValue();
            registry.entity = entity;
        }
        for (Renderer r : this.map.keySet()) {
            r.loadRendererObject(this.getAssociatedValue(r));
        }
    }

    public Object getAssociatedValue(Renderer renderer) {
        EditorAndRendererRegistry registry = this.map.get(renderer);
        if (registry.specEle instanceof SpecProperty) {
            return registry.entity.getPropertyValue(registry.specEle.getName());
        }
        return registry.entity.getRelation(registry.specEle.getName()).getTarget();
    }

    public Object getAssociatedValue(Editor editor, Entity entity) {
        EditorAndRendererRegistry registry = this.get(editor, entity);
        if (registry.specEle instanceof SpecProperty) {
            return registry.entity.getPropertyValue(registry.specEle.getName());
        }
        return registry.entity.getRelation(registry.specEle.getName()).getTarget();
    }

    public EditorAndRendererRegistry get(Renderer renderer) {
        return this.map.get(renderer);
    }

    public EditorAndRendererRegistry get(Editor editor, Entity entity) {
        for (EditorAndRendererRegistry registry : this.map.values()) {
            if (registry.editor != editor || registry.entity != entity) continue;
            return registry;
        }
        return null;
    }

    public void reset() {
        this.map = new HashMap<Renderer, EditorAndRendererRegistry>();
    }

    public class EditorAndRendererRegistry {
        public final Renderer renderer;
        public final Editor editor;
        public final int index;
        public final GridPane grid;
        public Entity entity;
        public final SpecElement specEle;

        public EditorAndRendererRegistry(Renderer renderer, Editor editor, Entity entity, SpecElement specEle, GridPane grid, int idx) {
            this.renderer = renderer;
            this.editor = editor;
            this.grid = grid;
            this.index = idx;
            this.entity = entity;
            this.specEle = specEle;
        }

        public Renderer getRenderer() {
            return this.renderer;
        }

        public Editor getEditor() {
            return this.editor;
        }

        public int getIndex() {
            return this.index;
        }

        public GridPane getGrid() {
            return this.grid;
        }

        public Entity getEntity() {
            return this.entity;
        }

        public SpecElement getSpecEle() {
            return this.specEle;
        }
    }
}

