/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view.predefined;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.entity.ObjectWrapper;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.model.common.StringConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListViewEditorRenderer
extends AbstractEditorRenderer {
    protected ListView list = new ListView();
    protected TextField input = new TextField();
    final int ROW_HEIGHT = 24;
    protected BorderPane pane = new BorderPane();
    private static final Logger logger = LoggerFactory.getLogger(ListViewEditorRenderer.class);

    public ListViewEditorRenderer() {
        this.list.setPrefHeight(74.0);
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    Object obj = ListViewEditorRenderer.this.list.getSelectionModel().getSelectedItem();
                    ListViewEditorRenderer.this.list.getItems().remove(obj);
                }
            }
        });
        this.input.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                event.getCode();
                if (keyCode.equals((Object)KeyCode.ENTER)) {
                    String str = ListViewEditorRenderer.this.input.getText();
                    Object obj = null;
                    try {
                        obj = ListViewEditorRenderer.this.fromStringToObj(str);
                    }
                    catch (StringConverter.ConversionException ex) {
                        logger.error("", (Throwable)ex);
                        return;
                    }
                    if (obj != null) {
                        str = ListViewEditorRenderer.this.fromObjToString(obj);
                        ObjectWrapper<Object> wrapper = new ObjectWrapper<Object>(obj, str);
                        ListViewEditorRenderer.this.list.getItems().add(wrapper);
                    }
                }
            }
        });
        this.input.focusedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue.equals(false) && !ListViewEditorRenderer.this.isRenderer) {
                    ListViewEditorRenderer.this.forceCommit();
                } else if (newValue.equals(true) && ListViewEditorRenderer.this.isRenderer) {
                    ListViewEditorRenderer.this.setMode(false);
                }
            }
        });
        this.pane.setCenter((Node)this.list);
        this.pane.setTop((Node)this.input);
    }

    @Override
    public boolean forceCommit() {
        ArrayList newLst = null;
        ObservableList lst = this.list.getItems();
        newLst = new ArrayList();
        for (ObjectWrapper wrapper : lst) {
            newLst.add(wrapper.get());
        }
        this.commit(newLst);
        this.setMode(true);
        return true;
    }

    @Override
    public Region getComponent() {
        return this.pane;
    }

    @Override
    public void loadObject(Object obj) {
        this.list.getItems().clear();
        if (obj == null) {
            return;
        }
        if (obj instanceof List) {
            List lst = (List)obj;
            for (Object element : lst) {
                String str = this.fromObjToString(element);
                ObjectWrapper wrapper = new ObjectWrapper(element, str);
                this.list.getItems().add(wrapper);
            }
        } else if (obj instanceof Object[]) {
            Object[] lst;
            for (Object element : lst = (Object[])obj) {
                String str = this.fromObjToString(element);
                ObjectWrapper<Object> wrapper = new ObjectWrapper<Object>(element, str);
                this.list.getItems().add(wrapper);
            }
        } else {
            String str = this.fromObjToString(obj);
            ObjectWrapper<Object> wrapper = new ObjectWrapper<Object>(obj, str);
            this.list.getItems().add(wrapper);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new ListViewEditorRenderer();
    }
}

