/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.entity.view.predefined;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.model.common.StringConverter;

public class TextAreaEditorRenderer
extends AbstractEditorRenderer {
    protected TextArea area = new TextArea();

    public TextAreaEditorRenderer(int preferredColumnCount, int preferredRowCount) {
        this();
        this.area.setPrefColumnCount(preferredColumnCount);
        this.area.setPrefRowCount(preferredRowCount);
    }

    public TextAreaEditorRenderer() {
        this.area.setEditable(false);
        this.area.focusedProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                if (newValue.equals(false) && !TextAreaEditorRenderer.this.isRenderer) {
                    TextAreaEditorRenderer.this.forceCommit();
                } else if (newValue.equals(true) && TextAreaEditorRenderer.this.isRenderer) {
                    TextAreaEditorRenderer.this.setMode(false);
                }
            }
        });
    }

    @Override
    public boolean forceCommit() {
        try {
            this.validateAndCommit(this.area.getText());
        }
        catch (StringConverter.ConversionException ex) {
            this.area.requestFocus();
            return false;
        }
        this.setMode(true);
        return true;
    }

    @Override
    public void postSetMode(boolean isRenderer) {
        this.area.setEditable(!isRenderer);
    }

    @Override
    public Region getComponent() {
        return this.area;
    }

    @Override
    public void loadObject(Object obj) {
        if (obj != null) {
            this.area.setText(obj.toString());
        } else {
            this.area.setText("");
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return new TextAreaEditorRenderer();
    }
}

