/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.tree;

import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.TreeCell;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.BorderPane;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.hibernate.common.OperationException;
import myencyclopedia.hibernate.common.ParentChildrenManager;
import myencyclopedia.model.Entity;

public class Tree<T extends Entity>
extends BorderPane {
    private TreeView<T> treeView;
    private ParentChildrenManager<T> mgr;
    private TreeItem<T> rootNode;
    public static final String EVENT_SELECTED = "Tree_selected";
    public static final String EVENT_ITEM_CHANGED = "Tree_item_changed";
    private GUIListener callback;
    private ContextMenu contextMenu;
    private ContextMenu rootConextMenu;
    private MenuItem pasteAsRoot;
    private MenuItem itemPaste;
    private MenuItem itemDelete;
    private TreeItem<T> cutTreeItem = null;
    private int version = -1;
    public static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-entity");

    public Tree(ParentChildrenManager<T> mgr, final GUIListener callback) {
        this.mgr = mgr;
        this.callback = callback;
        this.rootNode = new TreeItem();
        for (Entity t : mgr.getTop()) {
            TreeItem item = new TreeItem((Object)t);
            this.traverse(item);
            this.rootNode.getChildren().add((Object)item);
        }
        this.version = mgr.getVersion();
        this.rootNode.setExpanded(true);
        this.treeView = new TreeView(this.rootNode);
        this.treeView.setShowRoot(false);
        this.treeView.setEditable(true);
        this.treeView.setCellFactory(p -> new TextFieldTreeCellImpl());
        this.treeView.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                TreeItem selectedItem = (TreeItem)newValue;
                if (selectedItem != null) {
                    callback.dispatch(new GUIEvent((Object)Tree.this, Tree.EVENT_SELECTED, selectedItem.getValue()));
                }
            }
        });
        this.setCenter((Node)this.treeView);
    }

    public void sync() {
        if (this.version == this.mgr.getVersion()) {
            return;
        }
        this.rootNode = new TreeItem();
        for (Entity t : this.mgr.getTop()) {
            TreeItem item = new TreeItem((Object)t);
            this.traverse(item);
            this.rootNode.getChildren().add((Object)item);
        }
        this.version = this.mgr.getVersion();
        this.rootNode.setExpanded(true);
        this.treeView.setRoot(this.rootNode);
    }

    public void enableContextMenu() {
        this.contextMenu = new ContextMenu();
        MenuItem itemAdd = new MenuItem(rb.getString("TREE_MENU_ADD"));
        itemAdd.setOnAction(t -> {
            TextInputDialog inputDialog = new TextInputDialog("");
            inputDialog.setTitle(rb.getString("TREE_ENTER_NAME"));
            inputDialog.showAndWait();
            String name = (String)inputDialog.getResult();
            if (name == null || name.isEmpty()) {
                return;
            }
            TreeItem selectedTreeItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
            Entity parentItem = (Entity)selectedTreeItem.getValue();
            Entity item = null;
            try {
                item = this.mgr.create(parentItem, name);
            }
            catch (OperationException ex) {
                Alert alert = new Alert(Alert.AlertType.ERROR, rb.getString("TREE_ERR_DUP_NAME"), new ButtonType[0]);
                alert.showAndWait();
            }
            if (item != null) {
                TreeItem treeItem = new TreeItem((Object)item);
                selectedTreeItem.getChildren().add((Object)treeItem);
                this.callback.dispatch(new GUIEvent((Object)this, EVENT_ITEM_CHANGED, (Object)item));
            }
        });
        this.itemDelete = new MenuItem(rb.getString("TREE_MENU_DELETE"));
        this.itemDelete.setOnAction(t -> {
            TreeItem selectedTreeItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
            Entity item = (Entity)selectedTreeItem.getValue();
            try {
                this.mgr.delete(item);
                selectedTreeItem.getParent().getChildren().remove((Object)selectedTreeItem);
                this.callback.dispatch(new GUIEvent((Object)this, EVENT_ITEM_CHANGED, (Object)item));
            }
            catch (OperationException ex) {
                Alert alert = new Alert(Alert.AlertType.ERROR, rb.getString("TREE_ERR_DELETE"), new ButtonType[0]);
                alert.showAndWait();
            }
        });
        MenuItem itemRename = new MenuItem(rb.getString("TREE_MENU_RENAME"));
        itemRename.setOnAction(t -> {
            TreeItem selectedTreeItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
            Entity item = (Entity)selectedTreeItem.getValue();
            TextInputDialog d = new TextInputDialog(item.toString());
            d.setTitle(rb.getString("TREE_RENAME"));
            d.setContentText(rb.getString("TREE_NEW_NAME") + item);
            Optional result = d.showAndWait();
            if (result.isPresent() && !((String)result.get()).isEmpty()) {
                String name = (String)result.get();
                try {
                    this.mgr.rename(item, name);
                    TreeItem parent = selectedTreeItem.getParent();
                    int idx = parent.getChildren().indexOf((Object)selectedTreeItem);
                    parent.getChildren().remove(idx);
                    parent.getChildren().add(idx, (Object)selectedTreeItem);
                    this.callback.dispatch(new GUIEvent((Object)this, EVENT_ITEM_CHANGED, (Object)item));
                }
                catch (OperationException ex) {
                    Alert alert = new Alert(Alert.AlertType.ERROR, rb.getString("TREE_ERR_RENAME_DUP"), new ButtonType[0]);
                    alert.showAndWait();
                }
            }
        });
        this.itemPaste = new MenuItem(rb.getString("TREE_MENU_PASTE"));
        this.itemPaste.setOnAction(t -> {
            TreeItem selectedTreeItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
            this.pasteNode(selectedTreeItem);
        });
        MenuItem itemCut = new MenuItem(rb.getString("TREE_MENU_CUT"));
        itemCut.setOnAction(t -> {
            this.cutTreeItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
            this.itemPaste.setVisible(true);
            this.pasteAsRoot.setVisible(true);
        });
        this.itemPaste.setVisible(false);
        MenuItem addRoot = new MenuItem(rb.getString("TREE_MENU_ADD_ROOT"));
        addRoot.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                TextInputDialog d = new TextInputDialog();
                d.setTitle(rb.getString("TREE_NEW_ROOT_NAME_TITLE"));
                d.setContentText(rb.getString("TREE_NEW_ROOT_NAME"));
                Optional result = d.showAndWait();
                if (result.isPresent() && !((String)result.get()).isEmpty()) {
                    String name = (String)result.get();
                    if (name == null || name.trim().isEmpty()) {
                        return;
                    }
                    Entity child = null;
                    try {
                        child = Tree.this.mgr.create((Entity)null, name);
                    }
                    catch (OperationException ex) {
                        Alert alert = new Alert(Alert.AlertType.ERROR, ex.toString(), new ButtonType[0]);
                        alert.setTitle(rb.getString("TREE_ERR_ADD_ROOT"));
                        alert.showAndWait();
                    }
                    if (child != null) {
                        TreeItem node = new TreeItem((Object)child);
                        Tree.this.rootNode.getChildren().add((Object)node);
                    }
                }
            }
        });
        this.pasteAsRoot = new MenuItem(rb.getString("TREE_MENU_PASTE_ROOT"));
        this.pasteAsRoot.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                Tree.this.pasteNode(Tree.this.rootNode);
            }
        });
        this.pasteAsRoot.setVisible(false);
        this.contextMenu.getItems().addAll((Object[])new MenuItem[]{itemAdd, itemRename, itemCut, this.itemPaste, this.itemDelete, addRoot, this.pasteAsRoot});
        this.contextMenu.setOnShowing(e -> {
            TreeItem selectedTreeItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
            if (selectedTreeItem == null) {
                this.itemDelete.setVisible(false);
            } else {
                this.itemDelete.setVisible(selectedTreeItem.isLeaf());
            }
        });
    }

    public T getSelectedItem() {
        TreeItem selectedItem = (TreeItem)this.treeView.getSelectionModel().getSelectedItem();
        if (selectedItem != null) {
            return (T)((Entity)selectedItem.getValue());
        }
        return null;
    }

    public void selectNode(String str) {
        TreeItem node = this.rootNode;
        boolean found = false;
        for (String nodeStr : str.split("/")) {
            found = false;
            for (TreeItem item : node.getChildren()) {
                if (!nodeStr.equals(((Entity)item.getValue()).toString())) continue;
                node = item;
                found = true;
                if (node.isExpanded()) break;
                node.setExpanded(true);
                break;
            }
            if (found) continue;
            return;
        }
        int id = this.treeView.getRow(node);
        this.treeView.scrollTo(id);
        this.treeView.getSelectionModel().clearAndSelect(id);
    }

    private void pasteNode(TreeItem<T> selectedTreeItem) {
        TreeItem origParentTreeItem = this.cutTreeItem.getParent();
        Entity newParent = (Entity)selectedTreeItem.getValue();
        if (origParentTreeItem == selectedTreeItem) {
            Alert alert = new Alert(Alert.AlertType.ERROR, rb.getString("TREE_ERR_PASTE_TO_SAME"), new ButtonType[0]);
            alert.showAndWait();
            return;
        }
        Entity item = (Entity)this.cutTreeItem.getValue();
        try {
            this.mgr.move(newParent, item);
            origParentTreeItem.getChildren().remove(this.cutTreeItem);
            selectedTreeItem.getChildren().add(this.cutTreeItem);
            this.callback.dispatch(new GUIEvent((Object)this, EVENT_ITEM_CHANGED, (Object)item));
        }
        catch (OperationException ex) {
            Alert alert = new Alert(Alert.AlertType.ERROR, ex.toString(), new ButtonType[0]);
            alert.setTitle(rb.getString("TREE_ERR_PASTE"));
            alert.showAndWait();
        }
        this.cutTreeItem = null;
        this.itemPaste.setVisible(false);
        this.pasteAsRoot.setVisible(false);
        this.itemPaste.setVisible(false);
    }

    private void traverse(TreeItem parent) {
        Entity tParent = (Entity)parent.getValue();
        for (Entity t : this.mgr.getChildren(tParent)) {
            TreeItem node = new TreeItem((Object)t);
            parent.getChildren().add((Object)node);
            this.traverse(node);
        }
    }

    private class TextFieldTreeCellImpl
    extends TreeCell<T> {
        private TextField textField;

        public void updateItem(T item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setText(null);
                this.setGraphic(null);
            } else if (this.isEditing()) {
                if (this.textField != null) {
                    this.textField.setText(this.getString());
                }
                this.setText(null);
                this.setGraphic((Node)this.textField);
            } else {
                this.setText(this.getString());
                this.setGraphic(this.getTreeItem().getGraphic());
                if (Tree.this.contextMenu != null) {
                    this.setContextMenu(Tree.this.contextMenu);
                }
            }
        }

        private String getString() {
            return this.getItem() == null ? "" : ((Entity)this.getItem()).toString();
        }
    }
}

