/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.common.gui.tree;

import java.util.List;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.tree.Tree;
import myencyclopedia.hibernate.common.ParentChildrenManager;
import myencyclopedia.model.Entity;

public class TreeMultiSelectionView<T extends Entity>
extends VBox
implements GUIListener {
    private Tree<T> tree;
    private ListView<T> listView;
    private ParentChildrenManager mgr;
    private Button btnAdd;
    private Button btnRemove;
    private ObservableList<T> observableList;

    public TreeMultiSelectionView(ParentChildrenManager<T> mgr) {
        this.tree = new Tree<T>(mgr, this);
        this.listView = new ListView();
        this.listView.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.listView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    Object obj = TreeMultiSelectionView.this.listView.getSelectionModel().getSelectedItem();
                    TreeMultiSelectionView.this.listView.getItems().remove(obj);
                }
            }
        });
        this.btnAdd = new Button("Add");
        this.btnAdd.setOnAction(e -> {
            T item = this.tree.getSelectedItem();
            if (item != null && !this.listView.getItems().contains(item)) {
                this.listView.getItems().add(item);
            }
        });
        this.btnRemove = new Button("Remove");
        this.btnRemove.setOnAction(e -> {
            Entity item = (Entity)this.listView.getSelectionModel().getSelectedItem();
            if (item != null) {
                this.listView.getItems().remove((Object)item);
            }
        });
        FlowPane addRemovePane = new FlowPane();
        addRemovePane.getChildren().add((Object)this.btnAdd);
        addRemovePane.getChildren().add((Object)this.btnRemove);
        this.getChildren().addAll((Object[])new Node[]{this.tree, addRemovePane, this.listView});
    }

    public void setItems(List<T> items) {
        this.observableList = FXCollections.observableArrayList();
        this.listView.setItems(this.observableList);
        if (items != null) {
            this.observableList.addAll(items);
        }
    }

    public void setItems(T[] items) {
        this.observableList = FXCollections.observableArrayList();
        this.listView.setItems(this.observableList);
        if (items != null) {
            this.observableList.addAll((Object[])items);
        }
    }

    public void syncTreeView() {
        this.tree.sync();
    }

    public List<T> getItems() {
        return this.observableList;
    }

    public Object dispatch(GUIEvent e) {
        return null;
    }
}

