/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.fieldcache.impl;

import java.io.IOException;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldCache;
import org.hibernate.search.query.fieldcache.impl.FieldLoadingStrategy;

public final class FloatFieldLoadingStrategy
implements FieldLoadingStrategy {
    private final String fieldName;
    private FieldCache.Floats currentCache;

    public FloatFieldLoadingStrategy(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void loadNewCacheValues(AtomicReaderContext context) throws IOException {
        AtomicReader reader = context.reader();
        this.currentCache = FieldCache.DEFAULT.getFloats(reader, this.fieldName, false);
    }

    @Override
    public Float collect(int relativeDocId) {
        return Float.valueOf(this.currentCache.get(relativeDocId));
    }
}

