/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import myencyclopedia.common.utils.FileNameUtils;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.model.Entity;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.mydoc.Code;
import myencyclopedia.model.mydoc.Doc;
import myencyclopedia.model.mydoc.Note;

public class EntityListCell
extends ListCell<Entity> {
    public static final String BG_COLOR_CODE = "F5A9BC";
    public static final String BG_COLOR_NOTE = "d6ddea";
    public static final String BG_COLOR_DOC = "b1f0a5";
    public static final String BG_COLOR_BOOK = "fff7dd";
    Label lbl = new Label();
    ImageView imgView = new ImageView();

    public EntityListCell() {
        this.lbl.setAlignment(Pos.BASELINE_LEFT);
    }

    public void updateItem(Entity item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty || item == null) {
            this.setText(null);
            this.setGraphic(null);
            this.setStyle("-fx-control-inner-background: white");
        } else if (item instanceof Entity) {
            if (item instanceof Note) {
                this.imgView.setImage(ImageFactory.IMG_Note);
                this.setStyle("-fx-control-inner-background: #d6ddea");
            } else if (item instanceof Doc) {
                String ext;
                Doc doc = (Doc)item;
                switch (ext = FileNameUtils.getSuffixPart((String)((String)doc.getFileList().get(0)))) {
                    case "pdf": {
                        this.imgView.setImage(ImageFactory.IMG_DOC_PDF);
                        break;
                    }
                    case "doc": {
                        this.imgView.setImage(ImageFactory.IMG_DOC_WORD);
                        break;
                    }
                    case "txt": {
                        this.imgView.setImage(ImageFactory.IMG_DOC_TXT);
                        break;
                    }
                    case "html": {
                        this.imgView.setImage(ImageFactory.IMG_DOC_HTML);
                        break;
                    }
                    default: {
                        this.imgView.setImage(ImageFactory.IMG_DOC_UNKNOWN);
                    }
                }
                this.setStyle("-fx-control-inner-background: #b1f0a5");
            } else if (item instanceof Ebook) {
                Ebook book = (Ebook)item;
                String[] exts = book.getFileExtInfo().split(",");
                if (exts.length != 0) {
                    if (exts.length == 1) {
                        String ext;
                        switch (ext = exts[0]) {
                            case "pdf": {
                                this.imgView.setImage(ImageFactory.IMG_BOOK_PDF);
                                break;
                            }
                            case "doc": {
                                this.imgView.setImage(ImageFactory.IMG_DOC_WORD);
                                break;
                            }
                            case "txt": {
                                this.imgView.setImage(ImageFactory.IMG_DOC_TXT);
                                break;
                            }
                            case "html": {
                                this.imgView.setImage(ImageFactory.IMG_DOC_HTML);
                                break;
                            }
                            case "epub": {
                                this.imgView.setImage(ImageFactory.IMG_BOOK_EPUB);
                                break;
                            }
                            default: {
                                this.imgView.setImage(ImageFactory.IMG_BOOK_UNKNOWN);
                                break;
                            }
                        }
                    } else {
                        this.imgView.setImage(ImageFactory.IMG_BOOKS);
                    }
                }
                this.setStyle("-fx-control-inner-background: #fff7dd");
            } else if (item instanceof Code) {
                this.setStyle("-fx-control-inner-background: #F5A9BC");
                String lang = ((Code)item).getLang();
                if (lang == null) {
                    lang = "";
                }
                switch (lang) {
                    case "java": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_JAVA);
                        break;
                    }
                    case "html": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_HTML);
                        break;
                    }
                    case "c": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_C);
                        break;
                    }
                    case "csharp": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_CSHARP);
                        break;
                    }
                    case "cpp": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_CPP);
                        break;
                    }
                    case "bash": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_BASH);
                        break;
                    }
                    case "css": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_CSS);
                        break;
                    }
                    case "groovy": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_GROOVY);
                        break;
                    }
                    case "js": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_JS);
                        break;
                    }
                    case "lisp": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_LISP);
                        break;
                    }
                    case "perl": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_PERL);
                        break;
                    }
                    case "python": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_PYTHON);
                        break;
                    }
                    case "ruby": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_RUBY);
                        break;
                    }
                    case "sql": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_SQL);
                        break;
                    }
                    case "xml": {
                        this.imgView.setImage(ImageFactory.IMG_CODE_XML);
                        break;
                    }
                    default: {
                        this.imgView.setImage(ImageFactory.IMG_Code);
                    }
                }
            }
            this.lbl.setText(item.toString());
            this.lbl.setGraphic((Node)this.imgView);
            if (item instanceof Ebook) {
                this.lbl.setTooltip(new Tooltip(((Ebook)item).toFullInfo()));
            } else {
                this.lbl.setTooltip(new Tooltip(item.toString()));
            }
            this.setGraphic((Node)this.lbl);
        }
    }
}

