/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import myencyclopedia.logic.mydoc.ConfigMydoc;

public class ModeConfigStage
extends Stage {
    private Button btnOK;
    private Button btnCancel;
    private RadioButton radioDefault;
    private RadioButton radioServer;
    private RadioButton radioClient;
    private String mode;
    private ConfigMydoc config;
    private TextField clientConf;
    private boolean isModified;

    public ModeConfigStage() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.config = ConfigMydoc.getInstance();
        this.btnOK = new Button("OK");
        this.btnOK.setDefaultButton(true);
        this.btnOK.setOnAction(e -> this.saveAndClose());
        this.btnCancel = new Button("Cancel");
        this.btnCancel.setOnAction(e -> this.hide());
        this.btnCancel.setCancelButton(true);
        this.radioDefault = new RadioButton("Default");
        this.radioServer = new RadioButton("Server");
        this.radioClient = new RadioButton("Client");
        ToggleGroup groupInputType = new ToggleGroup();
        this.radioDefault.setToggleGroup(groupInputType);
        this.radioClient.setToggleGroup(groupInputType);
        this.radioServer.setToggleGroup(groupInputType);
        this.clientConf = new TextField();
        HBox buttonPane = new HBox();
        buttonPane.getChildren().addAll((Object[])new Node[]{this.btnOK, this.btnCancel});
        VBox vbox = new VBox();
        vbox.setPadding(new Insets(10.0, 5.0, 10.0, 5.0));
        vbox.setSpacing(10.0);
        vbox.getChildren().addAll((Object[])new Node[]{this.radioDefault, new Separator(), this.radioServer, new Separator(), this.radioClient, this.clientConf, new Separator(), buttonPane});
        Scene scene = new Scene((Parent)vbox);
        this.setScene(scene);
        this.setWidth(500.0);
        this.setTitle("Mode");
    }

    public void display() {
        switch (this.config.getMode()) {
            case "default": {
                this.mode = "default";
                this.radioDefault.setSelected(true);
                break;
            }
            case "server": {
                this.mode = "server";
                this.radioServer.setSelected(true);
                break;
            }
            case "client": {
                this.mode = "client";
                this.radioClient.setSelected(true);
            }
        }
        this.clientConf.setText(this.config.getClientConfig());
        this.showAndWait();
    }

    private void saveAndClose() {
        String newMode = "";
        if (this.radioDefault.isSelected()) {
            newMode = "default";
        } else if (this.radioServer.isSelected()) {
            newMode = "server";
        } else if (this.radioClient.isSelected()) {
            newMode = "client";
        }
        if (!newMode.equals(this.mode)) {
            this.config.setNodeValue("/myencyclopedia/mydoc/option/mode", newMode);
            this.config.setNodeValue("/myencyclopedia/mydoc/option/client", this.clientConf.getText());
            this.config.writeToFile();
            this.isModified = true;
        }
        this.hide();
    }

    public boolean getIsModified() {
        return this.isModified;
    }
}

