/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.logic.mydoc.ConfigMydoc;

public class MydocConfigStage
extends Stage {
    private Button okBtn;
    private boolean optionCopyDoc;
    private boolean optionShowHidden;
    private boolean optionMoveToTrash;
    private boolean optionIndex;
    private String optionLang;
    private CheckBox chkFullTextSearch;
    private CheckBox chkCopyDoc;
    private CheckBox chkShowHidden;
    private CheckBox chkMoveToTrash;
    private ComboBox comboLang;
    private ConfigMydoc config;
    private boolean isFullTextSearchEnabled;
    private boolean isLangChanged;
    private boolean isShowHiddenChanged;

    public MydocConfigStage() {
        this.initModality(Modality.APPLICATION_MODAL);
        this.config = ConfigMydoc.getInstance();
        this.okBtn = new Button(MydocMain.rb.getString("SAVE"));
        this.okBtn.setDefaultButton(true);
        this.okBtn.setOnAction(e -> this.saveAndClose());
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
            }
        });
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        gridPane.setPadding(new Insets(10.0, 10.0, 0.0, 10.0));
        this.chkFullTextSearch = new CheckBox(MydocMain.rb.getString("OPTION_FULL_TEXT_SEARCH"));
        this.chkCopyDoc = new CheckBox(MydocMain.rb.getString("OPTION_COPY_BEFORE_OPEN"));
        this.chkShowHidden = new CheckBox(MydocMain.rb.getString("OPTION_SHOW_HIDDEN"));
        this.chkMoveToTrash = new CheckBox(MydocMain.rb.getString("OPTION_MOVE_TO_TRASH"));
        this.comboLang = new ComboBox();
        this.comboLang.getItems().addAll(new Object[]{"English", "\u4e2d\u6587"});
        Label lblLang = new Label(MydocMain.rb.getString("OPTION_LABLE_LANG"));
        HBox lang = new HBox(new Node[]{lblLang, this.comboLang});
        gridPane.add((Node)this.chkFullTextSearch, 0, 0);
        gridPane.add((Node)this.chkCopyDoc, 0, 1);
        gridPane.add((Node)this.chkShowHidden, 0, 2);
        gridPane.add((Node)this.chkMoveToTrash, 0, 3);
        gridPane.add((Node)lang, 0, 4);
        gridPane.add((Node)this.okBtn, 0, 5);
        Scene scene = new Scene((Parent)gridPane);
        this.setScene(scene);
        this.setTitle(MydocMain.rb.getString("OPTION"));
    }

    public void display() {
        this.optionCopyDoc = this.config.getCopyDocPathEnabled();
        this.optionShowHidden = this.config.getShowHiddenEnabled();
        this.optionMoveToTrash = this.config.getMoveToTrash();
        this.optionIndex = this.config.getIndexEnabled();
        this.chkCopyDoc.setSelected(this.optionCopyDoc);
        this.chkShowHidden.setSelected(this.optionShowHidden);
        this.chkMoveToTrash.setSelected(this.optionMoveToTrash);
        this.chkFullTextSearch.setSelected(this.optionIndex);
        this.isFullTextSearchEnabled = false;
        this.isLangChanged = false;
        this.isShowHiddenChanged = false;
        this.optionLang = this.config.getLanguage();
        if ("zh_CN".equals(this.optionLang)) {
            this.comboLang.setValue((Object)"\u4e2d\u6587");
        } else {
            this.comboLang.setValue((Object)"English");
        }
        this.showAndWait();
    }

    private void saveAndClose() {
        if (this.chkFullTextSearch.isSelected() && !this.optionIndex) {
            this.isFullTextSearchEnabled = true;
        }
        boolean bl = this.isShowHiddenChanged = this.chkShowHidden.isSelected() != this.optionShowHidden;
        if (this.chkCopyDoc.isSelected() != this.optionCopyDoc || this.chkShowHidden.isSelected() != this.optionShowHidden || this.chkMoveToTrash.isSelected() != this.optionMoveToTrash || this.chkFullTextSearch.isSelected() != this.optionIndex) {
            this.optionShowHidden = this.chkShowHidden.isSelected();
            this.optionCopyDoc = this.chkCopyDoc.isSelected();
            this.optionMoveToTrash = this.chkMoveToTrash.isSelected();
            this.optionIndex = this.chkFullTextSearch.isSelected();
            this.config.setNodeValue("/myencyclopedia/mydoc/option/copydoc", Boolean.toString(this.optionCopyDoc));
            this.config.setNodeValue("/myencyclopedia/mydoc/option/showhidden", Boolean.toString(this.optionShowHidden));
            this.config.setNodeValue("/myencyclopedia/mydoc/option/move_to_trash", Boolean.toString(this.optionMoveToTrash));
            this.config.setNodeValue("/myencyclopedia/mydoc/option/index", Boolean.toString(this.optionIndex));
            this.config.writeToFile();
        }
        String langValue = (String)this.comboLang.getValue();
        this.isLangChanged = false;
        switch (langValue) {
            case "\u4e2d\u6587": {
                if (!"en_US".equals(this.optionLang)) break;
                this.isLangChanged = true;
                this.optionLang = "zh_CN";
                break;
            }
            case "English": {
                if (!"zh_CN".equals(this.optionLang)) break;
                this.isLangChanged = true;
                this.optionLang = "en_US";
            }
        }
        if (this.isLangChanged) {
            this.config.setNodeValue("/myencyclopedia/mydoc/option/language", this.optionLang);
            this.config.writeToFile();
        }
        this.hide();
    }

    public boolean getIndexingEnabled() {
        return this.isFullTextSearchEnabled;
    }

    public boolean getLanguageChanged() {
        return this.isLangChanged;
    }

    public boolean getShowHiddenChanged() {
        return this.isShowHiddenChanged;
    }
}

