/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import com.tulskiy.keymaster.common.HotKey;
import com.tulskiy.keymaster.common.HotKeyListener;
import com.tulskiy.keymaster.common.Provider;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Predicate;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javax.swing.KeyStroke;
import myencyclopedia.common.config.XMLConfigFile;
import myencyclopedia.common.gui.ConfigStage;
import myencyclopedia.common.gui.FloatingListStage;
import myencyclopedia.common.gui.FxOptionPane;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.LaunchUtils;
import myencyclopedia.common.gui.Splash;
import myencyclopedia.common.gui.entity.EntityList;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.common.gui.tree.Tree;
import myencyclopedia.common.utils.CancelFlagHolder;
import myencyclopedia.common.utils.FileCopyUtil;
import myencyclopedia.common.utils.HashUtil;
import myencyclopedia.common.utils.JDKVersionUtil;
import myencyclopedia.common.utils.LocaleUtil;
import myencyclopedia.common.utils.SingleProcessUtil;
import myencyclopedia.gui.help.LicenseManager;
import myencyclopedia.gui.help.MenuItemFactory;
import myencyclopedia.gui.help.ProductInfo;
import myencyclopedia.gui.mydoc.ClientLoadingNoteRunnable;
import myencyclopedia.gui.mydoc.ClientThread;
import myencyclopedia.gui.mydoc.EntityListCell;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.IndexingProgressStage;
import myencyclopedia.gui.mydoc.ModeConfigStage;
import myencyclopedia.gui.mydoc.MydocConfigStage;
import myencyclopedia.gui.mydoc.PublisherStage;
import myencyclopedia.gui.mydoc.QueryInput;
import myencyclopedia.gui.mydoc.SameMD5EntityDialog;
import myencyclopedia.gui.mydoc.ServerThread;
import myencyclopedia.gui.mydoc.StatusBarInfo;
import myencyclopedia.gui.mydoc.TagGUIController;
import myencyclopedia.gui.mydoc.code.CodeSpecBuilder;
import myencyclopedia.gui.mydoc.code.CodeStage;
import myencyclopedia.gui.mydoc.doc.DocNewStage;
import myencyclopedia.gui.mydoc.doc.DocPropertyEditingStage;
import myencyclopedia.gui.mydoc.doc.DocSpecBuilder;
import myencyclopedia.gui.mydoc.ebook.AuthorSelectionStage;
import myencyclopedia.gui.mydoc.ebook.EbookEditingStage;
import myencyclopedia.gui.mydoc.ebook.EbookNewStage;
import myencyclopedia.gui.mydoc.ebook.EbookSpecBuilder;
import myencyclopedia.gui.mydoc.note.NoteHtmlEditorStage;
import myencyclopedia.gui.mydoc.note.NotePropertyEditingStage;
import myencyclopedia.gui.mydoc.note.NoteSpecBuilder;
import myencyclopedia.hibernate.AsyncListReceiver;
import myencyclopedia.hibernate.HibernateUtil;
import myencyclopedia.hibernate.common.ParentChildrenManager;
import myencyclopedia.logic.ebook.EbookDAO;
import myencyclopedia.logic.mydoc.CodeDAO;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.logic.mydoc.DBInit;
import myencyclopedia.logic.mydoc.DayContentChangedEvent;
import myencyclopedia.logic.mydoc.DayContentChangedListener;
import myencyclopedia.logic.mydoc.DocManager;
import myencyclopedia.logic.mydoc.NoteManager;
import myencyclopedia.logic.mydoc.tag.TagManager;
import myencyclopedia.logic.query.MECriteria;
import myencyclopedia.logic.query.SearchWorkerThread;
import myencyclopedia.model.Entity;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.common.entity.FileObject;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.ebook.Author;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.ebook.EbookAuthor;
import myencyclopedia.model.ebook.EbookFileInfo;
import myencyclopedia.model.ebook.MyComment;
import myencyclopedia.model.ebook.Producer;
import myencyclopedia.model.ebook.Publisher;
import myencyclopedia.model.ebook.Series;
import myencyclopedia.model.hbn.HBAbstractEntity;
import myencyclopedia.model.hbn.SchemaUtil;
import myencyclopedia.model.mydoc.Code;
import myencyclopedia.model.mydoc.Doc;
import myencyclopedia.model.mydoc.Note;
import myencyclopedia.model.mydoc.Snippet;
import myencyclopedia.search.mydoc.DocInterceptor;
import myencyclopedia.search.mydoc.EbookInterceptor;
import myencyclopedia.search.mydoc.FullTextClassBridge;
import myencyclopedia.search.mydoc.NoteInterceptor;
import myencyclopedia.search.mydoc.highlighter.EntityWithExcerpts;
import myencyclopedia.search.mydoc.highlighter.HighlighterStage;
import myencyclopedia.search.mydoc.parser.IndexingReporter;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.h2.tools.Server;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.cfg.SearchMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MydocMain
extends Application
implements GUIListener,
DayContentChangedListener {
    static SessionFactory sf;
    static DocManager docMgr;
    static NoteManager noteMgr;
    static TagManager tagMgr;
    private static Path pathDoc;
    private static Path pathNote;
    private static Path pathCode;
    private static Path pathTemp;
    private static Path pathTrash;
    private static String dburl;
    private MydocConfigStage configStage;
    private static Tree<Tag> tagTree;
    private EntityList entityList;
    private EntityView propList;
    private BorderPane border;
    private BorderPane treeBP;
    private MenuBar menuBar;
    private Label lblStatus;
    private Menu menuView;
    private RadioMenuItem radioShowThis;
    private RadioMenuItem radioShowSub;
    private RadioMenuItem radioShowFav;
    private RadioMenuItem radioShowNoTag;
    private RadioMenuItem radioShowAll;
    private CheckMenuItem cmiShowProp;
    private CheckMenuItem cmiDoc;
    private CheckMenuItem cmiShowFloatingStage;
    private CheckMenuItem cmiNote;
    private CheckMenuItem cmiCode;
    private CheckMenuItem cmiBook;
    private SplitPane splitPaneTreeWithItems;
    private MenuItem addNote;
    private MenuItem addDoc;
    private MenuItem addCode;
    private MenuItem addBook;
    public static Stage primaryStage;
    private SplitPane splitPaneListAndProp;
    private ScrollPane propListScrollPane;
    private static HashMap<Long, Stage> entityIdToStage;
    private static Set<TagGUIController> tagGUISet;
    private SameMD5EntityDialog sameFileDialog;
    private static SearchWorkerThread searchThread;
    private static FloatingListStage floatingSearchStage;
    private MenuItem mOpen;
    private MenuItem mShowProperty;
    private MenuItem mNoteCopyContent;
    private CheckMenuItem mFavourite;
    private MenuItem mDelete;
    private ProductInfo productInfo;
    private Provider provider;
    private static final Logger logger;
    private static Server serverDB;
    private static ServerSocket socketServer;
    private static Socket socketClient;
    private static ClientThread clientThread;
    private static ServerThread serverThread;
    private List<Ebook> existingEbooks;
    private Tag[] cachedTags;
    private StatusBarInfo statusBarInfo;
    public static ResourceBundle rb;
    public static boolean isIndexEnabled;
    static TagMode tagMode;
    static volatile boolean listDoc;
    static volatile boolean listNote;
    static volatile boolean listCode;
    static volatile boolean listBook;
    private Tag currTag;
    public static ConfigMydoc conf;
    public static final String MODE_DEFAULT = "default";
    public static final String MODE_SERVER = "server";
    public static final String MODE_CLIENT = "client";
    private static boolean firstRun;
    private static MydocMain mydocMain;
    private Splash splash;
    private Predicate<? super Entity> predicateFilterHidden = en -> Boolean.TRUE.equals(en.getPropertyValue("is_hidden"));
    private AsyncListReceiver receiver = new AsyncListReceiver(){

        public void beginLoading() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    MydocMain.this.entityList.itemsReset();
                    MydocMain.this.statusBarInfo.reset();
                }
            });
        }

        public void endLoading() {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    switch (tagMode) {
                        case Exact: {
                            MydocMain.this.lblStatus.setText(String.format(rb.getString("LOADED_TAG"), MydocMain.this.currTag, MydocMain.this.statusBarInfo.toString()));
                            break;
                        }
                        case Sub: {
                            MydocMain.this.lblStatus.setText(String.format(rb.getString("LOADED_SUB_TAGS"), MydocMain.this.currTag, MydocMain.this.statusBarInfo.getTagCount(), MydocMain.this.statusBarInfo.toString()));
                            break;
                        }
                        case None: {
                            MydocMain.this.lblStatus.setText(String.format(rb.getString("LOADED_NO_TAG"), MydocMain.this.statusBarInfo.toString()));
                            break;
                        }
                        case FAVOURITE: {
                            MydocMain.this.lblStatus.setText(String.format(rb.getString("LOADED_FAVOURITE"), MydocMain.this.statusBarInfo.toString()));
                            break;
                        }
                        case ALL: {
                            MydocMain.this.lblStatus.setText(String.format(rb.getString("LOADED_ALL"), MydocMain.this.statusBarInfo.toString()));
                        }
                    }
                }
            });
        }

        public void appendList(final List<Entity> lst) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (!ConfigMydoc.getInstance().getShowHiddenEnabled()) {
                        lst.removeIf(MydocMain.this.predicateFilterHidden);
                    }
                    MydocMain.this.entityList.itemsAdd(lst);
                    MydocMain.this.statusBarInfo.count(lst);
                }
            });
        }
    };

    public static MydocMain getInstance() {
        return mydocMain;
    }

    public static void initConfig() {
        Path[] paths;
        conf = ConfigMydoc.initInstance();
        if (!conf.exists()) {
            firstRun = true;
            rb = ResourceBundle.getBundle("properties.gui-mydoc");
            ConfigStage cs = new ConfigStage((XMLConfigFile)conf, rb.getString("CONFIG_MYDOC"), ResourceBundle.getBundle("properties.config-mydoc"));
            cs.showAndWait();
            if (cs.getErrorMessage() != null) {
                Alert alert = new Alert(Alert.AlertType.ERROR, cs.getErrorMessage(), new ButtonType[0]);
                alert.showAndWait();
                System.exit(0);
            }
            conf.writeToFile();
            ConfigStage.copyHelp((String)"mydoc");
        } else {
            LocaleUtil.configLocale((String)conf.getLanguage());
            rb = ResourceBundle.getBundle("properties.gui-mydoc");
        }
        pathDoc = conf.getAsPath("/myencyclopedia/mydoc/doc/path");
        pathTrash = conf.getAsPath("/myencyclopedia/mydoc/trash/path");
        pathNote = conf.getAsPath("/myencyclopedia/mydoc/note/path");
        pathTemp = conf.getAsPath("/myencyclopedia/mydoc/temp/path");
        pathCode = conf.getAsPath("/myencyclopedia/mydoc/code/path");
        Path pathBook = conf.getAsPath("/myencyclopedia/mydoc/bookshelf/path");
        Path pathLuceneCache = conf.getAsPath("/myencyclopedia/mydoc/lucene/path");
        dburl = conf.getDBURL();
        logger.warn("DB url:" + dburl);
        logger.warn("Doc path: " + pathDoc);
        logger.warn("Note path: " + pathNote);
        logger.warn("Bookshelf path: " + pathBook);
        logger.warn("Code path: " + pathCode);
        logger.warn("Lucene cache path: " + pathLuceneCache);
        logger.warn("Trash path: " + pathTrash);
        logger.warn("Temp path: " + pathTemp);
        for (Path p : paths = new Path[]{pathDoc, pathNote, pathBook, pathCode, pathLuceneCache, pathTrash, pathTemp}) {
            if (Files.exists(p, new LinkOption[0]) && Files.isDirectory(p, new LinkOption[0])) continue;
            logger.error("Path " + p + " invalid.");
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        JDKVersionUtil.versionCheckOrExit((int)8, (int)45);
        SingleProcessUtil.acquireOrExit((String)"mydoc");
        Application.launch((String[])args);
    }

    public void changed(DayContentChangedEvent event) {
        Object src = event.getSource();
        Tag[] tags = null;
        if (src instanceof Doc) {
            tags = ((Doc)src).getTags();
        } else if (src instanceof Note) {
            if (!listNote) {
                return;
            }
            tags = ((Note)src).getTags();
        } else if (src instanceof Tag) {
            return;
        }
        boolean toBeAdded = false;
        if (tags == null) {
            toBeAdded = this.addWhenTagged(null);
        } else {
            for (Tag tag : tags) {
                if (!this.addWhenTagged(tag)) continue;
                toBeAdded = true;
                break;
            }
        }
        if (toBeAdded) {
            this.entityList.itemAdd((Entity)src);
        }
    }

    private void exit() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, rb.getString("CONFIRM_QUIT"), new ButtonType[0]);
        alert.showAndWait();
        if (alert.getResult() != ButtonType.OK) {
            return;
        }
        sf.close();
        this.provider.reset();
        this.provider.stop();
        if (serverDB != null) {
            serverDB.stop();
        }
        if (socketClient != null && !socketClient.isClosed()) {
            try {
                socketClient.close();
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
            }
        }
        if (socketServer != null && !socketServer.isClosed()) {
            try {
                socketServer.close();
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
            }
        }
        System.exit(0);
    }

    public void start(Stage stage) {
        mydocMain = this;
        primaryStage = stage;
        this.productInfo = new ProductInfo("mydoc");
        MydocMain.initConfig();
        LicenseManager.initLicenseManager((ProductInfo)this.productInfo);
        this.splash = new Splash(new Image(MydocMain.class.getResourceAsStream("/splash.png")));
        this.splash.updateProgress(rb.getString("SPLASH_OPEN_DB"), 0.1);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MydocMain.this.startApp();
            }
        });
    }

    private void startApp() {
        Class[] CLASS_ARRAY = new Class[]{Tag.class, Note.class, Doc.class, Code.class, Snippet.class, Author.class, Ebook.class, EbookAuthor.class, EbookFileInfo.class, FileObject.class, MyComment.class, Producer.class, Publisher.class, Series.class};
        switch (conf.getMode()) {
            case "default": {
                logger.debug("Starting in default mode");
                try {
                    HashMap<String, Object> propertyMap = new HashMap<String, Object>();
                    propertyMap.put("hibernate.search.model_mapping", this.configSearchMapping());
                    propertyMap.put("hibernate.search.default.indexBase", conf.getAsPath("/myencyclopedia/mydoc/lucene/path").toAbsolutePath().toString());
                    sf = HibernateUtil.getExistingOrCreateDBSessionFactory((String)"hbn.mydoc.xml", (String)dburl, (Class[])CLASS_ARRAY, propertyMap);
                }
                catch (HibernateException ex) {
                    logger.error("default mode HibnerateException", (Throwable)ex);
                    System.exit(-1);
                }
                catch (SchemaUtil.SchemaUnmatchedException ex) {
                    logger.error("default mode schema verfication error", (Throwable)ex);
                    System.exit(-1);
                }
                logger.warn("Started in default mode");
                break;
            }
            case "server": {
                logger.debug("Starting in server mode");
                try {
                    serverDB = Server.createTcpServer((String[])new String[]{"-tcp", "-tcpAllowOthers"}).start();
                }
                catch (SQLException ex) {
                    logger.error("", (Throwable)ex);
                    System.exit(-1);
                }
                String jdbc = "jdbc:h2:tcp://localhost:9092/" + conf.getDBURL();
                try {
                    sf = HibernateUtil.connectSessionFactory((String)"hbn.mydoc.xml", (String)jdbc, (Class[])CLASS_ARRAY);
                }
                catch (HibernateException ex) {
                    logger.error("server mode HibnerateException", (Throwable)ex);
                    System.exit(-1);
                }
                catch (SchemaUtil.SchemaUnmatchedException ex) {
                    logger.error("server mode schema verfication error", (Throwable)ex);
                    System.exit(-1);
                }
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        MydocMain.startServer();
                    }
                }).start();
                logger.warn("Started in server mode");
                break;
            }
            case "client": {
                MydocMain.startClient(CLASS_ARRAY);
            }
        }
        this.splash.updateProgress(rb.getString("SPLASH_LOADING_DATA"), 0.5);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MydocMain.this.loadData();
            }
        });
    }

    private void loadData() {
        if (firstRun) {
            DBInit.init((SessionFactory)sf);
        } else {
            TagManager.init((SessionFactory)sf);
        }
        tagMgr = TagManager.getInstance();
        tagMgr.reload();
        docMgr = DocManager.getInstance((SessionFactory)sf);
        noteMgr = NoteManager.getInstance((SessionFactory)sf);
        this.configStage = new MydocConfigStage();
        this.sameFileDialog = SameMD5EntityDialog.getInstance();
        if (System.getProperty("fakeversion") != null) {
            primaryStage.setTitle("ME-Mydoc " + System.getProperty("fakeversion"));
        } else {
            primaryStage.setTitle(this.productInfo.getTitle());
        }
        this.initMenu();
        this.statusBarInfo = StatusBarInfo.getInstance();
        tagTree = new Tree((ParentChildrenManager)tagMgr, (GUIListener)this);
        tagTree.enableContextMenu();
        this.entityList = new EntityList((GUIListener)this, EntityListCell.class);
        this.splash.updateProgress(rb.getString("SPLASH_INIT_UI"), 0.8);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MydocMain.this.initGUI();
            }
        });
    }

    private void initGUI() {
        this.initLayout();
        Scene scene = new Scene((Parent)this.border, 650.0, 500.0);
        scene.setFill((Paint)Color.LIGHTGRAY);
        primaryStage.setScene(scene);
        primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                MydocMain.this.exit();
                we.consume();
            }
        });
        primaryStage.getIcons().add((Object)ImageFactory.IMG_STAGE_MAIN);
        QueryInput queryInput = new QueryInput(new GUIListener(){

            public Object dispatch(GUIEvent e) {
                switch (e.getEventName()) {
                    case "QueryInput_hide": {
                        MydocMain.this.hideFloatingSearchStage();
                        break;
                    }
                    case "QueryInput_double": {
                        Entity entity = (Entity)e.getValue();
                        MydocMain.actionOpen(entity);
                        break;
                    }
                    case "QueryInput_default_control": {
                        Entity entity = (Entity)e.getValue();
                        MydocMain.this.launchPropertyStage(entity);
                    }
                }
                return null;
            }
        });
        floatingSearchStage = new FloatingListStage((GUIListener)this, (Pane)queryInput.getInputPane());
        queryInput.setOwnerStage((Stage)floatingSearchStage);
        floatingSearchStage.getIcons().add((Object)ImageFactory.IMG_STAGE_SEARCH);
        searchThread = new SearchWorkerThread(sf);
        this.refreshList();
        this.initGlobalHotKeys();
        if (isIndexEnabled) {
            HighlighterStage.init((SessionFactory)sf, (SearchWorkerThread)searchThread, (GUIListener)this);
            HighlighterStage.getInstance();
        }
        this.splash.hide();
        this.splash = null;
        primaryStage.show();
        floatingSearchStage.show();
        LicenseManager.confirmExpiredDialogNoLimited();
    }

    private void hideFloatingSearchStage() {
        floatingSearchStage.hide();
    }

    private SearchMapping configSearchMapping() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Note.class).classBridge(FullTextClassBridge.class).name("_note").indexed().interceptor(NoteInterceptor.class).property("getId", ElementType.METHOD).documentId().name("id");
        mapping.entity(Ebook.class).classBridge(FullTextClassBridge.class).name("_ebook").indexed().interceptor(EbookInterceptor.class).property("getId", ElementType.METHOD).documentId().name("id");
        mapping.entity(Doc.class).classBridge(FullTextClassBridge.class).name("_doc").indexed().interceptor(DocInterceptor.class).property("getId", ElementType.METHOD).documentId().name("id");
        return mapping;
    }

    private void initGlobalHotKeys() {
        this.provider = Provider.getCurrentProvider((boolean)false);
        HotKeyListener listenerFloatingWin = new HotKeyListener(){

            public void onHotKey(HotKey hotKey) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (floatingSearchStage.isShowing()) {
                            if (floatingSearchStage.isFocused()) {
                                floatingSearchStage.hide();
                            } else {
                                floatingSearchStage.toFront();
                            }
                        } else {
                            floatingSearchStage.show();
                        }
                    }
                });
            }
        };
        HotKeyListener listenerNewNote = new HotKeyListener(){

            public void onHotKey(HotKey hotKey) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MydocMain.this.addNote();
                    }
                });
            }
        };
        this.provider.reset();
        this.provider.register(KeyStroke.getKeyStroke("ctrl alt O"), listenerFloatingWin);
        this.provider.register(KeyStroke.getKeyStroke("ctrl alt N"), listenerNewNote);
    }

    private void buildIndex(final boolean indexMissing) {
        final CancelFlagHolder cancelFlag = new CancelFlagHolder();
        final IndexingProgressStage progressStage = new IndexingProgressStage(primaryStage);
        progressStage.setCancelFlagHolder(cancelFlag);
        final IndexingReporter reporter = new IndexingReporter(){

            public void progress(final int current, final int total) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        progressStage.updateProgress(String.format(rb.getString("PROGRESS_PAGE"), current, total), (double)current / (double)total);
                    }
                });
            }
        };
        Task task = new Task(){

            protected Boolean call() throws Exception {
                FullTextClassBridge.reporter = reporter;
                MydocMain.this.workerBuildIndex(indexMissing, progressStage, cancelFlag);
                return true;
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                progressStage.hide();
            }
        });
        new Thread((Runnable)task).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workerBuildIndex(boolean indexMissing, final IndexingProgressStage progressStage, CancelFlagHolder cancelFlag) {
        Session s = sf.openSession();
        int total = 0;
        String queryStr = "select count(entity) from Ebook entity";
        org.hibernate.Query query = s.createQuery(queryStr);
        total += Integer.parseInt(query.list().get(0).toString());
        queryStr = "select count(entity) from Note entity";
        query = s.createQuery(queryStr);
        total += Integer.parseInt(query.list().get(0).toString());
        queryStr = "select count(entity) from Doc entity";
        query = s.createQuery(queryStr);
        final int finalTotal = total += Integer.parseInt(query.list().get(0).toString());
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                progressStage.setTotalEntities(finalTotal);
            }
        });
        try (FullTextSession fullTextSession = Search.getFullTextSession((Session)s);){
            Class[] classes;
            for (Class cls : classes = new Class[]{Note.class, Doc.class, Ebook.class}) {
                List resultList = fullTextSession.createCriteria(cls).list();
                for (final Entity entity : resultList) {
                    if (cancelFlag.get()) {
                        return;
                    }
                    if (!cls.equals(Note.class) && indexMissing) {
                        QueryParser parser = new QueryParser("classtype", fullTextSession.getSearchFactory().getAnalyzer(cls));
                        Query luceneQuery = null;
                        try {
                            luceneQuery = parser.parse(String.format("%s AND %s:%s", cls.getSimpleName(), "id", entity.getId().toString()));
                            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[0]);
                            if (!fullTextQuery.list().isEmpty()) {
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        progressStage.updateTotalProgress(entity.toString());
                                    }
                                });
                                continue;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Transaction tx = fullTextSession.beginTransaction();
                    try {
                        fullTextSession.index((Object)entity);
                        tx.commit();
                    }
                    catch (Exception ex) {
                        logger.error("", (Throwable)ex);
                        tx.rollback();
                    }
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            progressStage.updateTotalProgress(entity.toString());
                        }
                    });
                }
            }
        }
    }

    private static void startServer() {
        int portNumber = 4445;
        boolean listening = true;
        try {
            socketServer = new ServerSocket(portNumber);
            while (listening) {
                serverThread = new ServerThread(socketServer.accept());
                serverThread.start();
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            System.err.println("Could not listen on port " + portNumber);
            System.exit(-1);
        }
    }

    private static void startClient(Class[] CLASS_ARRAY) {
        logger.debug("Starting in client mode");
        String hostName = conf.getClientConfig();
        int portNumber = 4445;
        try {
            socketClient = new Socket(hostName, portNumber);
            DataOutputStream out = new DataOutputStream(socketClient.getOutputStream());
            DataInputStream in = new DataInputStream(socketClient.getInputStream());
            String str = in.readUTF();
            System.out.println("Server: " + str);
            String jdbc = "jdbc:h2:tcp://" + hostName + ":9092/" + str;
            try {
                sf = HibernateUtil.connectSessionFactory((String)"hbn.mydoc.xml", (String)jdbc, (Class[])CLASS_ARRAY);
            }
            catch (HibernateException ex) {
                logger.error("client mode HibnerateException", (Throwable)ex);
                System.exit(-1);
            }
            catch (SchemaUtil.SchemaUnmatchedException ex) {
                logger.error("client mode schema verfication error", (Throwable)ex);
                System.exit(-1);
            }
            logger.warn("Started in client mode");
            out.writeUTF("ok");
            clientThread = new ClientThread(out, in, new ClientLoadingNoteRunnable());
        }
        catch (UnknownHostException e) {
            System.err.println("Don't know about host " + hostName);
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection to " + hostName);
            logger.error("", (Throwable)e);
            System.exit(1);
        }
    }

    private void initLayout() {
        this.propList = new EntityView();
        DocSpecBuilder.buildDocViewSpec(this.propList);
        NoteSpecBuilder.buildNoteViewSpec(this.propList);
        CodeSpecBuilder.buildCodeViewSpec(this.propList);
        EbookSpecBuilder.buildEbookSpec(this.propList);
        this.propList.setCollapsible(false);
        this.propList.enableDisplayEntityToString(true);
        this.splitPaneListAndProp = new SplitPane();
        this.splitPaneListAndProp.setOrientation(Orientation.VERTICAL);
        this.propListScrollPane = new ScrollPane();
        this.propListScrollPane.setFitToWidth(true);
        this.propListScrollPane.setContent((Node)this.propList);
        this.splitPaneListAndProp.getItems().addAll((Object[])new Node[]{this.entityList, this.propListScrollPane});
        this.splitPaneTreeWithItems = new SplitPane();
        this.splitPaneTreeWithItems.setOrientation(Orientation.HORIZONTAL);
        this.treeBP = new BorderPane();
        this.treeBP.setCenter(tagTree);
        SplitPane.setResizableWithParent((Node)this.treeBP, (Boolean)Boolean.FALSE);
        this.splitPaneTreeWithItems.setDividerPositions(new double[]{0.3});
        this.border = new BorderPane();
        this.border.setTop((Node)this.menuBar);
        this.border.setCenter((Node)this.splitPaneTreeWithItems);
        this.lblStatus = new Label("");
        this.border.setBottom((Node)this.lblStatus);
        tagTree.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.splitPaneTreeWithItems.getItems().addAll((Object[])new Node[]{this.treeBP, this.splitPaneListAndProp});
        this.splitPaneTreeWithItems.setDividerPositions(new double[]{0.3});
        this.border.getChildren().remove((Object)this.splitPaneListAndProp);
        this.border.setCenter((Node)this.splitPaneTreeWithItems);
    }

    private void initMenu() {
        this.menuBar = new MenuBar();
        Menu menuFile = new Menu(rb.getString("MENU_FILE"));
        menuFile.setMnemonicParsing(true);
        this.menuView = new Menu(rb.getString("MENU_VIEW"));
        this.menuView.setMnemonicParsing(true);
        Menu menuEdit = new Menu(rb.getString("MENU_EDIT"));
        menuEdit.setMnemonicParsing(true);
        Menu menuAction = new Menu(rb.getString("MENU_ACTION"));
        menuAction.setMnemonicParsing(true);
        menuAction.setOnShowing(t -> this.adjustTargetMenu());
        Menu menuHelp = MenuItemFactory.createMenu((ProductInfo)this.productInfo);
        menuHelp.setMnemonicParsing(true);
        this.menuBar.getMenus().addAll((Object[])new Menu[]{menuFile, this.menuView, menuAction, menuEdit, menuHelp});
        this.addDoc = new MenuItem(rb.getString("MENU_ADD_DOC"));
        this.addDoc.setMnemonicParsing(true);
        this.addDoc.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+Alt+D"));
        this.addDoc.setOnAction(t -> this.addDoc());
        this.addNote = new MenuItem(rb.getString("MENU_ADD_NOTE"));
        this.addNote.setMnemonicParsing(true);
        this.addNote.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+Alt+N"));
        this.addNote.setOnAction(t -> this.addNote());
        this.addCode = new MenuItem(rb.getString("MENU_ADD_CODE"));
        this.addCode.setMnemonicParsing(true);
        this.addCode.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+Alt+C"));
        this.addCode.setOnAction(t -> this.addCode());
        this.addBook = new MenuItem(rb.getString("MENU_ADD_BOOK"));
        this.addBook.setMnemonicParsing(true);
        this.addBook.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+Alt+B"));
        this.addBook.setOnAction(t -> {
            FileChooser fileChooser = new FileChooser();
            File file = fileChooser.showOpenDialog((Window)primaryStage);
            if (file == null) {
                return;
            }
            this.addBook(file);
        });
        MenuItem mConfig = new MenuItem(rb.getString("MENU_OPTION"));
        mConfig.setMnemonicParsing(true);
        mConfig.setOnAction(t -> {
            this.configStage.display();
            if (this.configStage.getShowHiddenChanged()) {
                this.refreshList();
            }
            if (this.configStage.getLanguageChanged()) {
                Alert alert = new Alert(Alert.AlertType.WARNING, rb.getString("NEED_TO_RESTART"), new ButtonType[0]);
                alert.showAndWait();
            }
            if (this.configStage.getIndexingEnabled()) {
                this.confirmIndex();
            }
        });
        MenuItem mMode = new MenuItem(rb.getString("MENU_MODE"));
        mMode.setMnemonicParsing(true);
        mMode.setOnAction(t -> {
            ModeConfigStage modeStage = new ModeConfigStage();
            modeStage.display();
            if (modeStage.getIsModified()) {
                Alert alert = new Alert(Alert.AlertType.WARNING, rb.getString("RESTART"), new ButtonType[0]);
                alert.showAndWait();
                this.exit();
            }
        });
        MenuItem mReindex = new MenuItem(rb.getString("MENU_REINDEX"));
        mReindex.setMnemonicParsing(true);
        mReindex.setOnAction(t -> this.confirmIndex());
        MenuItem exit = new MenuItem(rb.getString("MENU_EXIT"));
        exit.setMnemonicParsing(true);
        exit.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+Shift+X"));
        exit.setOnAction(t -> this.exit());
        ToggleGroup groupCondition = new ToggleGroup();
        this.radioShowThis = new RadioMenuItem(rb.getString("MENU_SHOW_TAG"));
        this.radioShowThis.setSelected(true);
        this.radioShowThis.setOnAction(e -> this.updateTagMode(TagMode.Exact));
        this.radioShowThis.setToggleGroup(groupCondition);
        this.radioShowSub = new RadioMenuItem(rb.getString("MENU_SHOW_SUBS"));
        this.radioShowSub.setOnAction(e -> this.updateTagMode(TagMode.Sub));
        this.radioShowSub.setToggleGroup(groupCondition);
        this.radioShowFav = new RadioMenuItem(rb.getString("MENU_SHOW_FAV"));
        this.radioShowFav.setOnAction(e -> this.updateTagMode(TagMode.FAVOURITE));
        this.radioShowFav.setToggleGroup(groupCondition);
        this.radioShowNoTag = new RadioMenuItem(rb.getString("MENU_SHOW_NO_TAG"));
        this.radioShowNoTag.setOnAction(e -> this.updateTagMode(TagMode.None));
        this.radioShowNoTag.setToggleGroup(groupCondition);
        this.radioShowAll = new RadioMenuItem(rb.getString("MENU_SHOW_ALL"));
        this.radioShowAll.setOnAction(e -> this.updateTagMode(TagMode.ALL));
        this.radioShowAll.setToggleGroup(groupCondition);
        this.cmiDoc = new CheckMenuItem(rb.getString("DOC"));
        this.cmiDoc.setSelected(true);
        this.cmiDoc.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                listDoc = new_val;
                MydocMain.this.refreshList();
            }
        });
        this.cmiNote = new CheckMenuItem(rb.getString("NOTE"));
        this.cmiNote.setSelected(true);
        this.cmiNote.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                listNote = new_val;
                MydocMain.this.refreshList();
            }
        });
        this.cmiBook = new CheckMenuItem(rb.getString("BOOK"));
        this.cmiBook.setSelected(true);
        this.cmiBook.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                listBook = new_val;
                MydocMain.this.refreshList();
            }
        });
        this.cmiCode = new CheckMenuItem(rb.getString("CODE"));
        this.cmiCode.setSelected(true);
        this.cmiCode.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                listCode = new_val;
                MydocMain.this.refreshList();
            }
        });
        listNote = true;
        listDoc = true;
        listCode = true;
        listBook = true;
        this.cmiShowProp = new CheckMenuItem(rb.getString("PROPERTY"));
        this.cmiShowProp.setMnemonicParsing(true);
        this.cmiShowProp.setSelected(true);
        this.cmiShowProp.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                if (new_val.booleanValue()) {
                    MydocMain.this.splitPaneListAndProp.getItems().add((Object)MydocMain.this.propListScrollPane);
                } else {
                    MydocMain.this.splitPaneListAndProp.getItems().remove((Object)MydocMain.this.propListScrollPane);
                }
            }
        });
        this.cmiShowFloatingStage = new CheckMenuItem(rb.getString("FLOATING_WINDOW"));
        this.cmiShowFloatingStage.setMnemonicParsing(true);
        this.cmiShowFloatingStage.setSelected(true);
        this.cmiShowFloatingStage.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                if (new_val.booleanValue()) {
                    floatingSearchStage.show();
                } else {
                    floatingSearchStage.hide();
                }
            }
        });
        final CheckMenuItem cmiShowFullTextStage = new CheckMenuItem(rb.getString("MENU_SHOW_FULLTEXT_WINDOW"));
        cmiShowFullTextStage.setMnemonicParsing(true);
        cmiShowFullTextStage.setSelected(true);
        cmiShowFullTextStage.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue ov, Boolean old_val, Boolean new_val) {
                if (new_val.booleanValue()) {
                    HighlighterStage.getInstance().show();
                } else {
                    HighlighterStage.getInstance().hide();
                }
            }
        });
        MenuItem mPublishers = new MenuItem(rb.getString("PUBLISHERS"));
        mPublishers.setMnemonicParsing(true);
        mPublishers.setOnAction(t -> {
            PublisherStage ps = new PublisherStage(sf.openSession());
            ps.showAndWait();
        });
        MenuItem mAuthor = new MenuItem(rb.getString("SEARCH_AUTHOR"));
        mAuthor.setMnemonicParsing(true);
        mAuthor.setOnAction(t -> {
            try (Session s = sf.openSession();){
                AuthorSelectionStage stage = new AuthorSelectionStage(s);
                stage.showAndWait();
            }
        });
        this.mOpen = new MenuItem(rb.getString("MENU_OPEN"));
        this.mOpen.setMnemonicParsing(true);
        this.mOpen.setOnAction(t -> MydocMain.actionOpen(this.entityList.getSelectedEntity()));
        this.mShowProperty = new MenuItem(rb.getString("SHOW_PROP_WINDOW"));
        this.mShowProperty.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+P"));
        this.mShowProperty.setMnemonicParsing(true);
        this.mShowProperty.setOnAction(t -> this.launchPropertyStage(this.entityList.getSelectedEntity()));
        this.mFavourite = new CheckMenuItem(rb.getString("MENU_FAVOURITE"));
        this.mFavourite.setMnemonicParsing(true);
        this.mFavourite.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+F"));
        this.mFavourite.setOnAction(t -> MydocMain.actionFavourite(this.entityList.getSelectedEntity()));
        this.mDelete = new MenuItem(rb.getString("MENU_DELETE"));
        this.mDelete.setMnemonicParsing(true);
        this.mDelete.setOnAction(t -> MydocMain.actionDelete(this.entityList.getSelectedEntity()));
        this.mNoteCopyContent = new MenuItem(rb.getString("COPY_CONTENT"));
        this.mNoteCopyContent.setMnemonicParsing(true);
        this.mNoteCopyContent.setOnAction(t -> {});
        menuFile.getItems().addAll((Object[])new MenuItem[]{this.addDoc, this.addNote, this.addBook, this.addCode});
        menuFile.getItems().addAll((Object[])new MenuItem[]{new SeparatorMenuItem()});
        if (LicenseManager.isDev()) {
            menuFile.getItems().add((Object)mMode);
        }
        menuFile.getItems().addAll((Object[])new MenuItem[]{mReindex, mConfig, new SeparatorMenuItem(), exit});
        this.menuView.getItems().addAll((Object[])new MenuItem[]{this.cmiShowProp, this.cmiShowFloatingStage, cmiShowFullTextStage});
        this.menuView.setOnShowing(new EventHandler(){

            public void handle(Event event) {
                MydocMain.this.cmiShowFloatingStage.setSelected(floatingSearchStage.isShowing());
                cmiShowFullTextStage.setSelected(HighlighterStage.getInstance().isShowing());
            }
        });
        menuEdit.getItems().addAll((Object[])new MenuItem[]{mPublishers, mAuthor});
        menuAction.getItems().addAll((Object[])new MenuItem[]{this.mOpen, this.mShowProperty, this.mFavourite, new SeparatorMenuItem(), this.mDelete});
        if (LicenseManager.isDev()) {
            menuAction.getItems().add((Object)this.mNoteCopyContent);
        }
        SeparatorMenuItem smi1 = new SeparatorMenuItem();
        SeparatorMenuItem smi2 = new SeparatorMenuItem();
        this.menuView.getItems().addAll((Object[])new MenuItem[]{smi1, this.radioShowThis, this.radioShowSub, this.radioShowFav, this.radioShowNoTag, this.radioShowAll, smi2, this.cmiDoc, this.cmiNote, this.cmiBook, this.cmiCode});
    }

    private void adjustTargetMenu() {
        Entity en = this.entityList.getSelectedEntity();
        if (en == null) {
            this.mOpen.setDisable(true);
            this.mShowProperty.setDisable(true);
            this.mNoteCopyContent.setDisable(true);
            this.mDelete.setDisable(true);
            this.mFavourite.setDisable(true);
            return;
        }
        this.mFavourite.setDisable(false);
        if (en instanceof Note) {
            this.mOpen.setDisable(false);
            this.mShowProperty.setDisable(false);
            this.mNoteCopyContent.setDisable(false);
            this.mDelete.setDisable(false);
            this.mFavourite.setSelected(((Note)en).isFavourite());
        } else if (en instanceof Doc) {
            this.mOpen.setDisable(false);
            this.mShowProperty.setDisable(false);
            this.mNoteCopyContent.setDisable(true);
            this.mDelete.setDisable(false);
            this.mFavourite.setSelected(((Doc)en).isFavourite());
        } else if (en instanceof Ebook) {
            this.mOpen.setDisable(false);
            this.mShowProperty.setDisable(false);
            this.mNoteCopyContent.setDisable(true);
            this.mDelete.setDisable(false);
            this.mFavourite.setSelected(((Ebook)en).isFavourite());
        } else if (en instanceof Code) {
            this.mOpen.setDisable(true);
            this.mShowProperty.setDisable(false);
            this.mNoteCopyContent.setDisable(true);
            this.mDelete.setDisable(false);
            this.mFavourite.setSelected(((Code)en).isFavourite());
        }
    }

    public Stage isEntityLocked(Entity en) {
        return entityIdToStage.get(en.getId());
    }

    public void lockEntity(Entity en, Stage stage) {
        entityIdToStage.put(en.getId(), stage);
    }

    public void releaseEntity(Entity en) {
        entityIdToStage.remove(en.getId());
    }

    public void releaseTagGUIController(TagGUIController controller) {
        tagGUISet.remove(controller);
    }

    private void confirmIndex() {
        ButtonType typeAll = new ButtonType(rb.getString("INDEX_ALL"));
        ButtonType typeMissing = new ButtonType(rb.getString("INDEX_MISSING"));
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, rb.getString("INDEX_NOW"), new ButtonType[]{typeAll, typeMissing, ButtonType.CANCEL});
        alert.showAndWait();
        if (alert.getResult() == typeAll) {
            this.buildIndex(false);
        } else if (alert.getResult() == typeMissing) {
            this.buildIndex(true);
        }
    }

    private void addNote() {
        try {
            Tag noteCategory = null;
            Note newNote = noteMgr.createNote(noteCategory);
            NoteHtmlEditorStage htmlEditorStage = new NoteHtmlEditorStage(sf);
            htmlEditorStage.setNote(newNote);
            this.lockEntity((Entity)newNote, htmlEditorStage);
            htmlEditorStage.showAndWait();
            if (htmlEditorStage.getIsSaved()) {
                this.updateMainList((Entity)newNote, ListOperationMode.Add);
            }
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
    }

    private void addCode() {
        Code code = new Code();
        Snippet s1 = new Snippet();
        s1.setPath("untitled.java");
        RelationCollection r = (RelationCollection)code.getRelation("snippet");
        r.setTargets(new Entity[]{s1});
        CodeStage codeStage = new CodeStage(sf);
        codeStage.setCode(code);
        codeStage.showAndWait();
        if (codeStage.getSaved()) {
            this.updateMainList((Entity)code, ListOperationMode.Add);
        }
    }

    private void addDoc() {
        FileChooser fileChooser = new FileChooser();
        File file = fileChooser.showOpenDialog((Window)primaryStage);
        if (file == null) {
            return;
        }
        this.addDoc(file);
    }

    private void addDoc(File file) {
        String md5 = null;
        try {
            md5 = HashUtil.computeMD5((File)file);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        List docList = DocManager.searchForMD5((Session)sf.openSession(), (String)md5);
        if (docList.size() > 0) {
            this.sameFileDialog.setAndShow(docList);
            FxOptionPane.Response r = this.sameFileDialog.getResponse();
            if (r != FxOptionPane.Response.YES) {
                return;
            }
        }
        Doc doc = null;
        try {
            doc = docMgr.createDoc(file.getName(), md5);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            return;
        }
        DocNewStage docStage = new DocNewStage(primaryStage);
        docStage.setDoc(doc, file);
        this.lockEntity((Entity)doc, docStage);
        tagGUISet.add(docStage);
        docStage.showAndWait();
        if (docStage.getSaved()) {
            this.updateMainList((Entity)doc, ListOperationMode.Add);
        }
    }

    private void addBook(final File file) {
        final File targetFile = file;
        final Task task = new Task(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected String call() throws Exception {
                String md5 = HashUtil.computeMD5((File)file);
                try (Session s = sf.openSession();){
                    MydocMain.this.existingEbooks = EbookDAO.searchForMD5((Session)s, (String)md5);
                }
                return md5;
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                if (MydocMain.this.existingEbooks.size() > 0) {
                    MydocMain.this.sameFileDialog.setAndShow(MydocMain.this.existingEbooks);
                    FxOptionPane.Response r = MydocMain.this.sameFileDialog.getResponse();
                    if (r != FxOptionPane.Response.YES) {
                        return;
                    }
                }
                EbookFileInfo fileInfo = new EbookFileInfo();
                fileInfo.setFileName(targetFile.getAbsolutePath());
                fileInfo.setMd5((String)task.getValue());
                Ebook ebook = new Ebook();
                RelationCollection r = (RelationCollection)ebook.getRelation("file_info");
                r.setTargets(new Entity[]{fileInfo});
                EbookNewStage ebookStage = new EbookNewStage(primaryStage, sf.openSession());
                ebookStage.setEbook(ebook, targetFile.getAbsolutePath());
                ebookStage.showAndWait();
                if (ebookStage.isSaved()) {
                    MydocMain.this.updateMainList((Entity)ebook, ListOperationMode.Add);
                }
            }
        });
        new Thread((Runnable)task).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatch(GUIEvent e) {
        if (tagTree.equals(e.getSource())) {
            switch (e.getEventName()) {
                case "Tree_selected": {
                    Entity entity = (Entity)e.getValue();
                    if (!(entity instanceof Tag)) break;
                    this.currTag = (Tag)entity;
                    if (tagMode == TagMode.ALL || tagMode == TagMode.None) {
                        return null;
                    }
                    this.loadList(this.currTag);
                    break;
                }
                case "Tree_item_changed": {
                    for (TagGUIController tagGUI : tagGUISet) {
                        tagGUI.makeInvalid();
                    }
                    break;
                }
            }
            return null;
        }
        if (floatingSearchStage.equals(e.getSource())) {
            switch (e.getEventName()) {
                case "FloatingStage_dropped": {
                    List files = (List)e.getValue();
                    if (files.size() > 1) {
                        Alert alert = new Alert(Alert.AlertType.ERROR, rb.getString("SELECT_ONE_FILE"), new ButtonType[0]);
                        alert.showAndWait();
                        break;
                    }
                    this.addDoc((File)files.get(0));
                }
            }
            return null;
        }
        if (this.entityList.equals(e.getSource())) {
            Entity entity = (Entity)e.getValue();
            switch (e.getEventName()) {
                case "EntityList_selected": {
                    if (entity == null) {
                        return null;
                    }
                    if (entity instanceof Code) {
                        this.propList.setEntity(entity);
                        break;
                    }
                    try (Session s = sf.openSession();){
                        entity = (Entity)s.get(entity.getClass(), (Serializable)entity.getId());
                        this.propList.setEntity(entity);
                        break;
                    }
                }
                case "EntityList_default_control": {
                    entity = (Entity)e.getValue();
                    this.launchPropertyStage(entity);
                    break;
                }
                case "EntityList_open": 
                case "EntityList_default": {
                    MydocMain.actionOpen(entity);
                    break;
                }
                case "EntityList_delete": {
                    MydocMain.actionDelete(entity);
                    break;
                }
            }
        } else if (e.getSource().getClass().equals(EntityWithExcerpts.class)) {
            MydocMain.actionOpen((Entity)e.getValue());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheEntityTags(Entity entity) {
        try (Session s = sf.openSession();){
            s.update((Object)entity);
            RelationCollection r = (RelationCollection)entity.getRelation("tags");
            this.cachedTags = (Tag[])r.getTarget();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateMainList(Entity entity, ListOperationMode mode) {
        block40: {
            if (MydocMain.tagMode == TagMode.FAVOURITE) {
                v0 = inList = entity.getPropertyValue("favourite") != null;
                if (inList) {
                    switch (26.$SwitchMap$myencyclopedia$gui$mydoc$MydocMain$ListOperationMode[mode.ordinal()]) {
                        case 1: {
                            if (this.entityList.itemRefresh(entity)) break;
                            this.entityList.itemAdd(entity);
                            break;
                        }
                        case 2: {
                            this.entityList.itemAdd(entity);
                            break;
                        }
                        case 3: {
                            this.entityList.itemDelete(entity);
                        }
                    }
                } else {
                    this.entityList.itemDelete(entity);
                }
                return;
            }
            if (MydocMain.tagMode == TagMode.ALL) {
                switch (26.$SwitchMap$myencyclopedia$gui$mydoc$MydocMain$ListOperationMode[mode.ordinal()]) {
                    case 1: {
                        if (this.entityList.itemRefresh(entity)) break;
                        this.entityList.itemAdd(entity);
                        break;
                    }
                    case 2: {
                        this.entityList.itemAdd(entity);
                        break;
                    }
                    case 3: {
                        this.entityList.itemDelete(entity);
                    }
                }
                return;
            }
            inList = false;
            tags = null;
            s = MydocMain.sf.openSession();
            switch (26.$SwitchMap$myencyclopedia$gui$mydoc$MydocMain$ListOperationMode[mode.ordinal()]) {
                case 1: 
                case 2: {
                    s.update((Object)entity);
                    r = (Tag[])entity.getRelation("tags");
                    tags = (Tag[])r.getTarget();
                    break;
                }
                case 3: {
                    tags = this.cachedTags;
                }
            }
            try {
                switch (26.$SwitchMap$myencyclopedia$gui$mydoc$MydocMain$TagMode[MydocMain.tagMode.ordinal()]) {
                    case 1: {
                        if (this.currTag == null) {
                            return;
                        }
                        if (tags == null) break;
                        for (Tag t : tags) {
                            if (!Objects.equals(t.getId(), this.currTag.getId())) continue;
                            inList = true;
                            ** break;
lbl57:
                            // 1 sources

                            break block40;
                        }
                        break;
                    }
                    ** case 2:
                    case 3: {
                        if (tags == null) {
                            inList = true;
                            ** break;
                        }
lbl64:
                        // 3 sources

                        break;
                    }
                    default: {
                        MydocMain.logger.error("error mode in updateMainList");
                        break;
                    }
                }
            }
            catch (Exception ex) {
                MydocMain.logger.error("", (Throwable)ex);
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        switch (26.$SwitchMap$myencyclopedia$gui$mydoc$MydocMain$ListOperationMode[mode.ordinal()]) {
            case 1: {
                if (inList) {
                    if (this.entityList.itemRefresh(entity)) break;
                    this.entityList.itemAdd(entity);
                    break;
                }
                this.entityList.itemDelete(entity);
                break;
            }
            case 2: {
                if (!inList) break;
                this.entityList.itemAdd(entity);
                break;
            }
            case 3: {
                if (!inList) break;
                this.entityList.itemDelete(entity);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launchWithURL(String url) {
        String[] strs = url.split("#");
        HBAbstractEntity entity = null;
        try (Session s = sf.openSession();){
            entity = (HBAbstractEntity)s.get(HBAbstractEntity.class, (Serializable)Long.valueOf(Long.parseLong(strs[1])));
        }
        if (entity instanceof Note) {
            MydocMain.launchNote((Note)entity);
        } else {
            mydocMain.launchPropertyStage((Entity)entity);
        }
    }

    public static void actionOpen(Entity entity) {
        if (entity instanceof Doc) {
            MydocMain.launchDoc((Doc)entity);
        } else if (entity instanceof Note) {
            MydocMain.launchNote((Note)entity);
        } else if (entity instanceof Code) {
            MydocMain.launchCode((Code)entity, true);
        } else if (entity instanceof Ebook) {
            MydocMain.launchEbook((Ebook)entity);
        }
    }

    public static void actionOpenOrig(Entity entity) {
        if (entity instanceof Doc) {
            MydocMain.launchDoc((Doc)entity, false);
        } else if (entity instanceof Note) {
            logger.error("actionOpenOrig Note", new Throwable());
        } else if (entity instanceof Code) {
            logger.error("actionOpenOrig Code", new Throwable());
        } else if (entity instanceof Ebook) {
            MydocMain.launchEbook((Ebook)entity, false);
        }
    }

    public static void actionGotoFolder(Entity entity) {
        if (entity instanceof Doc) {
            Doc doc = (Doc)entity;
            Path docPath = Paths.get(pathDoc.toString(), doc.getContentFolder());
            Path leadingFile = Paths.get(docPath.toString(), (String)doc.getFileList().get(0));
            LaunchUtils.exploreFolderAndSelectFile((String)leadingFile.toString());
        } else if (entity instanceof Note) {
            Note note = (Note)entity;
            String filePath = note.getFilePath();
            if (filePath == null) {
                filePath = "";
            }
            Path file = Paths.get(NoteManager.getInstance().getNoteFolder().toString(), filePath);
            LaunchUtils.exploreFolderAndSelectFile((String)file.toString());
        } else if (entity instanceof Code) {
            Code code = (Code)entity;
            Path basePath = Paths.get(ConfigMydoc.getInstance().getNodeValue("/myencyclopedia/mydoc/note/path"), (String)code.getPropertyValue("filepath"));
            LaunchUtils.exploreFolderAndSelectFile((String)basePath.toString());
        }
    }

    public static void actionFavourite(Entity entity) {
        if (entity.getPropertyValue("favourite") == null) {
            entity.setPropertyValue("favourite", (Object)1);
        } else {
            entity.setPropertyValue("favourite", null);
        }
        Session s = sf.openSession();
        s.beginTransaction();
        try {
            s.update((Object)entity);
            s.getTransaction().commit();
        }
        finally {
            s.close();
        }
        if (tagMode == TagMode.FAVOURITE) {
            mydocMain.refreshList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void actionDelete(Entity entity) {
        block17: {
            mydocMain.cacheEntityTags(entity);
            try {
                if (entity instanceof Doc) {
                    docMgr.delete((Doc)entity, conf.getMoveToTrash());
                    mydocMain.updateMainList(entity, ListOperationMode.Delete);
                    break block17;
                }
                if (entity instanceof Note) {
                    noteMgr.delete((Note)entity, conf.getMoveToTrash());
                    mydocMain.updateMainList(entity, ListOperationMode.Delete);
                    break block17;
                }
                if (entity instanceof Ebook) {
                    Ebook book = (Ebook)entity;
                    try (Session s = sf.openSession();){
                        EbookDAO.delete((Session)s, (Ebook)book);
                        mydocMain.updateMainList(entity, ListOperationMode.Delete);
                        break block17;
                    }
                }
                if (!(entity instanceof Code)) break block17;
                Code code = (Code)entity;
                Path file = Paths.get(pathCode.toString(), code.getFilepath());
                if (conf.getMoveToTrash()) {
                    Files.move(file, pathTrash, new CopyOption[0]);
                } else {
                    FileUtils.deleteDirectory((File)file.toFile());
                }
                try (Session s = sf.openSession();){
                    CodeDAO.delete((Session)s, (Code)code);
                    mydocMain.updateMainList(entity, ListOperationMode.Delete);
                }
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
                new Alert(Alert.AlertType.ERROR, ex.toString(), new ButtonType[0]).showAndWait();
            }
        }
    }

    private boolean addWhenTagged(Tag tag) {
        switch (tagMode) {
            case Exact: {
                if (this.currTag == null) {
                    return true;
                }
                if (!Objects.equals(tag.getId(), this.currTag.getId())) break;
                return true;
            }
            case Sub: {
                break;
            }
            case None: {
                if (tag != null) break;
                return true;
            }
            case ALL: {
                return true;
            }
        }
        return false;
    }

    public void refreshList() {
        this.loadList(this.currTag);
    }

    public static Class<? extends Entity>[] getAllTargets() {
        return new Class[]{Note.class, Doc.class, Ebook.class, Code.class};
    }

    public static Class<? extends Entity>[] getPotentialTargets() {
        ArrayList<Class> ret = new ArrayList<Class>();
        if (listNote) {
            ret.add(Note.class);
        }
        if (listDoc) {
            ret.add(Doc.class);
        }
        if (listBook) {
            ret.add(Ebook.class);
        }
        if (listCode) {
            ret.add(Code.class);
        }
        Class[] a = new Class[]{Ebook.class};
        return ret.toArray(a);
    }

    private void loadList(Tag tag) {
        MECriteria criteria = new MECriteria(this.receiver, (Class[])MydocMain.getPotentialTargets());
        switch (tagMode) {
            case Exact: {
                if (tag == null) {
                    return;
                }
                this.lblStatus.setText(String.format(rb.getString("LOADING_TAG"), this.currTag));
                criteria.addTagCriterion(tag, false);
                break;
            }
            case Sub: {
                if (tag == null) {
                    return;
                }
                criteria.addTagCriterion(tag, true);
                this.lblStatus.setText(String.format(rb.getString("LOADING_SUB_TAGS"), this.currTag));
                break;
            }
            case None: {
                criteria.addNoneTagCriterion();
                this.lblStatus.setText(rb.getString("LOADING_NOT_TAGGED"));
                break;
            }
            case FAVOURITE: {
                criteria.addFavouriteCriterionForAll();
                this.lblStatus.setText(rb.getString("LOADING_FAVOURITE"));
                break;
            }
            case ALL: {
                this.lblStatus.setText(rb.getString("LOADING_ALL"));
            }
        }
        searchThread.produce(null, (Object)criteria);
    }

    private void updateTagMode(TagMode newTagMode) {
        if (!tagMode.equals((Object)newTagMode)) {
            tagMode = newTagMode;
            this.refreshList();
        }
    }

    public void launchPropertyStage(Entity entity) {
        Stage existingStage = this.isEntityLocked(entity);
        if (existingStage != null) {
            existingStage.show();
            existingStage.setIconified(false);
            existingStage.toFront();
            return;
        }
        if (entity instanceof Ebook) {
            EbookEditingStage ebookStage = new EbookEditingStage(primaryStage, sf.openSession());
            ebookStage.setEbook(entity.getId());
            this.lockEntity(entity, ebookStage);
            ebookStage.show();
        } else if (entity instanceof Doc) {
            DocPropertyEditingStage docPropStage = new DocPropertyEditingStage(sf);
            docPropStage.setEntity(entity.getId());
            this.lockEntity(entity, docPropStage);
            docPropStage.show();
        } else if (entity instanceof Note) {
            NotePropertyEditingStage notePropStage = new NotePropertyEditingStage(sf);
            notePropStage.setEntity(entity.getId());
            this.lockEntity(entity, notePropStage);
            notePropStage.show();
        } else if (entity instanceof Code) {
            MydocMain.launchCode((Code)entity, false);
        }
    }

    public static void launchDoc(Doc doc) {
        MydocMain.launchDoc(doc, ConfigMydoc.getInstance().getCopyDocPathEnabled());
    }

    public static void launchDoc(Doc doc, boolean copyEnabled) {
        Path docPath = Paths.get(pathDoc.toString(), doc.getContentFolder());
        if (copyEnabled) {
            try {
                FileUtils.copyDirectory((File)docPath.toFile(), (File)pathTemp.toFile());
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
                Alert alert = new Alert(Alert.AlertType.ERROR, ex.toString(), new ButtonType[0]);
                alert.setTitle(rb.getString("CANNOT_LAUNCH_DOC"));
                alert.showAndWait();
                return;
            }
            docPath = pathTemp;
        }
        Path leadingFile = Paths.get(docPath.toString(), (String)doc.getFileList().get(0));
        LaunchUtils.openFileWithDefaultApp((Path)leadingFile);
    }

    public static void launchNote(Note note) {
        Stage existingStage = mydocMain.isEntityLocked((Entity)note);
        if (existingStage != null) {
            existingStage.show();
            existingStage.setIconified(false);
            existingStage.toFront();
        } else if (MODE_CLIENT.equals(conf.getMode())) {
            clientThread.produce(note);
        } else {
            NoteHtmlEditorStage htmlEditorStage = new NoteHtmlEditorStage(sf);
            htmlEditorStage.setNote(note.getId());
            mydocMain.lockEntity((Entity)note, htmlEditorStage);
            htmlEditorStage.show();
        }
    }

    public static void launchCode(Code code) {
        MydocMain.launchCode(code, true);
    }

    public static void launchCode(Code code, boolean fullMode) {
        Stage existingStage = mydocMain.isEntityLocked((Entity)code);
        if (existingStage != null) {
            existingStage.toFront();
        } else {
            CodeStage codeStage = new CodeStage(sf);
            codeStage.setCode(code);
            codeStage.switchToMode(fullMode);
            codeStage.show();
            mydocMain.lockEntity((Entity)code, codeStage);
        }
    }

    public static void launchEbookFile(EbookFileInfo fileInfo, boolean copyEnabled) {
        Path ebookFile = null;
        Path orig = Paths.get(conf.getBookShelfPath().toString(), fileInfo.getRelativePath(), fileInfo.getFileName());
        if (copyEnabled) {
            ebookFile = Paths.get(pathTemp.toString(), orig.getFileName().toString());
            try {
                FileCopyUtil.copy((Path)orig, (Path)ebookFile);
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
                Alert alert = new Alert(Alert.AlertType.ERROR, ex.toString(), new ButtonType[0]);
                alert.setTitle(rb.getString("CANNOT_LAUNCH_EBOOK_FILE"));
                alert.showAndWait();
                return;
            }
        } else {
            ebookFile = orig;
        }
        LaunchUtils.openFileWithDefaultApp((Path)ebookFile);
    }

    public static void launchEbook(Ebook ebook) {
        MydocMain.launchEbook(ebook, ConfigMydoc.getInstance().getCopyDocPathEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void launchEbook(Ebook ebook, boolean copyEnabled) {
        EbookFileInfo fileInfo = null;
        try (Session s = sf.openSession();){
            ebook = (Ebook)s.get(Ebook.class, (Serializable)ebook.getId());
            RelationCollection r = (RelationCollection)ebook.getRelation("file_info");
            Entity[] entities = r.getTarget();
            fileInfo = (EbookFileInfo)entities[0];
            if (entities == null || entities.length == 0) {
                logger.error("no file for ebook:" + ebook.getId());
                return;
            }
        }
        MydocMain.launchEbookFile(fileInfo, copyEnabled);
    }

    public static void followTag(String tagPath) {
        tagTree.selectNode(tagPath);
    }

    public static void submitSearch(AsyncListReceiver r, MECriteria c) {
        searchThread.produce((Object)r, (Object)c);
    }

    static /* synthetic */ Logger access$1300() {
        return logger;
    }

    static {
        entityIdToStage = new HashMap();
        tagGUISet = new HashSet<TagGUIController>();
        logger = LoggerFactory.getLogger(MydocMain.class);
        isIndexEnabled = true;
        tagMode = TagMode.Exact;
        firstRun = false;
    }

    static enum TagMode {
        Sub,
        None,
        Exact,
        ALL,
        FAVOURITE;

    }

    public static enum ListOperationMode {
        Modify,
        Delete,
        Add;

    }
}

