/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.logic.mydoc.NoteManager;
import myencyclopedia.model.mydoc.Note;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MydocProtocol {
    private static final Logger logger = LoggerFactory.getLogger(MydocProtocol.class);
    Status status = Status.INITIAL;

    public String processInput(String theInput) {
        if (this.status == Status.INITIAL) {
            ConfigMydoc conf = ConfigMydoc.getInstance();
            this.status = Status.NORMAL;
            return conf.getDBURL();
        }
        if (this.status == Status.NORMAL) {
            String noteContent = MydocProtocol.loadString(Long.parseLong(theInput));
            return noteContent;
        }
        return "";
    }

    public static String loadString(long noteId) {
        Session s = MydocMain.sf.openSession();
        Note note = (Note)s.load(Note.class, (Serializable)Long.valueOf(noteId));
        String filePath = note.getFilePath();
        Path file = Paths.get(NoteManager.getInstance().getNoteFolder().toString(), filePath);
        List<String> lines = null;
        try {
            lines = Files.readAllLines(file);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        StringBuffer sb = new StringBuffer();
        for (String line : lines) {
            sb.append(line);
        }
        return sb.toString();
    }

    static enum Status {
        INITIAL,
        NORMAL;

    }
}

