/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.TemplateStage;
import myencyclopedia.common.gui.entity.EntityList;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.hibernate.crud.QueryUtil;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.ebook.Publisher;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublisherStage
extends TemplateStage
implements GUIListener {
    private static final Logger logger = LoggerFactory.getLogger(PublisherStage.class);
    private TextField input;
    private Session s;
    private EntityList list;

    public PublisherStage(final Session s) {
        this.initModality(Modality.APPLICATION_MODAL);
        this.setTitle(MydocMain.rb.getString("CREATE_PUBLISHERS"));
        this.getIcons().add((Object)ImageFactory.IMG_STAGE_PUBLISHER);
        this.s = s;
        List lst = QueryUtil.loadAll((Session)s, Publisher.class);
        this.list = new EntityList((GUIListener)this);
        this.list.itemsAdd(lst);
        this.btnOK.setText(MydocMain.rb.getString("CREATE"));
        this.input = new TextField();
        Label lblNew = new Label(MydocMain.rb.getString("INPUT_PUBLISHER_NAME"));
        Label lblExisting = new Label(MydocMain.rb.getString("EXISTING_PUBLISHERS"));
        VBox box = new VBox();
        VBox.setVgrow((Node)this.list, (Priority)Priority.ALWAYS);
        box.getChildren().addAll((Object[])new Node[]{lblNew, this.input, lblExisting, this.list});
        this.bp.setCenter((Node)box);
        this.list.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().equals((Object)KeyCode.DELETE)) {
                    if (PublisherStage.this.list.getSelectedEntity() == null) {
                        return;
                    }
                    Publisher p = (Publisher)PublisherStage.this.list.getSelectedEntity();
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION, String.format(MydocMain.rb.getString("CONFIRM_DELETE"), p.getName()), new ButtonType[0]);
                    alert.showAndWait().ifPresent(response -> {
                        if (response == ButtonType.OK) {
                            PublisherStage.this.tryDelete(p);
                        }
                    });
                }
            }
        });
        this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                s.close();
            }
        });
    }

    private void tryDelete(Publisher p) {
        Criteria crit = this.s.createCriteria(Ebook.class);
        List resultList = crit.createCriteria("publishers").createCriteria("targetEntity").add((Criterion)Restrictions.eq((String)"id", (Object)p.getId())).list();
        if (!resultList.isEmpty()) {
            Alert alert = new Alert(Alert.AlertType.WARNING, String.format(MydocMain.rb.getString("CANNOT_DELETE"), p.getName()), new ButtonType[0]);
            alert.showAndWait();
            return;
        }
        this.s.beginTransaction();
        try {
            this.s.delete((Object)p);
            this.s.getTransaction().commit();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        this.list.getItems().remove(p);
    }

    protected Object prepareResult() {
        String name = this.input.getText();
        if (name.trim().isEmpty()) {
            return null;
        }
        Publisher p = new Publisher();
        p.setName(name);
        this.s.beginTransaction();
        try {
            this.s.save((Object)p);
            this.s.getTransaction().commit();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        return p;
    }

    public Object dispatch(GUIEvent e) {
        return null;
    }
}

