/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import myencyclopedia.gui.mydoc.MydocProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerThread
extends Thread {
    private Socket socket = null;
    private static final Logger logger = LoggerFactory.getLogger(ServerThread.class);

    public ServerThread(Socket socket) {
        super("Mydoc ServerThread");
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (DataOutputStream out = new DataOutputStream(this.socket.getOutputStream());
             DataInputStream in = new DataInputStream(this.socket.getInputStream());){
            MydocProtocol protocol = new MydocProtocol();
            String outStr = protocol.processInput(null);
            out.writeUTF(outStr);
            String inStr = in.readUTF();
            logger.debug("client ack:" + inStr);
            while ((inStr = in.readUTF()) != null) {
                logger.debug("client request:" + inStr);
                out.writeUTF(protocol.processInput(inStr));
            }
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException ex) {
                logger.error("closing client socket error", (Throwable)ex);
            }
        }
    }
}

