/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.entity.view.AbstractRenderer;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.logic.mydoc.tag.TagManager;
import myencyclopedia.model.common.entity.Tag;

public class TagsRenderer
extends AbstractRenderer {
    private HBox hbox = new HBox();
    private boolean noEditingLink = false;

    public TagsRenderer() {
        this(false);
    }

    public TagsRenderer(boolean noEditingLink) {
        this.noEditingLink = noEditingLink;
    }

    public Region getRendererControl() {
        return this.hbox;
    }

    public void loadRendererObject(Object obj) {
        this.hbox.getChildren().clear();
        if (obj != null) {
            if (obj instanceof Tag) {
                Tag t = (Tag)obj;
                this.constructHyperlink(t);
            } else {
                Tag[] tags;
                for (Tag t : tags = (Tag[])obj) {
                    this.constructHyperlink(t);
                }
            }
        }
        if (!this.noEditingLink) {
            Hyperlink linkEdit = new Hyperlink(MydocMain.rb.getString("EDIT"));
            linkEdit.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent e) {
                    TagsRenderer.this.requestSwitchToEditor();
                }
            });
            this.hbox.getChildren().add((Object)linkEdit);
        }
    }

    private void constructHyperlink(Tag t) {
        final String fullName = TagManager.getInstance().getFullName(t);
        Hyperlink hpl = new Hyperlink(t.getName());
        hpl.setStyle("-fx-underline: true;");
        hpl.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                MydocMain.followTag(fullName);
            }
        });
        hpl.setTooltip(new Tooltip(fullName));
        this.hbox.getChildren().add((Object)hpl);
    }

    public Object clone() throws CloneNotSupportedException {
        return new TagsRenderer();
    }
}

