/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.code;

import java.nio.file.Path;
import java.nio.file.Paths;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.web.WebView;

public class CodeEditor
extends BorderPane {
    public final WebView webview = new WebView();
    private String editingCode = "\n\n\n\n\n";
    private String mode = "text/x-java";
    private String otherLang = "";
    private String keymap = "default";
    public static final String EMPTY_CODE = "\n\n\n\n\n";
    private final String editingTemplate = "<!doctype html><html><head>  <link rel=\"stylesheet\" href=\"file:///${basepath}/static/codemirror/lib/codemirror.css\">  <script src=\"file:///${basepath}/static/codemirror/lib/codemirror.js\"></script>  <script src=\"file:///${basepath}/static/codemirror/mode/clike/clike.js\"></script>  <script src=\"file:///${basepath}/static/codemirror/keymap/vim.js\"></script>  ${other_lang}</head><body><textarea id=\"code\" name=\"code\" >\n${code}</textarea><script>  var editor = CodeMirror.fromTextArea(document.getElementById(\"code\"), {    lineNumbers: true,    matchBrackets: true,    mode: \"${mode}\",    keyMap: \"${keymap}\"  });editor.setSize(\"100%\", \"auto\");</script></body></html>";

    private String applyEditingTemplate() {
        Path current = Paths.get(".", new String[0]);
        return "<!doctype html><html><head>  <link rel=\"stylesheet\" href=\"file:///${basepath}/static/codemirror/lib/codemirror.css\">  <script src=\"file:///${basepath}/static/codemirror/lib/codemirror.js\"></script>  <script src=\"file:///${basepath}/static/codemirror/mode/clike/clike.js\"></script>  <script src=\"file:///${basepath}/static/codemirror/keymap/vim.js\"></script>  ${other_lang}</head><body><textarea id=\"code\" name=\"code\" >\n${code}</textarea><script>  var editor = CodeMirror.fromTextArea(document.getElementById(\"code\"), {    lineNumbers: true,    matchBrackets: true,    mode: \"${mode}\",    keyMap: \"${keymap}\"  });editor.setSize(\"100%\", \"auto\");</script></body></html>".replace("${other_lang}", this.otherLang).replace("${basepath}", current.toAbsolutePath().toString()).replace("${mode}", this.mode).replace("${keymap}", this.keymap).replace("${code}", this.editingCode);
    }

    public void setKeyMap(String keymap) {
        this.keymap = keymap;
        this.webview.getEngine().executeScript("editor.setOption('keyMap', '${keymap}')".replace("${keymap}", keymap));
    }

    public String getKeyMap() {
        return this.keymap;
    }

    public void setCode(String newCode, String language) {
        this.editingCode = newCode;
        this.translateMode(language);
        this.webview.getEngine().loadContent(this.applyEditingTemplate());
    }

    public void setCode(String newCode) {
        this.editingCode = newCode;
        this.webview.getEngine().loadContent(this.applyEditingTemplate());
    }

    public String getCodeAndSnapshot() {
        this.editingCode = (String)this.webview.getEngine().executeScript("editor.getValue();");
        return this.editingCode;
    }

    public void revertEdits() {
        this.setCode(this.editingCode);
    }

    public CodeEditor() {
        this.webview.getEngine().loadContent(this.applyEditingTemplate());
        this.setCenter((Node)this.webview);
    }

    public void setLanguage(String lang) {
        this.editingCode = (String)this.webview.getEngine().executeScript("editor.getValue();");
        this.translateMode(lang);
        this.webview.getEngine().loadContent(this.applyEditingTemplate());
    }

    public void translateMode(String lang) {
        if (lang == null) {
            return;
        }
        this.otherLang = "";
        switch (lang.toLowerCase()) {
            case "java": {
                this.mode = "text/x-java";
                break;
            }
            case "c": {
                this.mode = "text/x-csrc";
                break;
            }
            case "c++": {
                this.mode = "text/x-c++src";
                break;
            }
            case "c#": {
                this.mode = "text/x-csharp";
                break;
            }
            case "objective-c": {
                this.mode = "text/x-objectivec";
                break;
            }
            case "html": {
                this.mode = "text/html";
                this.otherLang = "  <script src=\"file:///${basepath}/static/codemirror/mode/xml/xml.js\"></script>  <script src=\"file:///${basepath}/static/codemirror/mode/css/css.js\"></script>  <script src=\"file:///${basepath}/static/codemirror/mode/htmlmixed/htmlmixed.js\"></script>";
                break;
            }
            case "python": {
                this.mode = "text/x-python";
                this.otherLang = "  <script src=\"file:///${basepath}/static/codemirror/mode/python/python.js\"></script>";
                break;
            }
            case "perl": {
                this.mode = "text/x-perl";
                this.otherLang = "  <script src=\"file:///${basepath}/static/codemirror/mode/perl/perl.js\"></script>";
                break;
            }
            case "php": {
                this.mode = "text/x-php";
                this.otherLang = "  <script src=\"file:///${basepath}/static/codemirror/mode/php/php.js\"></script>";
                break;
            }
            case "ruby": {
                this.mode = "text/x-ruby";
                this.otherLang = "  <script src=\"file:///${basepath}/static/codemirror/mode/ruby/ruby.js\"></script>";
                break;
            }
            case "xml": {
                this.mode = "application/xml";
                this.otherLang = "  <script src=\"file:///${basepath}/static/codemirror/mode/xml/xml.js\"></script>";
                break;
            }
            case "javascript": {
                this.mode = "..";
                this.otherLang = "<script src=\"file:///${basepath}/static/codemirror/mode/javascript/javascript.js\"></script>";
                break;
            }
            case "shell": {
                this.mode = "text/x-sh";
                this.otherLang = "<script src=\"file:///${basepath}/static/codemirror/mode/shell/shell.js\"></script>";
                break;
            }
            case "rst": {
                this.mode = "text/x-rst";
                this.otherLang = "<script src=\"file:///${basepath}/static/codemirror/mode/rst/rst.js\"></script>";
                break;
            }
            case "groovy": {
                this.mode = "text/x-groovy";
                this.otherLang = "<script src=\"file:///${basepath}/static/codemirror/mode/groovy/groovy.js\"></script>";
                break;
            }
            case "sql": {
                this.mode = "text/x-sql";
                this.otherLang = "<script src=\"file:///${basepath}/static/codemirror/mode/sql/sql.js\"></script>";
                break;
            }
            case "common-lisp": {
                this.mode = "text/x-common-lisp";
                this.otherLang = "<script src=\"file:///${basepath}/static/codemirror/mode/commonlisp/commonlisp.js\"></script>";
                break;
            }
            case "scheme": {
                this.mode = "text/x-rst";
                this.otherLang = "<script src=\"file:///${basepath}/static/codemirror/mode/scheme/scheme.js\"></script>";
                break;
            }
            case "django": {
                this.mode = "text/x-django";
                this.otherLang = "  <script src=\"file:///${basepath}/static/codemirror/mode/xml/xml.js\"></script>  <script src=\"file:///${basepath}/static/codemirror/mode/htmlmixed/htmlmixed.js\"></script>  <script src=\"file:///${basepath}/static/codemirror/mode/django/django.js\"></script>";
            }
        }
    }
}

