/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.code;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.logic.mydoc.tag.TagManager;
import myencyclopedia.model.mydoc.Snippet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnippetEditorRenderer
extends AbstractEditorRenderer {
    protected ListView<Snippet> list = new ListView();
    protected Button btn;
    final int ROW_HEIGHT = 24;
    protected BorderPane pane;
    protected GUIListener listener;
    public static final String EVENT_SELECTED = "snippet_selected";
    public static final String EVENT_ITEM_ADDED = "snippet_added";
    public static final String EVENT_ITEM_REMOVED = "snippet_removed";
    private static final Logger logger = LoggerFactory.getLogger(SnippetEditorRenderer.class);

    public SnippetEditorRenderer(final GUIListener listener) {
        this.listener = listener;
        this.pane = new BorderPane();
        this.btn = new Button(MydocMain.rb.getString("SnippetEditorRenderer.New"));
        this.btn.setOnAction(e -> {
            Snippet newSnippet = new Snippet();
            newSnippet.setPath("untitled.java");
            newSnippet.getRelation("tags").setTarget((Object)TagManager.TAG_JAVA);
            this.list.getItems().add((Object)newSnippet);
            this.commit(this.list.getItems());
            listener.dispatch(new GUIEvent((Object)this, EVENT_ITEM_ADDED, (Object)newSnippet));
        });
        this.list.setPrefHeight(74.0);
        this.list.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    Snippet obj = (Snippet)SnippetEditorRenderer.this.list.getSelectionModel().getSelectedItem();
                    SnippetEditorRenderer.this.list.getItems().remove((Object)obj);
                    listener.dispatch(new GUIEvent((Object)SnippetEditorRenderer.this, SnippetEditorRenderer.EVENT_ITEM_REMOVED, (Object)obj));
                }
            }
        });
        this.list.getSelectionModel().selectedItemProperty().addListener(new ChangeListener(){

            public void changed(ObservableValue observable, Object oldValue, Object newValue) {
                Snippet obj = (Snippet)newValue;
                listener.dispatch(new GUIEvent((Object)SnippetEditorRenderer.this, SnippetEditorRenderer.EVENT_SELECTED, (Object)obj));
            }
        });
        this.pane.setCenter(this.list);
        this.pane.setBottom((Node)this.btn);
    }

    public Snippet getSelected() {
        return (Snippet)this.list.getSelectionModel().getSelectedItem();
    }

    public Region getComponent() {
        return this.pane;
    }

    public void loadObject(Object obj) {
        this.list.getItems().clear();
        if (obj == null) {
            return;
        }
        if (obj instanceof Snippet[]) {
            Snippet[] lst;
            for (Snippet element : lst = (Snippet[])obj) {
                this.list.getItems().add((Object)element);
            }
        }
    }

    public boolean forceCommit() {
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

