/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.doc;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.LaunchUtils;
import myencyclopedia.common.gui.entity.EntityValidator;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.common.gui.progress.SimpleProgressStage;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.gui.mydoc.TagGUIController;
import myencyclopedia.gui.mydoc.doc.DocEntityValidator;
import myencyclopedia.gui.mydoc.doc.DocSpecBuilder;
import myencyclopedia.logic.mydoc.DocManager;
import myencyclopedia.model.Entity;
import myencyclopedia.model.mydoc.Doc;
import myencyclopedia.search.mydoc.FullTextClassBridge;
import myencyclopedia.search.mydoc.parser.IndexingReporter;

public class DocNewStage
extends Stage
implements TagGUIController {
    private EntityView docProp;
    private Doc doc;
    private Button btnSave;
    private Button btnCancel;
    private Button btnChoose;
    private Button btnOpen;
    private Button btnOpenFolder;
    private ListView<String> fileList;
    private List<File> docFiles;
    private DocManager docManager;

    public DocNewStage(Stage owner) {
        this.getIcons().add((Object)ImageFactory.IMG_STAGE_DOC);
        this.docManager = DocManager.getInstance();
        this.docProp = new EntityView();
        DocSpecBuilder.buildDocNewSpec(this.docProp);
        this.docProp.setEntityValidator((EntityValidator)new DocEntityValidator());
        this.docProp.setCollapsible(false);
        this.btnOpen = new Button(MydocMain.rb.getString("OPEN"));
        this.btnOpen.setOnAction(e -> LaunchUtils.openFileWithDefaultApp((Path)this.docFiles.get(0).toPath()));
        this.btnOpenFolder = new Button(MydocMain.rb.getString("OPEN_FOLDER"));
        this.btnOpenFolder.setOnAction(e -> LaunchUtils.exploreFolderAndSelectFile((String)this.docFiles.get(0).getAbsolutePath()));
        this.btnSave = new Button(MydocMain.rb.getString("SAVE"));
        this.btnSave.setOnAction(e -> this.save());
        this.btnCancel = new Button(MydocMain.rb.getString("CANCEL"));
        this.btnCancel.setOnAction(e -> this.hide());
        this.btnChoose = new Button(MydocMain.rb.getString("CHOOSE"));
        this.btnChoose.setOnAction(e -> {
            FileChooser fileChooser = new FileChooser();
            File file = fileChooser.showOpenDialog((Window)this);
            if (file == null) {
                return;
            }
            this.fileList.getItems().add((Object)file.toString());
            this.docFiles.add(file);
        });
        VBox vbox = new VBox();
        this.fileList = new ListView();
        this.fileList.setMaxHeight(100.0);
        FlowPane btnFlowPane = new FlowPane();
        btnFlowPane.getChildren().addAll((Object[])new Node[]{this.btnChoose, this.btnOpen, this.btnOpenFolder});
        vbox.getChildren().addAll((Object[])new Node[]{this.fileList, btnFlowPane});
        FlowPane controlFlowPane = new FlowPane();
        controlFlowPane.getChildren().add((Object)this.btnSave);
        controlFlowPane.getChildren().add((Object)this.btnCancel);
        BorderPane border = new BorderPane();
        border.setTop((Node)vbox);
        ScrollPane sp = new ScrollPane();
        sp.setFitToWidth(true);
        sp.setContent((Node)this.docProp);
        border.setCenter((Node)sp);
        border.setBottom((Node)controlFlowPane);
        Scene scene = new Scene((Parent)border, 550.0, 400.0);
        this.setScene(scene);
        this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                MydocMain.getInstance().releaseEntity((Entity)DocNewStage.this.doc);
            }
        });
    }

    public void setDoc(Doc doc, File file) {
        this.doc = doc;
        this.docProp.setEntity((Entity)doc);
        this.fileList.getItems().clear();
        this.fileList.getItems().add((Object)file.toString());
        this.docFiles = new ArrayList<File>();
        this.docFiles.add(file);
        this.setTitle(String.format(MydocMain.rb.getString("NEW_DOC_TITLE"), file.toString()));
    }

    public void save() {
        if (!this.docProp.validateEntity()) {
            return;
        }
        final SimpleProgressStage progressStage = new SimpleProgressStage((Stage)this, null);
        final IndexingReporter reporter = new IndexingReporter(){

            public void progress(final int current, final int total) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        progressStage.updateProgress(String.format(MydocMain.rb.getString("PROGRESS_PAGE"), current, total), (double)current / (double)total);
                    }
                });
            }
        };
        Task task = new Task(){

            protected Boolean call() throws Exception {
                FullTextClassBridge.reporter = reporter;
                DocNewStage.this.docManager.firstSave(DocNewStage.this.doc, DocNewStage.this.docFiles);
                return true;
            }
        };
        task.setOnSucceeded((EventHandler)new EventHandler<WorkerStateEvent>(){

            public void handle(WorkerStateEvent t) {
                progressStage.hide();
                DocNewStage.this.hide();
            }
        });
        new Thread((Runnable)task).start();
    }

    public boolean getSaved() {
        return this.doc.getId() != null;
    }

    @Override
    public void makeInvalid() {
        this.fileList.setDisable(true);
        this.btnSave.setDisable(true);
    }
}

