/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.ebook;

import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.TemplateStage;
import myencyclopedia.common.gui.entity.EntityList;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.gui.mydoc.ebook.AuthorEditorRenderer;
import myencyclopedia.gui.mydoc.ebook.EbookBulletin;
import myencyclopedia.model.ebook.Author;
import myencyclopedia.model.ebook.AuthorI18N;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorSelectionStage
extends TemplateStage
implements GUIListener {
    private static final Logger logger = LoggerFactory.getLogger(AuthorSelectionStage.class);
    private TextField inputFname;
    private TextField inputLname;
    private EntityList candidates;
    private EbookBulletin ebookList;
    private Session s;

    public AuthorSelectionStage(Session s) {
        this.initModality(Modality.APPLICATION_MODAL);
        this.s = s;
        this.getIcons().add((Object)ImageFactory.IMG_STAGE_AUTHOR);
        this.setTitle(MydocMain.rb.getString("EBOOK_AUTHOR_SELECT"));
        this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
            }
        });
        VBox boxLeft = new VBox();
        HBox boxPerson = new HBox();
        this.inputLname = new TextField();
        this.inputFname = new TextField();
        this.inputLname.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                event.getCode();
                if (keyCode.equals((Object)KeyCode.ENTER)) {
                    AuthorSelectionStage.this.search(true);
                }
            }
        });
        this.inputFname.setOnKeyReleased((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                event.getCode();
                if (keyCode.equals((Object)KeyCode.ENTER)) {
                    AuthorSelectionStage.this.search(true);
                }
            }
        });
        boxPerson.getChildren().addAll((Object[])new Node[]{this.inputFname, this.inputLname});
        this.ebookList = new EbookBulletin(this);
        this.candidates = new EntityList((GUIListener)this);
        VBox.setVgrow((Node)this.candidates, (Priority)Priority.ALWAYS);
        Label lblFullName = new Label(MydocMain.rb.getString("EBOOK_AUTHOR_NAME_FORMAT"));
        lblFullName.setPadding(new Insets(4.0, 0.0, 4.0, 4.0));
        Label lblResult = new Label(MydocMain.rb.getString("EBOOK_AUTHOR_SEARCH_RESULT"));
        lblResult.setPadding(new Insets(4.0, 0.0, 4.0, 4.0));
        boxLeft.getChildren().addAll((Object[])new Node[]{lblFullName, boxPerson, lblResult, this.candidates});
        SplitPane splitPane = new SplitPane();
        splitPane.setOrientation(Orientation.HORIZONTAL);
        SplitPane.setResizableWithParent((Node)boxLeft, (Boolean)Boolean.FALSE);
        splitPane.getItems().addAll((Object[])new Node[]{boxLeft, this.ebookList});
        this.bp.setCenter((Node)splitPane);
    }

    private void search(boolean isPerson) {
        List<Author> authors;
        if (isPerson && this.inputFname.getText().trim().isEmpty()) {
            return;
        }
        AuthorI18N authorI18n = new AuthorI18N();
        if (isPerson) {
            authorI18n.setFirstName(this.inputFname.getText());
            if (!this.inputLname.getText().trim().isEmpty()) {
                authorI18n.setLastName(this.inputLname.getText());
            }
        }
        if ((authors = AuthorEditorRenderer.searchAuthor(authorI18n, this.s)) != null && !authors.isEmpty()) {
            this.candidates.itemsReset();
            this.candidates.itemsAdd(authors);
        }
    }

    public Object dispatch(GUIEvent e) {
        if ("EntityList_selected".equals(e.getEventName())) {
            Author author = (Author)e.getValue();
            if (author == null) {
                return null;
            }
            String query = "Select d from Ebook as d join d.authors as r join r.targetEntity as ebookauthor join ebookauthor.relAuthor as p join p.targetEntity as t where t=" + author.getId();
            List result = this.s.createQuery(query).list();
            this.ebookList.setEbookList(result);
        }
        return null;
    }

    protected Object prepareResult() {
        return this.candidates.getSelectedEntity();
    }
}

