/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.ebook;

import java.io.Serializable;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.entity.EntityValidator;
import myencyclopedia.common.gui.entity.Spec;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.common.utils.Tuple;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.gui.mydoc.ebook.AuthorEditorRenderer;
import myencyclopedia.gui.mydoc.ebook.EbookBulletin;
import myencyclopedia.gui.mydoc.ebook.EbookEntityValidator;
import myencyclopedia.gui.mydoc.ebook.EbookSpecBuilder;
import myencyclopedia.model.Entity;
import myencyclopedia.model.ebook.Ebook;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EbookEditingStage
extends Stage
implements GUIListener {
    private Button btnSave;
    private Button btnCancel;
    private EntityView entityView;
    private Ebook ebook;
    private EntityValidator validator;
    private List<Ebook> existingEbooks;
    private EbookBulletin ebookBulletin;
    private static final Logger logger = LoggerFactory.getLogger(EbookEditingStage.class);
    private Session s;
    private Spec specEbook;
    private AuthorEditorRenderer authorComp;

    public EbookEditingStage(Stage owner, Session s) {
        this.s = s;
        this.getIcons().add((Object)ImageFactory.IMG_STAGE_BOOK);
        this.entityView = new EntityView();
        this.entityView.setGUIListener((GUIListener)this);
        this.entityView.setCollapsible(false);
        Tuple<Spec, AuthorEditorRenderer> ret = EbookSpecBuilder.buildEbookEditingSpecs(this.entityView, s);
        this.specEbook = (Spec)ret.x;
        this.authorComp = (AuthorEditorRenderer)((Object)ret.y);
        this.validator = new EbookEntityValidator();
        this.entityView.setEntityValidator(this.validator);
        this.entityView.setGUIListener((GUIListener)this);
        this.ebookBulletin = new EbookBulletin(this);
        this.btnSave = new Button(MydocMain.rb.getString("SAVE"));
        this.btnSave.setOnAction(e -> {
            if (!this.entityView.validateEntity()) {
                return;
            }
            this.save();
            this.hide();
        });
        this.btnCancel = new Button(MydocMain.rb.getString("CLOSE"));
        this.btnCancel.setOnAction(e -> this.hide());
        this.setOnHidden((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent event) {
                EbookEditingStage.this.cleanUp();
            }
        });
        FlowPane controlFlowPane = new FlowPane();
        controlFlowPane.getChildren().add((Object)this.btnSave);
        controlFlowPane.getChildren().add((Object)this.btnCancel);
        BorderPane border = new BorderPane();
        ScrollPane sp = new ScrollPane((Node)this.entityView);
        sp.setFitToWidth(true);
        border.setCenter((Node)sp);
        border.setBottom((Node)controlFlowPane);
        Scene scene = new Scene((Parent)border, 600.0, 700.0);
        this.setScene(scene);
    }

    public void setEbook(Long id) {
        try {
            this.ebook = (Ebook)this.s.get(Ebook.class, (Serializable)id);
            this.setTitle(this.ebook.toString());
            this.entityView.setEntity((Entity)this.ebook);
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }

    private void cleanUp() {
        this.s.close();
        MydocMain.getInstance().releaseEntity((Entity)this.ebook);
    }

    public Ebook getEbook() {
        return this.ebook;
    }

    private boolean save() {
        this.s.beginTransaction();
        try {
            this.s.update((Object)this.ebook);
            this.s.getTransaction().commit();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        return false;
    }

    public Object dispatch(GUIEvent e) {
        return null;
    }
}

