/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.ebook;

import myencyclopedia.common.gui.entity.Spec;
import myencyclopedia.common.gui.entity.SpecElement;
import myencyclopedia.common.gui.entity.converter.ByteConverter;
import myencyclopedia.common.gui.entity.converter.IntegerConverter;
import myencyclopedia.common.gui.entity.view.AbstractEditorRenderer;
import myencyclopedia.common.gui.entity.view.Editor;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.common.gui.entity.view.Renderer;
import myencyclopedia.common.gui.entity.view.predefined.DefaultMultiValueStage;
import myencyclopedia.common.gui.entity.view.predefined.EnumComboBox;
import myencyclopedia.common.utils.Tuple;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.gui.mydoc.TagStage;
import myencyclopedia.gui.mydoc.TagsRenderer;
import myencyclopedia.gui.mydoc.ebook.AuthorConverter;
import myencyclopedia.gui.mydoc.ebook.AuthorEditorRenderer;
import myencyclopedia.gui.mydoc.ebook.FilesListRenderer;
import myencyclopedia.gui.mydoc.ebook.ISBNConverter;
import myencyclopedia.gui.mydoc.ebook.TitleConverter;
import myencyclopedia.gui.mydoc.ebook.TitleListViewEditorRenderer;
import myencyclopedia.hibernate.common.ParentChildrenManager;
import myencyclopedia.hibernate.crud.QueryUtil;
import myencyclopedia.logic.ebook.EbookTagManager;
import myencyclopedia.logic.mydoc.tag.TagManager;
import myencyclopedia.model.common.StringConverter;
import myencyclopedia.model.common.YearMonthDayConverter;
import myencyclopedia.model.ebook.Discipline;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.ebook.EbookFileInfo;
import myencyclopedia.model.ebook.Publisher;
import org.hibernate.Session;

public class EbookSpecBuilder {
    public static Tuple<Spec, AuthorEditorRenderer> buildEbookNewSpecs(EntityView view, Session s) {
        Spec specEbook = new Spec(Ebook.class);
        specEbook.setDisplayName(MydocMain.rb.getString("SPEC_BOOK"));
        YearMonthDayConverter ymdConverter = new YearMonthDayConverter();
        IntegerConverter intConverter = IntegerConverter.getConverter((boolean)true);
        ByteConverter byteConverter = ByteConverter.getConverter((boolean)true);
        DefaultMultiValueStage publisherEditor = new DefaultMultiValueStage(MydocMain.rb.getString("EBOOK_SELECT_PUBLISHERS"));
        publisherEditor.getIcons().add((Object)ImageFactory.IMG_STAGE_PUBLISHER);
        publisherEditor.populateItems(QueryUtil.loadAll((Session)s, Publisher.class));
        TagStage catTagStage = new TagStage((ParentChildrenManager)EbookTagManager.getInstance(), TagManager.getPredefinedLocalizedName((String)"ROOT_EBOOK"));
        AuthorEditorRenderer authorEditorRenderer = new AuthorEditorRenderer(s);
        specEbook.setEmdeded(new SpecElement[]{specEbook.get("titlei18n").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_TITLE")).setModifiable(), specEbook.get("tags").setDisplayName(MydocMain.rb.getString("SPEC_TAGS")).setModifiable(), specEbook.get("discipline").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_DISCIPLINE")).setModifiable(), specEbook.get("authors").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_AUTHORS")).setModifiable(), specEbook.get("edition").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_EDITION")).setModifiable(), specEbook.get("isbn").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_ISBN")).setModifiable(), specEbook.get("pages").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_PAGES")).setModifiable(), specEbook.get("published_date").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_PUB_DATE")).setModifiable(), specEbook.get("is_translated").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_IS_TRANSLATED")).setModifiable(), specEbook.get("publishers").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_PUBLISHERS")).setModifiable(), specEbook.get("is_hidden").setDisplayName(MydocMain.rb.getString("SPEC_HIDDEN")).setModifiable()});
        specEbook.addStandalone(specEbook.get("tags"));
        specEbook.addStandalone(specEbook.get("file_info").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_FILES")).setDislayChildren());
        specEbook.setStringFactory(specEbook.get("published_date"), (StringConverter)ymdConverter).setStringFactory(specEbook.get("edition"), (StringConverter)byteConverter).setStringFactory(specEbook.get("pages"), (StringConverter)intConverter).setStringFactory(specEbook.get("titlei18n"), (StringConverter)new TitleConverter()).setStringFactory(specEbook.get("isbn"), (StringConverter)new ISBNConverter()).setStringFactory(specEbook.get("authors"), (StringConverter)new AuthorConverter());
        view.addSpec(new Spec[]{specEbook});
        view.setEditorRenderer(specEbook.get("discipline"), (AbstractEditorRenderer)new EnumComboBox(Discipline.class)).setEditorRenderer(specEbook.get("titlei18n"), (AbstractEditorRenderer)new TitleListViewEditorRenderer()).setEditorRenderer(specEbook.get("authors"), (AbstractEditorRenderer)authorEditorRenderer).setEditor(specEbook.get("tags"), (Editor)catTagStage).setEditor(specEbook.get("publishers"), (Editor)publisherEditor);
        Spec specFileInfo = new Spec(EbookFileInfo.class);
        specFileInfo.setDisplayName(MydocMain.rb.getString("SPEC_BOOK_FILE"));
        specFileInfo.setEmdeded(new SpecElement[]{specFileInfo.get("comment").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_FILE_COMMENT")).setModifiable(), specFileInfo.get("name").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_FILE_NAME")), specFileInfo.get("relative_path").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_FILE_PATH")), specFileInfo.get("hash_md5").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_FILE_MD5"))});
        view.addSpec(new Spec[]{specFileInfo});
        return new Tuple((Object)specEbook, (Object)authorEditorRenderer);
    }

    public static Tuple<Spec, AuthorEditorRenderer> buildEbookEditingSpecs(EntityView view, Session s) {
        Spec specEbook = new Spec(Ebook.class);
        specEbook.setDisplayName(MydocMain.rb.getString("SPEC_BOOK"));
        YearMonthDayConverter ymdConverter = new YearMonthDayConverter();
        IntegerConverter intConverter = IntegerConverter.getConverter((boolean)true);
        ByteConverter byteConverter = ByteConverter.getConverter((boolean)true);
        DefaultMultiValueStage publisherEditor = new DefaultMultiValueStage(MydocMain.rb.getString("EBOOK_SELECT_PUBLISHERS"));
        publisherEditor.populateItems(QueryUtil.loadAll((Session)s, Publisher.class));
        TagStage catTagStage = new TagStage((ParentChildrenManager)EbookTagManager.getInstance(), TagManager.getPredefinedLocalizedName((String)"ROOT_EBOOK"));
        AuthorEditorRenderer authorEditorRenderer = new AuthorEditorRenderer(s);
        specEbook.setEmdeded(new SpecElement[]{specEbook.get("titlei18n").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_TITLE")), specEbook.get("tags").setDisplayName(MydocMain.rb.getString("SPEC_TAGS")).setModifiable(), specEbook.get("discipline").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_DISCIPLINE")).setModifiable(), specEbook.get("authors").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_AUTHORS")), specEbook.get("edition").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_EDITION")).setModifiable(), specEbook.get("isbn").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_ISBN")).setModifiable(), specEbook.get("pages").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_PAGES")).setModifiable(), specEbook.get("published_date").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_PUB_DATE")).setModifiable(), specEbook.get("is_translated").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_IS_TRANSLATED")).setModifiable(), specEbook.get("publishers").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_PUBLISHERS")).setModifiable(), specEbook.get("is_hidden").setDisplayName(MydocMain.rb.getString("SPEC_HIDDEN")).setModifiable(), specEbook.get("file_info").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_FILES"))});
        specEbook.setStringFactory(specEbook.get("published_date"), (StringConverter)ymdConverter).setStringFactory(specEbook.get("edition"), (StringConverter)byteConverter).setStringFactory(specEbook.get("pages"), (StringConverter)intConverter).setStringFactory(specEbook.get("titlei18n"), (StringConverter)new TitleConverter()).setStringFactory(specEbook.get("isbn"), (StringConverter)new ISBNConverter()).setStringFactory(specEbook.get("authors"), (StringConverter)new AuthorConverter());
        view.addSpec(new Spec[]{specEbook});
        view.setEditorRenderer(specEbook.get("discipline"), (AbstractEditorRenderer)new EnumComboBox(Discipline.class)).setRenderer(specEbook.get("tags"), (Renderer)new TagsRenderer(false)).setEditor(specEbook.get("tags"), (Editor)catTagStage).setEditor(specEbook.get("publishers"), (Editor)publisherEditor).setRenderer(specEbook.get("file_info"), (Renderer)new FilesListRenderer());
        return new Tuple((Object)specEbook, (Object)authorEditorRenderer);
    }

    public static void buildEbookSpec(EntityView view) {
        Spec specEbook = new Spec(Ebook.class);
        specEbook.setDisplayName(MydocMain.rb.getString("SPEC_BOOK"));
        YearMonthDayConverter ymdConverter = new YearMonthDayConverter();
        IntegerConverter intConverter = IntegerConverter.getConverter((boolean)true);
        ByteConverter byteConverter = ByteConverter.getConverter((boolean)true);
        specEbook.setEmdeded(new SpecElement[]{specEbook.get("titlei18n").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_TITLE")), specEbook.get("discipline").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_DISCIPLINE")), specEbook.get("tags").setDisplayName(MydocMain.rb.getString("SPEC_TAGS")), specEbook.get("authors").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_AUTHORS")), specEbook.get("edition").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_EDITION")), specEbook.get("isbn").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_ISBN")), specEbook.get("published_date").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_PUB_DATE")), specEbook.get("is_translated").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_IS_TRANSLATED")), specEbook.get("publishers").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_PUBLISHERS")), specEbook.get("file_info").setDisplayName(MydocMain.rb.getString("SPEC_BOOK_FILES"))});
        specEbook.setStringFactory(specEbook.get("published_date"), (StringConverter)ymdConverter).setStringFactory(specEbook.get("edition"), (StringConverter)byteConverter).setStringFactory(specEbook.get("pages"), (StringConverter)intConverter).setStringFactory(specEbook.get("titlei18n"), (StringConverter)new TitleConverter()).setStringFactory(specEbook.get("isbn"), (StringConverter)new ISBNConverter()).setStringFactory(specEbook.get("authors"), (StringConverter)new AuthorConverter());
        view.addSpec(new Spec[]{specEbook});
        view.setEditorRenderer(specEbook.get("discipline"), (AbstractEditorRenderer)new EnumComboBox(Discipline.class)).setRenderer(specEbook.get("tags"), (Renderer)new TagsRenderer(true)).setRenderer(specEbook.get("file_info"), (Renderer)new FilesListRenderer());
    }
}

