/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.mydoc.note;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.web.HTMLEditor;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.common.gui.LaunchUtils;
import myencyclopedia.common.gui.entity.EntityValidator;
import myencyclopedia.common.gui.entity.view.EntityView;
import myencyclopedia.gui.mydoc.ImageFactory;
import myencyclopedia.gui.mydoc.MydocMain;
import myencyclopedia.gui.mydoc.QueryInput;
import myencyclopedia.gui.mydoc.code.CodeEditor;
import myencyclopedia.gui.mydoc.note.ContentParser;
import myencyclopedia.gui.mydoc.note.NoteEntityValidator;
import myencyclopedia.gui.mydoc.note.NoteSpecBuilder;
import myencyclopedia.gui.mydoc.note.SuggestionPopup;
import myencyclopedia.logic.mydoc.NoteManager;
import myencyclopedia.model.Entity;
import myencyclopedia.model.mydoc.Note;
import netscape.javascript.JSObject;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoteHtmlEditorStage
extends Stage {
    private Button btnSave;
    private Button btnCancel;
    private Note note;
    private EntityView noteProp;
    private SplitPane spLeftRight;
    private BorderPane borderPane;
    private HBox controlPane;
    private ScrollPane spProp;
    private BorderPane mainPane;
    private SuggestionPopup popup;
    private QueryInput queryInput;
    private Scene scene;
    private CheckBox chkRenderMath;
    private CheckBox chkRenderCode;
    private int DEFAULT_FONT_SIZE = 12;
    private int fontSize = -1;
    private boolean isNew;
    private boolean isNewSaved;
    private final HTMLEditor htmlEditor;
    private WebEngine webEngine;
    private WebView webView;
    private CodeEditor codeEditor;
    private boolean isPropShown;
    private boolean isSrcShown;
    private boolean isToolbarShown;
    private boolean isMathEnabled = false;
    private boolean isCodeRenderEnabled = false;
    private static final Logger logger = LoggerFactory.getLogger(NoteHtmlEditorStage.class);
    private SessionFactory sf;
    private String templateHead;
    private String templateBody;
    private String jsMathJax = "<script type=\"text/javascript\" src=\"file:///${basepath}/static/MathJax-2.5.3/MathJax.js?config=AM_HTMLorMML\"></script>";
    private String jsCodeHighlight = "<link rel=\"stylesheet\" href=\"file:///${basepath}/static/highlight-8.6/styles/default.css\">  <script src=\"file:///${basepath}/static/highlight-8.6/highlight.pack.js\"></script><script>hljs.initHighlightingOnLoad();</script>";
    private static final String headerCodeHighlight = "<link rel=\"stylesheet\" href=\"http://cdnjs.cloudflare.com/ajax/libs/highlight.js/8.6/styles/default.min.css\"><script src=\"http://cdnjs.cloudflare.com/ajax/libs/highlight.js/8.6/highlight.min.js\"></script><script>hljs.initHighlightingOnLoad();</script>";
    private static final String headerMathJax = "<script src='https://cdn.mathjax.org/mathjax/latest/MathJax.js?config=AM_HTMLorMML'></script>";
    private static final String headerMydocCSS = "<style type=\"text/css\"> mydoc{border:1px solid #ccc; background-color:#efefef; color:#00a;}mydoc.doc {background-color: #b1f0a5;}mydoc.note {background-color: #d6ddea;}mydoc.ebook {background-color: #fff7dd;}mydoc.code {background-color: #F5A9BC;}</style> ";

    private void hideQueryPopup() {
        this.popup.hide();
        this.queryInput.hideList();
    }

    public NoteHtmlEditorStage(SessionFactory sf) {
        this.sf = sf;
        this.getIcons().add((Object)ImageFactory.IMG_STAGE_NOTE);
        this.queryInput = new QueryInput(new GUIListener(){

            public Object dispatch(GUIEvent e) {
                switch (e.getEventName()) {
                    case "QueryInput_hide": {
                        NoteHtmlEditorStage.this.hideQueryPopup();
                        break;
                    }
                    case "QueryInput_double": 
                    case "QueryInput_default_control": {
                        Entity entity = (Entity)e.getValue();
                        NoteHtmlEditorStage.this.insertRef(entity.getClass().getSimpleName().toLowerCase(), "#" + entity.getId(), entity.toString());
                        NoteHtmlEditorStage.this.hideQueryPopup();
                    }
                }
                return null;
            }
        });
        this.queryInput.setOwnerStage(this);
        this.popup = new SuggestionPopup(this.queryInput);
        this.btnSave = new Button(MydocMain.rb.getString("SAVE"));
        this.btnSave.setOnAction(e -> this.save());
        this.btnCancel = new Button(MydocMain.rb.getString("CANCEL"));
        this.btnCancel.setOnAction(e -> this.cancel());
        this.noteProp = new EntityView();
        this.noteProp.setCollapsible(false);
        this.noteProp.setEntityValidator((EntityValidator)new NoteEntityValidator());
        NoteSpecBuilder.buildNoteNewSpec(this.noteProp);
        this.htmlEditor = new HTMLEditor();
        WebView htmlEditorWebView = (WebView)this.htmlEditor.lookup("WebView");
        GridPane.setHgrow((Node)htmlEditorWebView, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)htmlEditorWebView, (Priority)Priority.ALWAYS);
        this.webEngine = htmlEditorWebView.getEngine();
        this.webEngine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> ov, Worker.State oldState, Worker.State newState) {
                if (newState == Worker.State.SUCCEEDED) {
                    JSObject win = (JSObject)NoteHtmlEditorStage.this.webEngine.executeScript("window");
                    win.setMember("app", new JavaCallback());
                }
            }
        });
        this.templateHead = "<html dir=\"ltr\"><head><meta http-equiv=\"content-type\" content=\"text/html; charset=utf-8\" />${fontsize}<script src=\"file:///${basepath}/static/jquery-1.8.2/jquery.min.js\"></script><script type=\"text/javascript\">function insertLinkAtCursor(url) {  if (window.getSelection) {    var sel = window.getSelection();    if (sel.getRangeAt && sel.rangeCount) {      range = sel.getRangeAt(0);      var newlink = document.createElement(\"a\");      range.surroundContents(newlink);      newlink.setAttribute('href', url);    }  }}</script><script type=\"text/javascript\">function insertImageAtCursor(url) {  if (window.getSelection) {    var sel = window.getSelection();    if (sel.getRangeAt && sel.rangeCount) {      range = sel.getRangeAt(0);      var newImg = document.createElement(\"img\");      range.surroundContents(newImg);      newImg.setAttribute('src', url);    }  }}</script><script type=\"text/javascript\">function insertRefAtCursor(subtype, url, text) {  if (window.getSelection) {    var sel = window.getSelection();    if (sel.getRangeAt && sel.rangeCount) {      range = sel.getRangeAt(0);      var newRef = document.createElement(\"mydoc\");      range.surroundContents(newRef);      newRef.setAttribute('class', subtype);      newRef.setAttribute('url', url);      newRef.innerHTML=text;    }  }}</script><script type=\"text/javascript\">function insertCodeAtCursor() {  if (window.getSelection) {    var sel = window.getSelection();    var text = sel.toString();    if (sel.getRangeAt && sel.rangeCount) {      range = sel.getRangeAt(0);      var newCode = document.createElement(\"code\");      var newPre = document.createElement(\"pre\");      range.deleteContents();      range.insertNode(newPre);      newPre.appendChild(newCode);      var t = document.createTextNode(text);      newCode.appendChild(t);    }  }}</script><script>    $(function(){        $(\"a\").click(function(){            var $this = $(this);            app.browse($this.attr('href'));            return false;        });        $(\"mydoc\").click(function () {             var $this = $(this);             app.launch($this.attr('url'));             return false;        });    });</script><style type=\"text/css\"> mydoc{border:1px solid #ccc; background-color:#efefef; color:#00a;}mydoc.doc {background-color: #b1f0a5;}mydoc.note {background-color: #d6ddea;}mydoc.ebook {background-color: #fff7dd;}mydoc.code {background-color: #F5A9BC;}</style> ";
        this.templateBody = "</head><body contenteditable=\"$$truefalse$$\">$$body$$</body></html>";
        this.htmlEditor.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent ke) {
                if (ke.getCode().equals((Object)KeyCode.ESCAPE)) {
                    NoteHtmlEditorStage.this.cancel();
                } else if (ke.getCode().equals((Object)KeyCode.S) && ke.isAltDown()) {
                    NoteHtmlEditorStage.this.save();
                    ke.consume();
                } else if (ke.getCode().equals((Object)KeyCode.F2)) {
                    NoteHtmlEditorStage.this.toggleFullMode();
                } else if (ke.getCode().equals((Object)KeyCode.F5)) {
                    NoteHtmlEditorStage.this.refreshAll();
                } else if (ke.getCode().equals((Object)KeyCode.F6)) {
                    Parent parent = NoteHtmlEditorStage.this.htmlEditor.getParent();
                    Bounds childBounds = NoteHtmlEditorStage.this.htmlEditor.getBoundsInParent();
                    Bounds parentBounds = parent.localToScene(parent.getBoundsInLocal());
                    double layoutX = childBounds.getMinX() + parentBounds.getMinX() + parent.getScene().getX() + parent.getScene().getWindow().getX();
                    double layoutY = parentBounds.getMinY() + parent.getScene().getY() + parent.getScene().getWindow().getY();
                    if (NoteHtmlEditorStage.this.isPropShown) {
                        layoutY += NoteHtmlEditorStage.this.noteProp.getBoundsInParent().getMaxY();
                    }
                    NoteHtmlEditorStage.this.popup.show((Window)NoteHtmlEditorStage.this, layoutX, layoutY);
                } else if (ke.getCode().equals((Object)KeyCode.F9)) {
                    if (NoteHtmlEditorStage.this.fontSize == -1) {
                        NoteHtmlEditorStage.this.fontSize = NoteHtmlEditorStage.this.DEFAULT_FONT_SIZE;
                    }
                    if (NoteHtmlEditorStage.this.fontSize - 2 > 0) {
                        NoteHtmlEditorStage.this.fontSize = NoteHtmlEditorStage.this.fontSize - 2;
                        NoteHtmlEditorStage.this.refreshAll();
                    }
                } else if (ke.getCode().equals((Object)KeyCode.F10)) {
                    if (NoteHtmlEditorStage.this.fontSize == -1) {
                        NoteHtmlEditorStage.this.fontSize = NoteHtmlEditorStage.this.DEFAULT_FONT_SIZE;
                    }
                    NoteHtmlEditorStage.this.fontSize = NoteHtmlEditorStage.this.fontSize + 2;
                    NoteHtmlEditorStage.this.refreshAll();
                }
            }
        });
        Node node = this.htmlEditor.lookup(".top-toolbar");
        if (node instanceof ToolBar) {
            ToolBar bar = (ToolBar)node;
            Button btnFull = new Button("", (Node)new ImageView(ImageFactory.IMG_NOTE_FULL));
            bar.getItems().add((Object)btnFull);
            btnFull.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NoteHtmlEditorStage.this.toggleFullMode();
                }
            });
            btnFull.setTooltip(new Tooltip("NOTE_EDITOR_STAGE_TOGGLE_MODE"));
            Button btnToggleProp = new Button("", (Node)new ImageView(ImageFactory.IMG_NOTE_PROP));
            bar.getItems().add((Object)btnToggleProp);
            btnToggleProp.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NoteHtmlEditorStage.this.setMode(!NoteHtmlEditorStage.this.isPropShown, NoteHtmlEditorStage.this.isToolbarShown, NoteHtmlEditorStage.this.isSrcShown);
                }
            });
            btnToggleProp.setTooltip(new Tooltip("NOTE_EDITOR_STAGE_TOGGLE_PROPERTY"));
            Button btnToggleSrc = new Button("", (Node)new ImageView(ImageFactory.IMG_NOTE_SRC));
            bar.getItems().add((Object)btnToggleSrc);
            btnToggleSrc.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NoteHtmlEditorStage.this.setMode(NoteHtmlEditorStage.this.isPropShown, NoteHtmlEditorStage.this.isToolbarShown, !NoteHtmlEditorStage.this.isSrcShown);
                    if (NoteHtmlEditorStage.this.isSrcShown) {
                        NoteHtmlEditorStage.this.reloadSource();
                    }
                }
            });
            btnToggleSrc.setTooltip(new Tooltip("NOTE_EDITOR_STAGE_TOGGLE_SOURCE"));
            bar.getItems().add((Object)new Separator());
            Button btnLink = new Button("", (Node)new ImageView(ImageFactory.IMG_NOTE_LINK));
            bar.getItems().add((Object)btnLink);
            btnLink.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    TextInputDialog d = new TextInputDialog("http://");
                    d.setTitle(MydocMain.rb.getString("NOTE_EDITOR_STAGE_URL_TITLE"));
                    d.setContentText(MydocMain.rb.getString("NOTE_EDITOR_STAGE_URL_CONTENT"));
                    Optional result = d.showAndWait();
                    if (result.isPresent()) {
                        String url = (String)result.get();
                        url = url.replace("'", "\\'");
                        NoteHtmlEditorStage.this.webEngine.executeScript("insertLinkAtCursor('" + url + "')");
                    }
                }
            });
            btnLink.setTooltip(new Tooltip(MydocMain.rb.getString("NOTE_EDITOR_STAGE_URL_TOOLTIP")));
            Button btnImage = new Button("", (Node)new ImageView(ImageFactory.IMG_NOTE_IMAGE));
            bar.getItems().add((Object)btnImage);
            btnImage.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    TextInputDialog d = new TextInputDialog("file:///");
                    d.setTitle(MydocMain.rb.getString("NOTE_EDITOR_STAGE_IMG_TITLE"));
                    d.setContentText(MydocMain.rb.getString("NOTE_EDITOR_STAGE_IMG_CONTENT"));
                    Optional result = d.showAndWait();
                    if (result.isPresent()) {
                        String url = (String)result.get();
                        url = url.replace("'", "\\'");
                        NoteHtmlEditorStage.this.webEngine.executeScript("insertImageAtCursor('" + url + "')");
                    }
                }
            });
            btnImage.setTooltip(new Tooltip(MydocMain.rb.getString("NOTE_EDITOR_STAGE_IMG_TOOLTIP")));
            Button btnCode = new Button("", (Node)new ImageView(ImageFactory.IMG_NOTE_CODE));
            bar.getItems().add((Object)btnCode);
            btnCode.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NoteHtmlEditorStage.this.webEngine.executeScript("insertCodeAtCursor()");
                }
            });
            btnCode.setTooltip(new Tooltip(MydocMain.rb.getString("NOTE_EDITOR_STAGE_CODE_TOOLTIP")));
            Button btnSyncView = new Button("", (Node)new ImageView(ImageFactory.IMG_NOTE_SYNC_VIEW));
            bar.getItems().add((Object)btnSyncView);
            btnSyncView.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NoteHtmlEditorStage.this.setHtmlText(NoteHtmlEditorStage.this.codeEditor.getCodeAndSnapshot(), false);
                }
            });
            btnSyncView.setTooltip(new Tooltip(MydocMain.rb.getString("NOTE_EDITOR_STAGE_SYNC_HTML_VIEW_TOOLTIP")));
            Button btnRefresh = new Button("", (Node)new ImageView(ImageFactory.IMG_NOTE_REFRESH));
            bar.getItems().add((Object)btnRefresh);
            btnRefresh.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NoteHtmlEditorStage.this.refreshAll();
                }
            });
            btnRefresh.setTooltip(new Tooltip(MydocMain.rb.getString("NOTE_EDITOR_STAGE_REFRESH_TOOLTIP")));
            Button btnSyncSrc = new Button("", (Node)new ImageView(ImageFactory.IMG_NOTE_SYNC_SRC));
            bar.getItems().add((Object)btnSyncSrc);
            btnSyncSrc.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    NoteHtmlEditorStage.this.reloadSource();
                }
            });
            btnSyncSrc.setTooltip(new Tooltip(MydocMain.rb.getString("NOTE_EDITOR_STAGE_SYNC_HTML_SOURCE_TOOLTIP")));
        }
        Button btnOpenFolder = new Button(MydocMain.rb.getString("MENU_CONTAINING_FOLDER"));
        btnOpenFolder.setMnemonicParsing(true);
        btnOpenFolder.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MydocMain.actionGotoFolder((Entity)NoteHtmlEditorStage.this.note);
            }
        });
        this.isToolbarShown = true;
        this.isSrcShown = false;
        this.isPropShown = true;
        this.spLeftRight = new SplitPane();
        this.spLeftRight.setOrientation(Orientation.HORIZONTAL);
        this.spProp = new ScrollPane();
        this.spProp.setFitToWidth(true);
        VBox box = new VBox();
        this.chkRenderMath = new CheckBox(MydocMain.rb.getString("NOTE_EDITOR_STAGE_RENDER_MATH"));
        this.chkRenderMath.setGraphic((Node)new ImageView(ImageFactory.IMG_NOTE_RENDER_MATH));
        this.chkRenderMath.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                NoteHtmlEditorStage.this.switchRenderingMode(true);
            }
        });
        this.chkRenderCode = new CheckBox(MydocMain.rb.getString("NOTE_EDITOR_STAGE_RENDER_CODE"));
        this.chkRenderCode.setGraphic((Node)new ImageView(ImageFactory.IMG_NOTE_RENDER_CODE));
        this.chkRenderCode.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                NoteHtmlEditorStage.this.switchRenderingMode(false);
            }
        });
        HBox chkBox = new HBox();
        chkBox.setPadding(new Insets(5.0, 5.0, 5.0, 5.0));
        chkBox.setSpacing(20.0);
        chkBox.getChildren().addAll((Object[])new Node[]{this.chkRenderCode, this.chkRenderMath});
        box.getChildren().addAll((Object[])new Node[]{this.noteProp, chkBox});
        this.spProp.setContent((Node)box);
        this.borderPane = new BorderPane();
        this.controlPane = new HBox();
        this.controlPane.getChildren().addAll((Object[])new Node[]{this.btnSave, this.btnCancel, btnOpenFolder});
        this.mainPane = new BorderPane();
        this.mainPane.setCenter((Node)this.htmlEditor);
        this.mainPane.setTop((Node)this.spProp);
        this.borderPane.setCenter((Node)this.mainPane);
        this.borderPane.setBottom((Node)this.controlPane);
        this.scene = new Scene((Parent)this.borderPane, 550.0, 450.0);
        this.setScene(this.scene);
        this.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                NoteHtmlEditorStage.this.cancel();
            }
        });
    }

    public void insertRef(String type, String url, String text) {
        text = text.replace("'", "\\'");
        this.webEngine.executeScript("insertRefAtCursor('" + type + "', '" + url + "','" + text + "');");
    }

    public boolean getIsSaved() {
        return this.isNewSaved;
    }

    private void switchRenderingMode(boolean isMathOrCode) {
        boolean readonlyMode = isMathOrCode ? !this.isMathEnabled || this.isCodeRenderEnabled : this.isMathEnabled || !this.isCodeRenderEnabled;
        String content = this.getHtmlBody();
        if (isMathOrCode) {
            this.isMathEnabled = !this.isMathEnabled;
        } else {
            boolean bl = this.isCodeRenderEnabled = !this.isCodeRenderEnabled;
        }
        if (readonlyMode) {
            this.setMode(this.isPropShown, this.isToolbarShown, true);
            this.setHtmlText(content, true);
        } else {
            this.setMode(this.isPropShown, true, this.isSrcShown);
            this.setHtmlText(content, false);
        }
    }

    public void setMode(boolean showProp, boolean showToolbar, boolean showSrc) {
        if (this.isMathEnabled || this.isCodeRenderEnabled) {
            if (this.webView == null) {
                this.webView = new WebView();
            }
            if (!this.mainPane.getChildren().contains((Object)this.webView)) {
                this.mainPane.getChildren().remove((Object)this.htmlEditor);
                this.mainPane.setCenter((Node)this.webView);
            }
        } else if (!this.mainPane.getChildren().contains((Object)this.htmlEditor)) {
            this.mainPane.getChildren().remove((Object)this.webView);
            this.mainPane.setCenter((Node)this.htmlEditor);
        }
        if (this.isToolbarShown != showToolbar) {
            if (showToolbar) {
                this.htmlEditor.lookup(".top-toolbar").setManaged(true);
                this.htmlEditor.lookup(".top-toolbar").setVisible(true);
                this.htmlEditor.lookup(".bottom-toolbar").setManaged(true);
                this.htmlEditor.lookup(".bottom-toolbar").setVisible(true);
                this.borderPane.setBottom((Node)this.controlPane);
            } else {
                this.htmlEditor.lookup(".top-toolbar").setManaged(false);
                this.htmlEditor.lookup(".top-toolbar").setVisible(false);
                this.htmlEditor.lookup(".bottom-toolbar").setManaged(false);
                this.htmlEditor.lookup(".bottom-toolbar").setVisible(false);
                this.borderPane.getChildren().remove((Object)this.controlPane);
            }
        }
        if (this.isPropShown != showProp) {
            if (showProp) {
                this.mainPane.setTop((Node)this.spProp);
            } else {
                this.mainPane.getChildren().remove((Object)this.spProp);
            }
        }
        if (this.isSrcShown != showSrc) {
            if (showSrc) {
                if (this.codeEditor == null) {
                    this.codeEditor = new CodeEditor();
                    this.codeEditor.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

                        public void handle(KeyEvent ke) {
                            if (ke.getCode().equals((Object)KeyCode.S) && ke.isAltDown()) {
                                NoteHtmlEditorStage.this.setHtmlText(NoteHtmlEditorStage.this.codeEditor.getCodeAndSnapshot(), false);
                                NoteHtmlEditorStage.this.save();
                            } else if (ke.getCode().equals((Object)KeyCode.F5)) {
                                NoteHtmlEditorStage.this.setHtmlText(NoteHtmlEditorStage.this.codeEditor.getCodeAndSnapshot(), false);
                            }
                        }
                    });
                }
                this.borderPane.getChildren().remove((Object)this.mainPane);
                this.spLeftRight.getItems().addAll((Object[])new Node[]{this.mainPane, this.codeEditor});
                this.borderPane.setCenter((Node)this.spLeftRight);
            } else {
                this.borderPane.getChildren().remove((Object)this.spLeftRight);
                this.spLeftRight.getItems().remove((Object)this.codeEditor);
                this.spLeftRight.getItems().remove((Object)this.mainPane);
                this.borderPane.setCenter((Node)this.mainPane);
            }
        }
        this.isPropShown = showProp;
        this.isToolbarShown = showToolbar;
        this.isSrcShown = showSrc;
    }

    private String getHtmlBody() {
        if (this.isCodeRenderEnabled || this.isMathEnabled) {
            return this.codeEditor.getCodeAndSnapshot();
        }
        return (String)this.webEngine.executeScript("document.body.innerHTML");
    }

    public void refreshAll() {
        this.setHtmlText(this.getHtmlBody(), true);
    }

    private void reloadSource() {
        this.codeEditor.setCode(this.getHtmlBody());
    }

    private void setHtmlText(String content, boolean reloadSource) {
        String html = this.fillBasePath(this.templateHead);
        html = html + (this.isMathEnabled ? this.fillBasePath(this.jsMathJax) : "");
        html = html + (this.isCodeRenderEnabled ? this.fillBasePath(this.jsCodeHighlight) : "");
        String body = this.templateBody.replace("$$body$$", content);
        body = body.replace("$$truefalse$$", String.valueOf(!this.isMathEnabled && !this.isCodeRenderEnabled));
        html = html + body;
        if (this.isMathEnabled || this.isCodeRenderEnabled) {
            this.webView.getEngine().loadContent(html);
            if (this.isSrcShown && reloadSource) {
                this.codeEditor.setCode(content);
            }
        } else {
            this.htmlEditor.setHtmlText(html);
            if (this.isSrcShown && reloadSource) {
                this.codeEditor.setCode(content);
            }
        }
    }

    public void toggleFullMode() {
        if (this.isToolbarShown) {
            this.setMode(false, false, false);
        } else {
            this.setMode(true, true, false);
        }
        if (this.isSrcShown) {
            this.reloadSource();
        }
    }

    public void toggleToolbarMode() {
        this.setMode(this.isPropShown, !this.isToolbarShown, this.isSrcShown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (!this.noteProp.validateEntity()) {
            return;
        }
        String filePath = this.note.getFilePath();
        Path file = Paths.get(NoteManager.getInstance().getNoteFolder().toString(), filePath);
        String htmlTxt = null;
        htmlTxt = this.isCodeRenderEnabled || this.isMathEnabled ? this.codeEditor.getCodeAndSnapshot() : (String)this.webEngine.executeScript("document.body.innerHTML");
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("<html><head>");
        if (this.isMathEnabled) {
            lines.add(headerMathJax);
        }
        if (this.isCodeRenderEnabled) {
            lines.add(headerCodeHighlight);
        }
        if (this.fontSize != -1) {
            lines.add("<style>html * { font-size: " + this.fontSize + "px;}</style>");
        }
        lines.add(headerMydocCSS);
        lines.add("</head><body>");
        lines.add(htmlTxt);
        lines.add("</body></html>");
        try {
            Files.write(file, lines, new OpenOption[0]);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        this.note.setModified(true);
        Session s = this.sf.openSession();
        s.beginTransaction();
        try {
            s.update((Object)this.note);
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        finally {
            s.close();
        }
        this.isNewSaved = true;
        this.isNew = false;
    }

    public void cancel() {
        MydocMain.getInstance().releaseEntity((Entity)this.note);
        if (this.isNew) {
            try {
                NoteManager.getInstance().delete(this.note, false);
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
            }
        }
        this.hide();
    }

    public void setNote(Note note) {
        this.note = note;
        this.isNew = true;
        this.isNewSaved = false;
        this.isMathEnabled = false;
        this.isCodeRenderEnabled = false;
        this.chkRenderMath.setSelected(this.isMathEnabled);
        this.chkRenderCode.setSelected(this.isCodeRenderEnabled);
        this.setTitle(note.toString());
        this.fontSize = -1;
        this.setMode(true, true, false);
        this.setHtmlText("<br/><br/>", true);
        this.noteProp.setEntity((Entity)note);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNote(Long id) {
        try (Session s = this.sf.openSession();){
            this.note = (Note)s.get(Note.class, (Serializable)id);
            this.isNew = false;
            this.isNewSaved = false;
            this.setTitle(this.note.toString());
            this.noteProp.setEntity((Entity)this.note);
            String filePath = this.note.getFilePath();
            Path file = Paths.get(NoteManager.getInstance().getNoteFolder().toString(), filePath);
            String result = null;
            try {
                ContentParser parser = new ContentParser();
                result = parser.parse(file);
                this.fontSize = parser.fontSize;
                this.isMathEnabled = parser.isMathEnabled;
                this.isCodeRenderEnabled = parser.isCodeHighlightEnabled;
            }
            catch (Exception ex) {
                logger.error("", (Throwable)ex);
                s.close();
                return;
            }
            if (result != null) {
                this.chkRenderMath.setSelected(this.isMathEnabled);
                this.chkRenderCode.setSelected(this.isCodeRenderEnabled);
                if (this.isMathEnabled || this.isCodeRenderEnabled) {
                    this.setMode(true, true, true);
                } else {
                    this.setMode(false, false, false);
                }
                this.setHtmlText(result, true);
            }
        }
    }

    private String fillBasePath(String input) {
        input = input.replace("${fontsize}", this.fontSize == -1 ? "" : "<style>html * { font-size: " + this.fontSize + "px;}</style>");
        Path current = Paths.get(".", new String[0]);
        return input.replace("${basepath}", current.toAbsolutePath().toString());
    }

    public class JavaCallback {
        public void browse(String str) {
            LaunchUtils.browsePage((String)str);
        }

        public void out(String str) {
            System.out.println(str);
        }

        public void launch(String url) {
            MydocMain.launchWithURL(url);
        }
    }
}

