/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.help;

import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import myencyclopedia.common.gui.LaunchUtils;
import myencyclopedia.gui.help.HttpPostUtil;
import myencyclopedia.gui.help.ProductInfo;
import myencyclopedia.gui.help.WebConsts;

public class AutoUpdateUtil {
    public static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-help");

    public static void showStage(final ProductInfo productInfo) {
        Stage stg = new Stage();
        stg.initModality(Modality.APPLICATION_MODAL);
        Button btnOk = new Button(rb.getString("OK"));
        btnOk.setDefaultButton(true);
        btnOk.setOnAction(e -> stg.hide());
        final Label lbl = new Label(rb.getString("AutoUpdateUtil.connect"));
        Hyperlink link = new Hyperlink();
        link.setText("http://myencyclopedia.top/" + productInfo.getProductName() + "/download");
        link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                LaunchUtils.browsePage((String)("http://myencyclopedia.top/" + productInfo.getProductName() + "/download"));
            }
        });
        VBox box = new VBox();
        box.getChildren().addAll((Object[])new Node[]{lbl, link, btnOk});
        Scene scene = new Scene((Parent)box);
        stg.setScene(scene);
        stg.setTitle(String.format(rb.getString("AutoUpdateUtil.title"), productInfo.getProductName()));
        Task<Void> task = new Task<Void>(){

            public Void call() {
                String param = "software=" + WebConsts.getSoftwareId(productInfo) + "&version=" + WebConsts.convertVersion(productInfo);
                try {
                    String[] pairs;
                    String str = HttpPostUtil.post("http://myencyclopedia.top/updateinfo", param);
                    for (String pair : pairs = str.split(";")) {
                        if (!pair.startsWith("version")) continue;
                        String[] keyValue = pair.split(":");
                        final Integer version = Integer.parseInt(keyValue[1]);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                if (version > WebConsts.convertVersion(productInfo)) {
                                    lbl.setText(rb.getString("AutoUpdateUtil.new_version") + WebConsts.getVersionStr(version));
                                } else {
                                    lbl.setText(rb.getString("AutoUpdateUtil.latest"));
                                }
                            }
                        });
                    }
                }
                catch (Exception ex) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            lbl.setText(rb.getString("AutoUpdateUtil.fail") + ex.getMessage());
                        }
                    });
                }
                return null;
            }
        };
        new Thread((Runnable)task).start();
        stg.showAndWait();
    }
}

