/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.help;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import myencyclopedia.common.utils.CertUtil;
import myencyclopedia.common.utils.ZipUtil;
import myencyclopedia.gui.help.ProductInfo;
import myencyclopedia.gui.help.RegisterInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseManager {
    private static LicenseManager mgr;
    private static String user;
    private static Path keyfile;
    private static boolean hasExpired;
    private static final Logger logger;
    private static boolean isDev;
    public static ResourceBundle rb;

    private LicenseManager(ProductInfo productInfo) {
        String componentName = "me-" + productInfo.getInternalName();
        String fullVersion = LicenseManager.tryGetVersion(componentName);
        if (fullVersion == null) {
            fullVersion = "10000.0";
            isDev = true;
        } else {
            isDev = false;
        }
        String buildtime = LicenseManager.getBuildtime(componentName);
        productInfo.setBuildtime(buildtime);
        logger.info("isDev: " + isDev);
        productInfo.setIsDev(isDev);
        if (isDev) {
            return;
        }
        productInfo.setFullVersion(fullVersion);
        String res = "." + productInfo.getProductName() + ".key";
        RegisterInfo regInfo = productInfo.getRegisterInfo();
        keyfile = Paths.get(res, new String[0]);
        String key = LicenseManager.readEncripted(productInfo.getProductName());
        if (key == null) {
            if (!isDev) {
                hasExpired = LicenseManager.creationTimeCheck(componentName + ".jar");
            }
            return;
        }
        byte[] magic = Base64.getDecoder().decode(key);
        InputStream certInputStream = CertUtil.class.getResourceAsStream("/me.cer");
        String origKey = null;
        try {
            String[] values;
            byte[] demagic = CertUtil.decrypt((byte[])magic, (InputStream)certInputStream);
            origKey = new String(demagic);
            for (String keyValue : values = origKey.split(";")) {
                String[] pair = keyValue.split(":");
                if (pair.length != 2) continue;
                if (pair[0].equals("product")) {
                    if (!productInfo.getInternalName().equals(pair[1])) {
                        throw new Exception("product key mismatch:" + pair[1]);
                    }
                    regInfo.product = pair[1];
                    continue;
                }
                if (pair[0].equals("version")) {
                    regInfo.version = Float.valueOf(Float.parseFloat(pair[1]));
                    continue;
                }
                if (!pair[0].equals("user")) continue;
                regInfo.user = pair[1];
            }
            if (productInfo.matchRegInfo()) {
                user = regInfo.user;
            }
        }
        catch (Exception ex) {
            logger.error(ex.toString());
            if (!isDev) {
                hasExpired = LicenseManager.creationTimeCheck(componentName + ".jar");
            }
            return;
        }
    }

    private static String tryGetVersion(String componentName) {
        Properties configProp = new Properties();
        InputStream in = LicenseManager.class.getClassLoader().getResourceAsStream("info/" + componentName + ".properties");
        if (in == null) {
            return null;
        }
        try {
            configProp.load(in);
            if (configProp.getProperty("version").equals("${project.version}")) {
                return null;
            }
            return configProp.getProperty("version");
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static String getBuildtime(String componentName) {
        String propFilename = componentName + "-build.properties";
        Properties configProp = new Properties();
        InputStream in = LicenseManager.class.getClassLoader().getResourceAsStream("info/" + propFilename);
        if (in == null) {
            logger.error("no buildtime property file:" + propFilename);
            System.exit(-1);
        }
        try {
            configProp.load(in);
            return configProp.getProperty("buildtime");
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
            System.exit(-1);
            return null;
        }
    }

    public static boolean isDev() {
        return isDev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean creationTimeCheck(String fileToCompare) {
        File fileToCheck = Paths.get("./myencyclopedia/" + fileToCompare, new String[0]).toFile();
        if (!fileToCheck.exists()) {
            try {
                File tempPath = Files.createTempDirectory("meapp", new FileAttribute[0]).toFile();
                String current = String.valueOf(new Date().getTime());
                File timestampFile = new File(tempPath, current);
                timestampFile.createNewFile();
                ZipUtil.zipFile((File)timestampFile, (File)fileToCheck);
            }
            catch (IOException ex) {
                logger.error("Error in creationTimeCheck", (Throwable)ex);
                System.exit(-1);
            }
            return false;
        }
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(fileToCheck);
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            if (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                String entryName = entry.getName();
                Long ts = Long.parseLong(entryName);
                long currentTime = System.currentTimeMillis();
                if (currentTime - ts > 2592000000L) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            logger.error("Error reading file:" + zipFile, (Throwable)ioe);
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (zipFile != null) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static LicenseManager initLicenseManager(ProductInfo productInfo) {
        if (mgr == null) {
            mgr = new LicenseManager(productInfo);
            logger.info("hasExpired:" + hasExpired);
        }
        return mgr;
    }

    public static LicenseManager getLicenseManager() {
        if (mgr == null) {
            System.err.println("Must init LicenseManager first");
            System.exit(-1);
        }
        return mgr;
    }

    public boolean isRegistered() {
        return user != null;
    }

    public boolean hasExpired() {
        return hasExpired;
    }

    public static void confirmExpiredDialog() {
        if (hasExpired) {
            Alert alert = new Alert(Alert.AlertType.WARNING, rb.getString("LicenseManager.limited"), new ButtonType[0]);
            alert.setTitle(rb.getString("LicenseManager.warning_title"));
            alert.showAndWait();
        }
    }

    public static void confirmExpiredDialogNoLimited() {
        if (hasExpired) {
            Alert alert = new Alert(Alert.AlertType.WARNING, rb.getString("LicenseManager.nolimited"), new ButtonType[0]);
            alert.setTitle(rb.getString("LicenseManager.warning_title"));
            alert.showAndWait();
        }
    }

    public String getRegisteredUser() {
        return user;
    }

    public void updateKey(String key) {
        ArrayList<String> strs = new ArrayList<String>();
        strs.add(key);
        try {
            Files.write(keyfile, strs, new OpenOption[0]);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readEncripted(String product) {
        if (!Files.exists(keyfile, new LinkOption[0]) || !Files.isRegularFile(keyfile, new LinkOption[0])) {
            return null;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = Files.newBufferedReader(keyfile);
            String string = line = reader.readLine();
            return string;
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
            }
        }
    }

    static {
        hasExpired = false;
        logger = LoggerFactory.getLogger(LicenseManager.class);
        isDev = true;
        rb = ResourceBundle.getBundle("properties.gui-help");
    }
}

