/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.gui.help;

import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import myencyclopedia.common.gui.LaunchUtils;
import myencyclopedia.gui.help.HttpPostUtil;
import myencyclopedia.gui.help.ProductInfo;
import myencyclopedia.gui.help.WebConsts;

public class SendMessageUtil {
    public static ResourceBundle rb = ResourceBundle.getBundle("properties.gui-help");

    public static void showStage(final ProductInfo productInfo) {
        Stage stg = new Stage();
        stg.initModality(Modality.APPLICATION_MODAL);
        Button btnOK = new Button(rb.getString("OK"));
        btnOK.setDefaultButton(true);
        TextField field = new TextField();
        TextArea area = new TextArea();
        ComboBox comboBox = new ComboBox();
        comboBox.getItems().addAll(new Object[]{"General", "Report Bug", "Your suggestion"});
        comboBox.setValue((Object)"General");
        Label lblFeedback = new Label(rb.getString("SendMessageUtil.visit"));
        Hyperlink linkFeedback = new Hyperlink();
        linkFeedback.setText("http://myencyclopedia.top/" + productInfo.getProductName() + "/feedback");
        linkFeedback.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                LaunchUtils.browsePage((String)("http://myencyclopedia.top/" + productInfo.getProductName() + "/feedback"));
            }
        });
        Label lblDonate = new Label(rb.getString("SendMessageUtil.donate"));
        Hyperlink linkDonate = new Hyperlink();
        linkDonate.setText("http://myencyclopedia.top/" + productInfo.getProductName() + "/donate");
        linkDonate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                LaunchUtils.browsePage((String)("http://myencyclopedia.top/" + productInfo.getProductName() + "/donate"));
            }
        });
        VBox box = new VBox();
        box.getChildren().addAll((Object[])new Node[]{field, comboBox, area, lblFeedback, linkFeedback, lblDonate, linkDonate, btnOK});
        VBox.setVgrow((Node)area, (Priority)Priority.ALWAYS);
        Scene scene = new Scene((Parent)box);
        stg.setScene(scene);
        stg.setTitle(String.format(rb.getString("SendMessageUtil.title"), productInfo.getProductName()));
        btnOK.setOnAction(e -> {
            if (area.getText().trim().length() < 10) {
                Alert alert = new Alert(Alert.AlertType.ERROR, rb.getString("SendMessageUtil.invalid_msg"), new ButtonType[0]);
                alert.showAndWait();
                return;
            }
            String param = "software=" + WebConsts.getSoftwareId(productInfo) + "&version=" + WebConsts.convertVersion(productInfo) + "&category=" + WebConsts.getMessageCategoryId((String)comboBox.valueProperty().getValue()) + "&username=" + productInfo.getRegisterInfo().user + "&subject=" + field.getText() + "&content=" + area.getText();
            try {
                String string = HttpPostUtil.post("http://myencyclopedia.top/send_msg", param);
            }
            catch (Exception exception) {
                // empty catch block
            }
            stg.hide();
        });
        stg.showAndWait();
    }
}

