/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.search.mydoc;

import java.nio.file.Path;
import java.nio.file.Paths;
import myencyclopedia.logic.ebook.EbookDAO;
import myencyclopedia.logic.mydoc.DocManager;
import myencyclopedia.logic.mydoc.NoteManager;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.ebook.EbookFileInfo;
import myencyclopedia.model.mydoc.Doc;
import myencyclopedia.model.mydoc.Note;
import myencyclopedia.search.mydoc.ParseUtils;
import myencyclopedia.search.mydoc.parser.IndexingReporter;
import myencyclopedia.search.mydoc.parser.ParseContext;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextClassBridge
implements FieldBridge {
    private static final Logger logger = LoggerFactory.getLogger(FullTextClassBridge.class);
    public static IndexingReporter reporter;

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        logger.info("FullTextClassBridge: " + value);
        FieldType type = new FieldType();
        type.setIndexed(true);
        type.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS);
        type.setStored(true);
        type.setStoreTermVectors(true);
        type.setTokenized(true);
        type.setStoreTermVectorPositions(true);
        type.setStoreTermVectorOffsets(true);
        ParseContext context = new ParseContext(reporter);
        if (value instanceof Note) {
            Note note = (Note)value;
            Path file = NoteManager.getInstance().getPath(note);
            String content = ParseUtils.parseFile(file, context).getContent().toString();
            document.add((IndexableField)new Field("contents", content, type));
            document.add((IndexableField)new Field("classtype", Note.class.getSimpleName(), type));
        } else if (value instanceof Ebook) {
            Ebook ebook = (Ebook)value;
            RelationCollection r = (RelationCollection)ebook.getRelation("file_info");
            EbookFileInfo efi = ((EbookFileInfo[])r.getTarget())[0];
            String content = null;
            Path file = Paths.get(EbookDAO.getFileFullPath((EbookFileInfo)efi), new String[0]);
            content = ParseUtils.parseFolder(file, context).getContent().toString();
            document.add((IndexableField)new Field("contents", content, type));
            document.add((IndexableField)new Field("classtype", Ebook.class.getSimpleName(), type));
        } else if (value instanceof Doc) {
            Doc doc = (Doc)value;
            Path docPath = DocManager.getInstance().getDocFolder(doc);
            String content = ParseUtils.parseFolder(docPath, context).getContent().toString();
            document.add((IndexableField)new Field("contents", content, type));
            document.add((IndexableField)new Field("classtype", Doc.class.getSimpleName(), type));
        }
    }
}

