/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.search.mydoc.highlighter;

import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebView;
import myencyclopedia.common.gui.GUIEvent;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.model.Entity;

public class EntityWithExcerpts
extends VBox {
    private WebView webView;
    private Hyperlink link;
    private String[] excerpts = new String[0];
    private Entity entity;
    private int numberPerPage = 10;
    private Hyperlink linkToBegin;
    private Hyperlink linkToEnd;
    private Hyperlink linkPrev;
    private Hyperlink linkNext;
    private TextField pageInput;
    private Label lblPage;
    private Label lblGotoPage;
    private int pageIdx;
    private GUIListener listener;
    public static final String EVENT_ENTITY_LAUNCHED = "EntityWithExcerpts_launch_entity";
    public ResourceBundle rb;

    public EntityWithExcerpts(GUIListener l) {
        this.listener = l;
        this.rb = ResourceBundle.getBundle("properties.search-mydoc");
        this.lblPage = new Label();
        this.linkToBegin = new Hyperlink("<<");
        this.linkToBegin.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                EntityWithExcerpts.this.render(0);
            }
        });
        this.linkPrev = new Hyperlink("<");
        this.linkPrev.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                EntityWithExcerpts.this.render(EntityWithExcerpts.this.pageIdx - 1);
            }
        });
        this.linkNext = new Hyperlink(">");
        this.linkNext.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                EntityWithExcerpts.this.render(EntityWithExcerpts.this.pageIdx + 1);
            }
        });
        this.linkToEnd = new Hyperlink(">>");
        this.linkToEnd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                EntityWithExcerpts.this.render((EntityWithExcerpts.this.excerpts.length - 1) / EntityWithExcerpts.this.numberPerPage);
            }
        });
        this.pageInput = new TextField("");
        this.pageInput.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    try {
                        EntityWithExcerpts.this.render(Integer.parseInt(EntityWithExcerpts.this.pageInput.getText()) - 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        this.webView = new WebView();
        this.link = new Hyperlink("");
        this.link.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                EntityWithExcerpts.this.listener.dispatch(new GUIEvent((Object)EntityWithExcerpts.this, EntityWithExcerpts.EVENT_ENTITY_LAUNCHED, (Object)EntityWithExcerpts.this.entity));
            }
        });
        this.lblGotoPage = new Label(this.rb.getString("GOTO_PAGE"));
        HBox navBox = new HBox();
        navBox.getChildren().addAll((Object[])new Node[]{this.linkToBegin, this.linkPrev, this.linkNext, this.linkToEnd, this.lblPage, this.lblGotoPage, this.pageInput});
        this.getChildren().addAll((Object[])new Node[]{this.link, navBox, this.webView});
        VBox.setVgrow((Node)this.webView, (Priority)Priority.ALWAYS);
    }

    private void render(int idx) {
        if (this.excerpts.length == 0 || idx < 0) {
            return;
        }
        if (idx * this.numberPerPage < this.excerpts.length) {
            this.webView.getEngine().loadContent(this.renderItemFrom(idx * this.numberPerPage));
            this.pageIdx = idx;
            this.lblPage.setText(String.format(this.rb.getString("N_OF_TOTAL"), this.pageIdx + 1, String.valueOf(this.excerpts.length / this.numberPerPage + 1)));
        }
    }

    public void render(Entity en, String[] excerpts) {
        this.excerpts = excerpts;
        this.entity = en;
        this.link.setText(en.toString());
        this.render(0);
    }

    public String renderItemFrom(int startingPos) {
        StringBuilder sb = new StringBuilder("");
        for (int i = startingPos; i < startingPos + this.numberPerPage; ++i) {
            if (i >= this.excerpts.length) continue;
            sb.append("<p>").append(this.excerpts[i]).append("</p>");
        }
        return sb.toString();
    }
}

