/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.search.mydoc.highlighter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import myencyclopedia.common.gui.GUIListener;
import myencyclopedia.hibernate.AsyncListReceiver;
import myencyclopedia.logic.query.EntityQueryUtil;
import myencyclopedia.logic.query.MECriteria;
import myencyclopedia.logic.query.SearchWorkerThread;
import myencyclopedia.model.Entity;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.mydoc.Doc;
import myencyclopedia.model.mydoc.Note;
import myencyclopedia.search.mydoc.highlighter.EntityWithExcerpts;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.vectorhighlight.BaseFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.FastVectorHighlighter;
import org.apache.lucene.search.vectorhighlight.FieldQuery;
import org.apache.lucene.search.vectorhighlight.FragListBuilder;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.ScoreOrderFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.SimpleFragListBuilder;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.SearchFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HighlighterStage
extends Stage
implements AsyncListReceiver {
    private static final Logger logger = LoggerFactory.getLogger(HighlighterStage.class);
    private MECriteria critiera;
    private static HighlighterStage theInstance;
    private static SearchWorkerThread searchThread;
    private static GUIListener listener;
    private static SessionFactory sf;
    protected BorderPane bp;
    protected Object result;
    protected Scene scene;
    protected Button btnOK;
    private static String contentQuery;
    private EntityWithExcerpts entityWithExcerpts;
    private Hyperlink linkToBegin;
    private Hyperlink linkToEnd;
    private Hyperlink linkPrev;
    private Hyperlink linkNext;
    private TextField input;
    private Label lblPage;
    private Label lblGotoPage;
    private TextField pageInput;
    private List<Entity> entityList = new LinkedList<Entity>();
    private boolean firstRendererd;
    private int pageIdx;
    public ResourceBundle rb;

    private HighlighterStage() {
        if (sf == null) {
            System.out.println("HighlighterStage sf == null");
            System.exit(-1);
        }
        if (searchThread == null) {
            System.out.println("HighlighterStage searchThread == null");
            System.exit(-1);
        }
        if (listener == null) {
            System.out.println("HighlighterStage listener == null");
            System.exit(-1);
        }
        this.rb = ResourceBundle.getBundle("properties.search-mydoc");
        this.btnOK = new Button(this.rb.getString("OK"));
        this.btnOK.setOnAction(e -> this.hide());
        this.entityWithExcerpts = new EntityWithExcerpts(listener);
        this.input = new TextField();
        this.input.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    HighlighterStage.this.run(HighlighterStage.this.input.getText());
                }
            }
        });
        this.lblPage = new Label();
        this.linkToBegin = new Hyperlink("<<");
        this.linkToBegin.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                HighlighterStage.this.render(0);
            }
        });
        this.linkPrev = new Hyperlink("<");
        this.linkPrev.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                HighlighterStage.this.render(HighlighterStage.this.pageIdx - 1);
            }
        });
        this.linkNext = new Hyperlink(">");
        this.linkNext.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                HighlighterStage.this.render(HighlighterStage.this.pageIdx + 1);
            }
        });
        this.linkToEnd = new Hyperlink(">>");
        this.linkToEnd.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                HighlighterStage.this.render(HighlighterStage.this.entityList.size() - 1);
            }
        });
        this.lblGotoPage = new Label(this.rb.getString("GOTO_PAGE"));
        this.pageInput = new TextField("");
        this.pageInput.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    try {
                        HighlighterStage.this.render(Integer.parseInt(HighlighterStage.this.pageInput.getText()) - 1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        HBox navBox = new HBox();
        navBox.getChildren().addAll((Object[])new Node[]{this.linkToBegin, this.linkPrev, this.linkNext, this.linkToEnd, this.lblPage, this.lblGotoPage, this.pageInput});
        VBox box = new VBox();
        box.getChildren().addAll((Object[])new Node[]{this.input, navBox, this.entityWithExcerpts});
        VBox.setVgrow((Node)this.entityWithExcerpts, (Priority)Priority.ALWAYS);
        this.scene = new Scene((Parent)box);
        this.setScene(this.scene);
        Image img = new Image(HighlighterStage.class.getResourceAsStream("/window_search_text.png"));
        this.getIcons().add((Object)img);
        this.setTitle(this.rb.getString("HIGHLIGHTER_TITLE"));
    }

    public static void init(SessionFactory sessionFactory, SearchWorkerThread thread, GUIListener l) {
        sf = sessionFactory;
        searchThread = thread;
        listener = l;
    }

    public static HighlighterStage getInstance() {
        if (theInstance == null) {
            theInstance = new HighlighterStage();
        }
        return theInstance;
    }

    public void renderEntity(final Entity en, final String[] excerpts) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HighlighterStage.this.entityWithExcerpts.render(en, excerpts);
            }
        });
    }

    public void run(String queryInput) {
        this.critiera = new MECriteria((AsyncListReceiver)this, (Class[])HighlighterStage.getAllTargets());
        if (EntityQueryUtil.parseInput((String)queryInput, (MECriteria)this.critiera)) {
            if (this.critiera.getContentQuery() == null) {
                this.reset();
                return;
            }
            contentQuery = this.critiera.getContentQuery();
            searchThread.produce((Object)this, (Object)this.critiera);
        }
    }

    public void reset() {
    }

    public void beginLoading() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HighlighterStage.this.lblPage.setText(HighlighterStage.this.rb.getString("IN_PROGRESS"));
                HighlighterStage.this.entityList.clear();
                HighlighterStage.this.firstRendererd = false;
                HighlighterStage.this.pageIdx = -1;
            }
        });
    }

    public void endLoading() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HighlighterStage.this.lblPage.setText(String.format(HighlighterStage.this.rb.getString("N_OF_TOTAL"), "1", HighlighterStage.this.entityList.size()));
            }
        });
    }

    public void appendList(final List<Entity> lst) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                HighlighterStage.this.entityList.addAll(lst);
                if (!HighlighterStage.this.firstRendererd && !HighlighterStage.this.entityList.isEmpty()) {
                    HighlighterStage.this.render(0);
                    HighlighterStage.this.firstRendererd = true;
                }
            }
        });
    }

    private void render(int idx) {
        if (this.entityList.isEmpty() || idx < 0) {
            return;
        }
        if (idx < this.entityList.size()) {
            this.highlight(this.entityList.get(idx));
            this.pageIdx = idx;
            this.lblPage.setText(String.format(this.rb.getString("N_OF_TOTAL"), this.pageIdx + 1, this.entityList.size()));
        }
    }

    public static Class<? extends Entity>[] getAllTargets() {
        return new Class[]{Note.class, Doc.class, Ebook.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean highlight(Entity entity) {
        Session s = sf.openSession();
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser("contents", fullTextSession.getSearchFactory().getAnalyzer(entity.getClass()));
        Query luceneQuery = null;
        try {
            luceneQuery = parser.parse(String.format("%s:%s AND %s", "id", entity.getId().toString(), contentQuery));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[]{entity.getClass()}).setProjection(new String[]{"__HSearch_This", "__HSearch_id", "__HSearch_DocumentId"});
        List lst = fullTextQuery.list();
        SearchFactory searchFactory = fullTextSession.getSearchFactory();
        IndexReader reader = searchFactory.getIndexReaderAccessor().open(new Class[]{entity.getClass()});
        FastVectorHighlighter highlighter = HighlighterStage.getHighlighter();
        FieldQuery fieldQuery = highlighter.getFieldQuery(luceneQuery);
        try {
            Iterator iterator = lst.iterator();
            if (iterator.hasNext()) {
                Object[] arr = (Object[])iterator.next();
                String[] snippets = highlighter.getBestFragments(fieldQuery, reader, ((Integer)arr[2]).intValue(), "contents", 200, 10000);
                if (snippets.length > 0) {
                    this.renderEntity((Entity)arr[0], snippets);
                }
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            boolean bl = false;
            return bl;
        }
        finally {
            searchFactory.getIndexReaderAccessor().close(reader);
            s.close();
        }
        return false;
    }

    static FastVectorHighlighter getHighlighter() {
        SimpleFragListBuilder fragListBuilder = new SimpleFragListBuilder();
        ScoreOrderFragmentsBuilder fragmentBuilder = new ScoreOrderFragmentsBuilder(BaseFragmentsBuilder.COLORED_PRE_TAGS, BaseFragmentsBuilder.COLORED_POST_TAGS);
        return new FastVectorHighlighter(true, true, (FragListBuilder)fragListBuilder, (FragmentsBuilder)fragmentBuilder);
    }
}

