/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.search.mydoc.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import myencyclopedia.search.mydoc.parser.FileParser;
import myencyclopedia.search.mydoc.parser.ParseContext;
import myencyclopedia.search.mydoc.parser.ParseException;
import myencyclopedia.search.mydoc.parser.ParseResult;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.apache.pdfbox.util.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfParser
implements FileParser {
    private static final Logger logger = LoggerFactory.getLogger(PdfParser.class);

    @Override
    public ParseResult parse(File file, final ParseContext context) throws ParseException {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
        PDDocument pdfDoc = null;
        try {
            int pageCount;
            pdfDoc = PDDocument.load((InputStream)in, (boolean)true);
            try {
                PDDocumentInformation pdInfo = pdfDoc.getDocumentInformation();
                pageCount = pdfDoc.getNumberOfPages();
            }
            catch (ClassCastException e) {
                throw new ParseException(e);
            }
            StringWriter writer = new StringWriter();
            final StringBuilder annotations = new StringBuilder();
            PDFTextStripper stripper = new PDFTextStripper(){

                protected void startPage(PDPage page) throws IOException {
                    context.publishProgress(this.getCurrentPageNo(), pageCount);
                }

                protected void endPage(PDPage page) throws IOException {
                    try {
                        for (PDAnnotation a : page.getAnnotations()) {
                            if (!(a instanceof PDAnnotationMarkup)) continue;
                            PDAnnotationMarkup annot = (PDAnnotationMarkup)a;
                            String title = annot.getTitlePopup();
                            String subject = annot.getSubject();
                            String contents = annot.getContents();
                            if (title != null) {
                                annotations.append(title + " ");
                            }
                            if (subject != null) {
                                annotations.append(subject + " ");
                            }
                            if (contents == null) continue;
                            annotations.append(contents + " ");
                        }
                    }
                    catch (IOException e) {
                        if (e.getMessage().startsWith("Error: Unknown annotation type")) {
                            System.err.println(e.getMessage());
                        }
                        throw e;
                    }
                }
            };
            stripper.setForceParsing(true);
            try {
                stripper.writeText(pdfDoc, (Writer)writer);
            }
            catch (RuntimeException e) {
                throw new ParseException(e);
            }
            writer.write(" ");
            writer.write(annotations.toString());
            ParseResult parseResult = new ParseResult(writer.getBuffer());
            return parseResult;
        }
        catch (IOException e) {
            if (e.getCause() instanceof CryptographyException) {
                throw new ParseException("Crypted");
            }
            throw new ParseException(e);
        }
        finally {
            PdfParser.close(pdfDoc);
        }
    }

    static void close(PDDocument doc) {
        if (doc != null) {
            try {
                doc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

