/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.model.hbn;

import java.lang.invoke.MethodHandle;
import myencyclopedia.model.Entity;
import myencyclopedia.model.Property;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBPropertyImpl
implements Property {
    protected MethodHandle mhGetter;
    protected MethodHandle mhSetter;
    protected Entity entity;
    protected String name;
    protected Class valueClass;
    private static final Logger logger = LoggerFactory.getLogger(HBPropertyImpl.class);

    public HBPropertyImpl(Entity entity, String name, Class valueClass, MethodHandle mhGetter, MethodHandle mhSetter) {
        this.entity = entity;
        this.name = name;
        this.valueClass = valueClass;
        this.mhGetter = mhGetter;
        this.mhSetter = mhSetter;
    }

    public Entity getOwner() {
        return this.entity;
    }

    public Class[] getType() {
        return new Class[]{this.valueClass};
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        try {
            Object in = this.mhGetter.invoke(this.entity);
            return in;
        }
        catch (Throwable ex) {
            logger.error("", ex);
            return null;
        }
    }

    public void setValue(Object newValue) {
        try {
            this.mhSetter.invoke(this.entity, newValue);
        }
        catch (Throwable ex) {
            logger.error("", ex);
        }
    }
}

