/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.ebook.progress;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import myencyclopedia.common.progress.LogicEvent;
import myencyclopedia.common.utils.FileCopyUtil;
import myencyclopedia.common.utils.TraverseDir;
import myencyclopedia.logic.ebook.progress.EbookIterationFinishStepResult;
import myencyclopedia.logic.ebook.progress.EbookIterationLogic;
import myencyclopedia.logic.ebook.utils.EbookUtils;
import myencyclopedia.logic.ebook.utils.IsEbookDirectory;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.ebook.EbookFileInfo;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BackupLogic
extends EbookIterationLogic {
    private boolean stopProcess = false;
    private LogicEvent prepareFinishedEvent;
    private boolean needCopying = false;
    private static final Logger logger = LoggerFactory.getLogger(BackupLogic.class);

    public BackupLogic(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public boolean hasNextStep() {
        if (this.stopProcess) {
            return false;
        }
        return this.bookExamed < this.books.size();
    }

    @Override
    public boolean doExtraPrepare() {
        long numberInDB;
        String ebookFolder = ConfigMydoc.getInstance().getBookShelfPath().toString();
        File folder = new File(ebookFolder);
        if (!IsEbookDirectory.validate(folder)) {
            this.prepareFinishedEvent = new LogicEvent("FinishPreparing", (Object)new EbookIterationFinishStepResult(0L, false, ebookFolder + "not a valid ebook folder"));
            return false;
        }
        long numberInFolder = TraverseDir.getFileExcludingDirNumberInFolder((File)folder);
        if (numberInFolder != (numberInDB = EbookUtils.getEbookNumberInDB(this.sessionFactory))) {
            String msg = "Folder " + ebookFolder + " has " + numberInFolder + " books, ";
            msg = msg + "but DB has " + numberInDB + " records";
            this.prepareFinishedEvent = new LogicEvent("FinishPreparing", (Object)new EbookIterationFinishStepResult(0L, false, msg));
            return false;
        }
        this.prepareFinishedEvent = new LogicEvent("FinishPreparing", null);
        return true;
    }

    protected LogicEvent constructFinishPreparingEvent() {
        return this.prepareFinishedEvent;
    }

    @Override
    public EbookIterationFinishStepResult processEbook(Ebook book) {
        EbookFileInfo fileInfo = book.getDefaultEbookFileInfo();
        File bookFile = new File(EbookUtils.getFileFullPath(book));
        String fromFilePath = ConfigMydoc.getInstance().getBookShelfPath() + File.separator + fileInfo.getRelativePath() + File.separator + fileInfo.getFileName();
        File fromFile = new File(fromFilePath);
        String toFilePath = (Object)((Object)ConfigMydoc.getInstance()) + File.separator + fileInfo.getRelativePath() + File.separator + fileInfo.getFileName();
        File toFile = new File(toFilePath);
        EbookIterationFinishStepResult result = this.checkSourceFile(book, fromFile);
        if (result != null) {
            return result;
        }
        result = this.checkTargetFile(book, toFile);
        if (result != null) {
            return result;
        }
        if (this.needCopying) {
            try {
                FileCopyUtil.copy((Path)fromFile.toPath(), (Path)toFile.toPath());
                return new EbookIterationFinishStepResult(fileInfo.getId(), true, "copied");
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
                return new EbookIterationFinishStepResult(fileInfo.getId(), false, "Error while copying");
            }
        }
        return new EbookIterationFinishStepResult(fileInfo.getId(), true, "ignored");
    }

    public EbookIterationFinishStepResult checkSourceFile(Ebook book, File srcFile) {
        EbookFileInfo fileInfo = book.getDefaultEbookFileInfo();
        if (!srcFile.exists()) {
            this.stopProcess = true;
            return new EbookIterationFinishStepResult(fileInfo.getId(), false, "source file not found!");
        }
        long length = srcFile.length();
        boolean result = book.getDefaultEbookFileInfo().getFileSize().equals(length);
        if (result) {
            LogicEvent event = new LogicEvent("Additional", (Object)new EbookIterationFinishStepResult(fileInfo.getId(), true, "source file md5 matched"));
            this.dispatchEvent(event);
            return null;
        }
        this.stopProcess = true;
        return new EbookIterationFinishStepResult(fileInfo.getId(), false, "source file md5 mismatched!");
    }

    public EbookIterationFinishStepResult checkTargetFile(Ebook book, File targetFile) {
        EbookFileInfo fileInfo = book.getDefaultEbookFileInfo();
        if (!targetFile.exists()) {
            LogicEvent event = new LogicEvent("Additional", (Object)new EbookIterationFinishStepResult(fileInfo.getId(), true, "destination file not found!"));
            this.dispatchEvent(event);
            this.needCopying = true;
            return null;
        }
        boolean result = book.getDefaultEbookFileInfo().getFileSize().equals(targetFile.length());
        if (result) {
            LogicEvent event = new LogicEvent("Additional", (Object)new EbookIterationFinishStepResult(fileInfo.getId(), true, "destination file md5 matched"));
            this.dispatchEvent(event);
            this.needCopying = false;
            return null;
        }
        return new EbookIterationFinishStepResult(fileInfo.getId(), false, "destination file md5 mismatched!");
    }

    public boolean onException(Exception ex) {
        logger.error("", (Throwable)ex);
        return true;
    }
}

