/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.ebook.progress;

import java.util.List;
import myencyclopedia.common.progress.Logic;
import myencyclopedia.common.progress.LogicEvent;
import myencyclopedia.logic.ebook.progress.EbookIterationFinishStepResult;
import myencyclopedia.logic.ebook.utils.EbookUtils;
import myencyclopedia.model.ebook.Ebook;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EbookIterationLogic
extends Logic {
    private Session session;
    protected SessionFactory sessionFactory;
    protected int totalNumber;
    protected int bookExamed;
    protected List<Ebook> books;
    protected EbookIterationFinishStepResult result;
    private static final Logger logger = LoggerFactory.getLogger(EbookIterationLogic.class);

    public EbookIterationLogic(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public boolean doPrepare() {
        this.session = this.sessionFactory.openSession();
        this.totalNumber = EbookUtils.getTotalNumber(this.session);
        String HibernateQuery = "from Ebook e";
        Query query = this.session.createQuery(HibernateQuery);
        this.books = query.list();
        this.bookExamed = 0;
        if (!this.doExtraPrepare()) {
            return false;
        }
        boolean hasFirst = !this.books.isEmpty();
        return hasFirst;
    }

    public boolean doExtraPrepare() {
        return true;
    }

    public void doExtraCleanUp() {
    }

    public boolean isSuccess() {
        return true;
    }

    public boolean hasNextStep() {
        return this.bookExamed < this.books.size();
    }

    public void doStep() {
        Ebook ebookInProcess = this.books.get(this.bookExamed);
        this.result = this.processEbook(ebookInProcess);
        ++this.bookExamed;
    }

    public void doCleanUp() {
        this.doExtraCleanUp();
        this.session.close();
    }

    protected abstract EbookIterationFinishStepResult processEbook(Ebook var1);

    protected LogicEvent constructStartOneStepEvent() {
        LogicEvent startOneStepEvent = new LogicEvent("StartOneStep", (Object)new EbookIterationFinishStepResult(this.books.get(this.bookExamed).getDefaultEbookFileInfo().getId(), true, "Start processing"));
        return startOneStepEvent;
    }

    protected LogicEvent constructFinishOneStepEvent() {
        LogicEvent finishOneStepEvent = new LogicEvent("FinishOneStep", (Object)this.result);
        return finishOneStepEvent;
    }

    public boolean isProgressSupported() {
        return true;
    }

    public int getProgressPercent() {
        float perc = (float)this.bookExamed / (float)this.totalNumber;
        return (int)(perc * 100.0f);
    }

    public static void main(String[] args) {
        AnnotationConfiguration config = new AnnotationConfiguration();
        config.configure("hibernate.ebook.mysql.xml");
        try {
            new SchemaValidator((Configuration)config).validate();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            System.exit(-1);
        }
        SessionFactory sessionFactory = config.buildSessionFactory();
    }
}

