/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.ebook.progress;

import java.io.File;
import myencyclopedia.logic.ebook.progress.EbookIterationFinishStepResult;
import myencyclopedia.logic.ebook.progress.EbookIterationLogic;
import myencyclopedia.logic.ebook.utils.EbookUtils;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.ebook.EbookFileInfo;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileLengthValidatorLogic
extends EbookIterationLogic {
    private static final Logger logger = LoggerFactory.getLogger(FileLengthValidatorLogic.class);

    public FileLengthValidatorLogic(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public EbookIterationFinishStepResult processEbook(Ebook book) {
        EbookFileInfo fileInfo = book.getDefaultEbookFileInfo();
        File bookFile = new File(EbookUtils.getFileFullPath(book));
        if (!bookFile.exists()) {
            return new EbookIterationFinishStepResult(fileInfo.getId(), false, "file doesn't exist");
        }
        if (fileInfo.getFileSize().longValue() != bookFile.length()) {
            return new EbookIterationFinishStepResult(fileInfo.getId(), false, "size not equal");
        }
        return new EbookIterationFinishStepResult(fileInfo.getId(), true, "file length matched");
    }

    public boolean onException(Exception ex) {
        logger.error("", (Throwable)ex);
        return true;
    }
}

