/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.ebook.progress;

import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import myencyclopedia.common.utils.HashUtil;
import myencyclopedia.logic.ebook.progress.EbookIterationFinishStepResult;
import myencyclopedia.logic.ebook.progress.EbookIterationLogic;
import myencyclopedia.logic.ebook.utils.EbookUtils;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.ebook.EbookFileInfo;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MD5ValidatorLogic
extends EbookIterationLogic {
    private static final Logger logger = LoggerFactory.getLogger(MD5ValidatorLogic.class);

    public MD5ValidatorLogic(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public EbookIterationFinishStepResult processEbook(Ebook book) {
        File bookFile = new File(EbookUtils.getFileFullPath(book));
        EbookFileInfo fileInfo = book.getDefaultEbookFileInfo();
        if (!bookFile.exists()) {
            return new EbookIterationFinishStepResult(fileInfo.getId(), false, "file doesn't exist");
        }
        String actualMD5 = null;
        try {
            actualMD5 = HashUtil.computeMD5((File)bookFile);
        }
        catch (IOException ex) {
            logger.error("", (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            logger.error("", (Throwable)ex);
        }
        if (fileInfo.getMd5() == null) {
            return new EbookIterationFinishStepResult(fileInfo.getId(), false, "no md5 value in DB");
        }
        if (fileInfo.getMd5().equals(actualMD5)) {
            return new EbookIterationFinishStepResult(fileInfo.getId(), true, "MD5 matched");
        }
        return new EbookIterationFinishStepResult(fileInfo.getId(), false, "MD5 not matched");
    }

    public boolean onException(Exception ex) {
        logger.error("", (Throwable)ex);
        return true;
    }
}

