/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.ebook.utils;

import java.io.File;
import java.util.Iterator;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.model.common.entity.FileObject;
import myencyclopedia.model.ebook.Discipline;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.ebook.EbookFileInfo;
import myencyclopedia.model.ebook.TitleI18N;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class EbookUtils {
    public static long getEbookNumberInDB(SessionFactory sessionFactory) {
        Session session = sessionFactory.openSession();
        Query q = session.createQuery("select count(ebook) from Ebook ebook");
        long number = (Long)q.list().get(0);
        session.close();
        return number;
    }

    @Deprecated
    public static String getFileFullPath(Ebook ebook) {
        return EbookUtils.getFileFullPath(ebook.getDefaultEbookFileInfo());
    }

    public static String getFileFullPath(EbookFileInfo fileInfo) {
        String fileFullPath = ConfigMydoc.getInstance().getBookShelfPath() + File.separator + fileInfo.getRelativePath() + File.separator + fileInfo.getFileName();
        return fileFullPath;
    }

    public static int getTotalNumber(Session session) {
        String SQL_QUERY = "select count(*) from Ebook ebook";
        Query query = session.createQuery(SQL_QUERY);
        Long number = (Long)query.uniqueResult();
        return number.intValue();
    }

    public static int getNextDisciplineOffset(Session session, Discipline discipline) {
        String SQL_QUERY = "select max(ebookFileInfo.disciplineOffset) from EbookFileInfo ebookFileInfo where ebookFileInfo.ebook.discipline= :discipline";
        Integer max = null;
        Query query = session.createQuery(SQL_QUERY);
        query.setInteger("discipline", discipline.toInt());
        Iterator it = query.iterate();
        while (it.hasNext()) {
            max = (Integer)it.next();
        }
        if (max == null) {
            return 1;
        }
        return max + 1;
    }

    public static String getRelativePath(Discipline discipline, int offset) {
        StringBuilder ret = new StringBuilder(String.valueOf(discipline.toInt()));
        ret.append("/");
        int folderNumber = offset / 100 * 100;
        for (int i = 0; i < 6 - String.valueOf(folderNumber).length(); ++i) {
            ret.append("0");
        }
        ret.append(folderNumber);
        return ret.toString();
    }

    public static String formEbookFileName(String title, String suffix, Discipline discipline, int disciplineOffset) {
        StringBuilder ret = new StringBuilder(String.valueOf(discipline.toInt()));
        ret.append("_");
        ret.append(disciplineOffset);
        ret.append("_");
        title = title.replaceAll(" ", "_");
        ret.append(title);
        ret.append(".");
        ret.append(suffix);
        return ret.toString();
    }

    public static String formAttachmentPath(Ebook ebook) {
        int folderNumber = (int)(ebook.getId() / 100L * 100L);
        StringBuilder ret = new StringBuilder(String.format("%06d", folderNumber));
        ret.append("/").append(String.format("%06d", folderNumber));
        return ret.toString();
    }

    public static String getAttachmentFullPath(FileObject attachmentFileObj) {
        String fileFullPath = ConfigMydoc.getInstance().getBookShelfPath() + File.separator + "attachment" + File.separator + attachmentFileObj.getRelativePath() + File.separator + attachmentFileObj.getFileName();
        return fileFullPath;
    }

    public static String formEbookDescription(TitleI18N titleI18n) {
        String description = titleI18n.getTitle();
        if (titleI18n.getSubtitle() != null) {
            description = description + "[[" + titleI18n.getSubtitle() + "]]";
        }
        return description;
    }
}

