/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.mydoc;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Calendar;
import java.util.Date;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.logic.mydoc.DocManager;
import myencyclopedia.model.Entity;
import myencyclopedia.model.RelationCollection;
import myencyclopedia.model.common.DateMarker;
import myencyclopedia.model.common.DateMarkerUtils;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.mydoc.Code;
import myencyclopedia.model.mydoc.Snippet;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeDAO {
    private static final Logger logger = LoggerFactory.getLogger(CodeDAO.class);

    public static Path initCode(Code code) {
        Path newFolder;
        Path pathCode = ConfigMydoc.getInstance().getAsPath("/myencyclopedia/mydoc/code/path");
        Calendar calendar = Calendar.getInstance();
        Date candidateTime = calendar.getTime();
        calendar.setTime(candidateTime);
        while (true) {
            if (!Files.exists(newFolder = Paths.get(pathCode.toString(), String.valueOf(calendar.get(1)), String.format("%02d", calendar.get(2) + 1), DocManager.generateDocFolderName(calendar)), new LinkOption[0])) {
                try {
                    Files.createDirectories(newFolder, new FileAttribute[0]);
                }
                catch (IOException ex) {
                    logger.error("", (Throwable)ex);
                }
                break;
            }
            calendar.add(13, 1);
        }
        DateMarker dm = DateMarkerUtils.createDateMarker((Calendar)calendar);
        code.setPropertyValue("filepath", (Object)pathCode.relativize(newFolder).toString());
        code.setPropertyValue("datemarker", (Object)dm);
        return newFolder;
    }

    public static void figureOutLang(Code code, Session s) {
        RelationCollection r = (RelationCollection)code.getRelation("snippet");
        for (Entity en : r.getTarget()) {
            Tag t;
            Snippet snippet = (Snippet)en;
            if (code.getLang() != null || (t = snippet.getTag()) == null) continue;
            s.update((Object)t);
            while (true) {
                if (t.getParentTag().getExtID().equals(11)) {
                    code.setLang(t.getName().toLowerCase());
                    return;
                }
                t = t.getParentTag();
            }
        }
    }

    public static void delete(Session s, Code code) throws Exception {
        s.update((Object)code);
        s.beginTransaction();
        RelationCollection rSnippet = (RelationCollection)code.getRelation("snippet");
        for (Snippet snippet : (Snippet[])rSnippet.getTarget()) {
            s.delete((Object)snippet);
        }
        s.delete((Object)code);
        s.getTransaction().commit();
    }

    public static void updateCodeTags(Code code) {
        RelationCollection rTags = (RelationCollection)code.getRelation("tags");
        RelationCollection rSnippet = (RelationCollection)code.getRelation("snippet");
        for (Snippet snippet : (Snippet[])rSnippet.getTarget()) {
            Tag t = snippet.getTag();
            if (t == null) continue;
            boolean contains = false;
            for (Tag tag : (Tag[])rTags.getTarget()) {
                if (!tag.getId().equals(t.getId())) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            rTags.addTarget((Entity)t);
        }
    }
}

