/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.mydoc;

import java.nio.file.Path;
import java.nio.file.Paths;
import myencyclopedia.common.config.XMLConfigFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMydoc
extends XMLConfigFile {
    public static final String CONFIG_MYDOC = "ConfigMydoc.xml";
    public static final String FOLDER = "/myencyclopedia/mydoc/folder";
    public static final String NOTE_PATH = "/myencyclopedia/mydoc/note/path";
    public static final String DOC_PATH = "/myencyclopedia/mydoc/doc/path";
    public static final String BOOKSHELF_PATH = "/myencyclopedia/mydoc/bookshelf/path";
    public static final String CODE_PATH = "/myencyclopedia/mydoc/code/path";
    public static final String LUCENE_CACHE_PATH = "/myencyclopedia/mydoc/lucene/path";
    public static final String TEMP_PATH = "/myencyclopedia/mydoc/temp/path";
    public static final String TRASH_PATH = "/myencyclopedia/mydoc/trash/path";
    public static final String OPTION_INDEX = "/myencyclopedia/mydoc/option/index";
    public static final String OPTION_COPYDOC_PATH = "/myencyclopedia/mydoc/option/copydoc";
    public static final String OPTION_MOVE_TO_TRASH = "/myencyclopedia/mydoc/option/move_to_trash";
    public static final String OPTION_SHOWHIDDEN_PATH = "/myencyclopedia/mydoc/option/showhidden";
    public static final String OPTION_LANG = "/myencyclopedia/mydoc/option/language";
    public static final String OPTION_MODE_PATH = "/myencyclopedia/mydoc/option/mode";
    public static final String OPTION_CLIENT_PATH = "/myencyclopedia/mydoc/option/client";
    private static ConfigMydoc theInstance = null;
    private static final Logger logger = LoggerFactory.getLogger(ConfigMydoc.class);

    private ConfigMydoc() throws XMLConfigFile.ConfigMismatchException {
        super(CONFIG_MYDOC);
    }

    public static ConfigMydoc initInstance() {
        if (theInstance == null) {
            try {
                theInstance = new ConfigMydoc();
            }
            catch (XMLConfigFile.ConfigMismatchException ex) {
                logger.error("", (Throwable)ex);
                System.exit(-1);
            }
        } else {
            System.err.println("Already have called ConfigMydoc initInstance");
            System.exit(-1);
        }
        return theInstance;
    }

    public static ConfigMydoc getInstance() {
        if (theInstance == null) {
            System.err.println("Need to call ConfigMydoc initInstance");
            System.exit(-1);
        }
        return theInstance;
    }

    public String getDBURL() {
        return Paths.get(this.getNodeValue(FOLDER), "mydoc").toString();
    }

    public Path getBookShelfPath() {
        String str = this.getNodeValue(BOOKSHELF_PATH);
        return Paths.get(str, new String[0]).toAbsolutePath().normalize();
    }

    public boolean getIndexEnabled() {
        return Boolean.parseBoolean(this.getNodeValue(OPTION_INDEX));
    }

    public boolean getCopyDocPathEnabled() {
        return Boolean.parseBoolean(this.getNodeValue(OPTION_COPYDOC_PATH));
    }

    public boolean getShowHiddenEnabled() {
        return Boolean.parseBoolean(this.getNodeValue(OPTION_SHOWHIDDEN_PATH));
    }

    public boolean getMoveToTrash() {
        return Boolean.parseBoolean(this.getNodeValue(OPTION_MOVE_TO_TRASH));
    }

    public String getMode() {
        return this.getNodeValue(OPTION_MODE_PATH);
    }

    public String getLanguage() {
        return this.getNodeValue(OPTION_LANG);
    }

    public String getClientConfig() {
        return this.getNodeValue(OPTION_CLIENT_PATH);
    }
}

