/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.mydoc;

import java.util.Locale;
import java.util.ResourceBundle;
import myencyclopedia.logic.mydoc.tag.TagManager;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.ebook.Publisher;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBInit {
    private static final Logger logger = LoggerFactory.getLogger(DBInit.class);
    private static final ResourceBundle rb = ResourceBundle.getBundle("properties.logic-mydoc-tags", Locale.getDefault());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(SessionFactory sf) {
        TagManager.init(sf);
        TagManager tm = TagManager.getInstance();
        tm.reload();
        Session s = sf.openSession();
        s.beginTransaction();
        try {
            String[] publishers;
            Tag rootEbook = tm.createPreDefined(null, rb.getString("ROOT_EBOOK"), 1);
            tm.createPreDefined(rootEbook, rb.getString("STR_COMPUTER"), 2);
            tm.createPreDefined(rootEbook, rb.getString("STR_LITERATURE"), 3);
            tm.createPreDefined(rootEbook, rb.getString("STR_TECHNOLOGY"), 4);
            tm.createPreDefined(rootEbook, rb.getString("STR_ART"), 5);
            tm.createPreDefined(rootEbook, rb.getString("STR_SOCIAL"), 6);
            tm.createPreDefined(rootEbook, rb.getString("STR_NATURE"), 7);
            tm.createPreDefined(rootEbook, rb.getString("STR_MISC"), 8);
            tm.createPreDefined(rootEbook, rb.getString("STR_HISTORY"), 9);
            tm.createPreDefined(rootEbook, rb.getString("STR_PHILOSOPHY"), 10);
            Tag rootPL = tm.createPreDefined(null, rb.getString("ROOT_PROGRAMMING_LANG"), 11);
            Tag tagJava = tm.createPreDefined(rootPL, rb.getString("PL_JAVA"), 12);
            tm.createPreDefined(rootPL, rb.getString("PL_C"), 13);
            tm.createPreDefined(rootPL, rb.getString("PL_CPP"), 14);
            tm.createPreDefined(rootPL, rb.getString("PL_CSHARP"), 15);
            tm.createPreDefined(rootPL, rb.getString("PL_OBJC"), 16);
            Tag tagPython = tm.createPreDefined(rootPL, rb.getString("PL_PYTHON"), 17);
            tm.createPreDefined(rootPL, rb.getString("PL_SHELL"), 18);
            tm.createPreDefined(rootPL, rb.getString("PL_HTML"), 19);
            tm.createPreDefined(rootPL, rb.getString("PL_JAVASCRIPT"), 20);
            tm.createPreDefined(rootPL, rb.getString("PL_SQL"), 21);
            tm.createPreDefined(rootPL, rb.getString("PL_PERL"), 22);
            tm.createPreDefined(rootPL, rb.getString("PL_PHP"), 23);
            tm.createPreDefined(rootPL, rb.getString("PL_RUBY"), 24);
            for (String str : publishers = new String[]{"MIT", "Addison Wesley", "McGraw Hill", "O'Reilly", "Prentice Hall"}) {
                Publisher p = new Publisher();
                p.setName(str);
                s.save((Object)p);
            }
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
            System.exit(-1);
        }
        finally {
            s.close();
        }
    }
}

