/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.mydoc;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import myencyclopedia.common.utils.FileCopyUtil;
import myencyclopedia.logic.mydoc.ConfigMydoc;
import myencyclopedia.logic.mydoc.DayContentChangedEvent;
import myencyclopedia.logic.mydoc.DayContentChangedListener;
import myencyclopedia.model.common.DateMarker;
import myencyclopedia.model.common.DateMarkerUtils;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.mydoc.Doc;
import org.apache.commons.io.FileUtils;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocManager {
    private static DocManager theInstance = new DocManager();
    private static List<DayContentChangedListener> dayContentChangedListeners = new ArrayList<DayContentChangedListener>();
    private static Path pathTrash;
    private static Path pathDoc;
    private ConfigMydoc config = ConfigMydoc.getInstance();
    private static SessionFactory sf;
    private static final Logger logger;

    private DocManager() {
        pathDoc = this.config.getAsPath("/myencyclopedia/mydoc/doc/path");
        pathTrash = this.config.getAsPath("/myencyclopedia/mydoc/trash/path");
    }

    public static DocManager getInstance(SessionFactory factory) {
        sf = factory;
        return theInstance;
    }

    public static DocManager getInstance() {
        return theInstance;
    }

    public Path getDocFolder(Doc doc) {
        Path docPath = Paths.get(pathDoc.toString(), doc.getContentFolder());
        return docPath;
    }

    public Path getDocRootFolder() {
        return pathDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Doc> searchForMD5(Session s, String md5) {
        String queryStr = "select doc from Doc as doc where doc.md5 = :strMd5";
        Query query = s.createQuery(queryStr);
        query.setParameter("strMd5", (Object)md5);
        List result = null;
        try {
            result = query.list();
        }
        finally {
            s.close();
        }
        return result;
    }

    public Doc getLatest() {
        throw new UnsupportedOperationException();
    }

    public Doc getNext(Doc doc) {
        throw new UnsupportedOperationException();
    }

    public Doc getNext(DateMarker targetDate) {
        throw new UnsupportedOperationException();
    }

    public Doc getNext(Tag tag, Doc doc) {
        return this.getNext(tag, doc.getDateMarker());
    }

    public Doc getNext(Tag tag, DateMarker targetDate) {
        throw new UnsupportedOperationException();
    }

    public Doc getPrev(Doc doc) {
        throw new UnsupportedOperationException();
    }

    public Doc getPrev(DateMarker targetDate) {
        throw new UnsupportedOperationException();
    }

    public Doc getPrev(Tag tag, Doc doc) {
        return this.getNext(tag, doc.getDateMarker());
    }

    public Doc getPrev(Tag tag, DateMarker targetDate) {
        throw new UnsupportedOperationException();
    }

    public List<Doc> getInDay(int year, int month, int day) {
        throw new UnsupportedOperationException();
    }

    public List<Doc> getInDay(Tag tag, int year, int month, int day) {
        throw new UnsupportedOperationException();
    }

    public Doc createDoc(String leadingFilename, String md5) throws IOException {
        Path newFolder;
        Calendar calendar = Calendar.getInstance();
        Date candidateTime = calendar.getTime();
        calendar.setTime(candidateTime);
        Doc doc = null;
        while (true) {
            if (!Files.exists(newFolder = Paths.get(pathDoc.toString(), String.valueOf(calendar.get(1)), String.format("%02d", calendar.get(2) + 1), DocManager.generateDocFolderName(calendar)), new LinkOption[0])) break;
            calendar.add(13, 1);
        }
        Files.createDirectories(newFolder, new FileAttribute[0]);
        doc = new Doc();
        DateMarker dm = DateMarkerUtils.createDateMarker((Calendar)calendar);
        doc.setPropertyValue("filelist", (Object)leadingFilename);
        doc.setPropertyValue("title", (Object)leadingFilename);
        doc.setPropertyValue("filepath", (Object)pathDoc.relativize(newFolder).toString());
        doc.setPropertyValue("datemarker", (Object)dm);
        doc.setPropertyValue("hash_md5", (Object)md5);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void firstSave(Doc doc, List<File> fileList) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        File newFolder = new File(this.getDocRootFolder().toFile(), doc.getContentFolder());
        for (File file : fileList) {
            fileNameList.add(file.getName());
            try {
                FileCopyUtil.copy((Path)file.toPath(), (Path)newFolder.toPath());
            }
            catch (IOException ex) {
                logger.error("", (Throwable)ex);
                try {
                    this.delete(doc, false);
                }
                catch (IOException ex2) {
                    logger.error("", (Throwable)ex2);
                }
                return;
            }
        }
        doc.setFileList(fileNameList);
        Session s = sf.openSession();
        s.beginTransaction();
        try {
            s.save((Object)doc);
            s.getTransaction().commit();
        }
        finally {
            s.close();
        }
        try {
            for (File file : fileList) {
                Files.delete(file.toPath());
            }
        }
        catch (IOException iOException) {
            logger.error("", (Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Doc doc) {
        Session s = sf.openSession();
        s.beginTransaction();
        try {
            s.update((Object)doc);
            s.getTransaction().commit();
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
        finally {
            s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Doc doc, boolean moveToTrash) throws IOException {
        Path folder = Paths.get(pathDoc.toString(), doc.getContentFolder());
        Path target = Paths.get(pathTrash.toString(), folder.getFileName().toString());
        try {
            if (moveToTrash) {
                Files.move(folder, target, new CopyOption[0]);
            } else {
                FileUtils.deleteDirectory((File)folder.toFile());
            }
        }
        catch (NoSuchFileException noEx) {
            logger.error("Deleting doc error:" + doc, (Throwable)noEx);
        }
        catch (IOException ex) {
            logger.error("Deleting doc error:" + doc, (Throwable)ex);
            throw ex;
        }
        try (Session s = sf.openSession();){
            s.beginTransaction();
            s.update((Object)doc);
            s.delete((Object)doc);
            s.getTransaction().commit();
        }
        DayContentChangedEvent event = new DayContentChangedEvent(doc, doc.getDateMarker(), DayContentChangedEvent.Type.Deleted);
        this.fireDayContentChanged(event);
    }

    public void saveInfo(Doc doc) throws IOException {
    }

    private boolean isTagsModified(Tag[] oldTags, Tag[] newTags) {
        ArrayList<Tag> tags = new ArrayList<Tag>(Arrays.asList(newTags));
        for (Tag tag : oldTags) {
            if (tags.remove(tag)) continue;
            return true;
        }
        return !tags.isEmpty();
    }

    public void addDayContentChangedListener(DayContentChangedListener listener) {
        dayContentChangedListeners.add(listener);
    }

    public void removeDayContentChangedListener(DayContentChangedListener listener) {
        dayContentChangedListeners.remove(listener);
    }

    private void fireDayContentChanged(DayContentChangedEvent event) {
        Iterator<DayContentChangedListener> iterator = dayContentChangedListeners.iterator();
        while (iterator.hasNext()) {
            DayContentChangedListener listener;
            DayContentChangedListener dayContentChangedListener = listener = iterator.next();
            dayContentChangedListener.changed(event);
        }
    }

    public static String generateDocFolderName(Calendar calendar) {
        StringBuilder ret = new StringBuilder();
        ret.append(String.format("%02d", calendar.get(5))).append("_").append(String.format("%02d", calendar.get(11))).append("_").append(String.format("%02d", calendar.get(12))).append("_").append(String.format("%02d", calendar.get(13)));
        return ret.toString();
    }

    static {
        logger = LoggerFactory.getLogger(DocManager.class);
    }
}

