/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.mydoc.tag;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import myencyclopedia.logic.mydoc.tag.TagManager;
import myencyclopedia.model.common.entity.Tag;

public class TagUtils {
    public static String toShortStringForm(List<Tag> tags) {
        if (tags == null || tags.isEmpty()) {
            return "";
        }
        StringBuilder str = new StringBuilder("");
        for (Tag tag : tags) {
            if (tag == null) continue;
            str.append(tag.getPropertyValue("name")).append("(").append(tag.getId()).append(");");
        }
        return str.toString();
    }

    public static List<Tag> toTagList(String tagShortForm) {
        ArrayList<Tag> tagList = new ArrayList<Tag>();
        if (tagShortForm == null || tagShortForm.isEmpty()) {
            return tagList;
        }
        String[] tagStrArray = tagShortForm.split(";");
        Pattern pattern = Pattern.compile(".+\\((\\d+)\\)");
        for (String tagStr : tagStrArray) {
            Integer extid;
            Matcher matcher = pattern.matcher(tagStr);
            if (!matcher.find()) continue;
            String tagId = matcher.group(1);
            try {
                extid = Integer.valueOf(tagId);
            }
            catch (NumberFormatException e) {
                continue;
            }
            Tag tag = TagManager.getInstance().getTagFromExtId(extid);
            if (tag == null) continue;
            tagList.add(tag);
        }
        return tagList;
    }
}

