/*
 * Decompiled with CFR 0.152.
 */
package myencyclopedia.logic.query;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import myencyclopedia.common.utils.CancelFlagHolder;
import myencyclopedia.hibernate.AsyncListReceiver;
import myencyclopedia.logic.query.MECriteria;
import myencyclopedia.logic.query.MECriterion;
import myencyclopedia.logic.query.METagCriterion;
import myencyclopedia.model.Entity;
import myencyclopedia.model.common.entity.Tag;
import myencyclopedia.model.ebook.Ebook;
import myencyclopedia.model.mydoc.Code;
import myencyclopedia.model.mydoc.Doc;
import myencyclopedia.model.mydoc.Note;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Restrictions;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityQueryUtil {
    private static final Logger logger = LoggerFactory.getLogger(EntityQueryUtil.class);
    public static final String FIELD_CONTENT = "_content";

    public static boolean parseInput(String input, MECriteria criteria) {
        String[] strs = input.split(",");
        if (strs.length == 0) {
            // empty if block
        }
        for (String str : strs) {
            if ((str = str.trim()).length() > 0 && str.charAt(0) == '#') {
                if (str.length() > 1 && str.charAt(str.length() - 1) == '#') {
                    String value = str.substring(1, str.length() - 1);
                    if (value.length() < 2) {
                        return false;
                    }
                    try {
                        criteria.addContentCriteronForAll(value);
                        continue;
                    }
                    catch (ParseException ex) {
                        return false;
                    }
                }
                return false;
            }
            String[] pair = (str = str + " ").split(":");
            if (pair.length == 0) {
                return false;
            }
            if (pair.length == 1) {
                String content = pair[0].trim();
                if (content.length() < 2) {
                    return false;
                }
                try {
                    criteria.addDefaultCriteronForAll(pair[0].trim());
                    continue;
                }
                catch (ParseException ex) {
                    return false;
                }
            }
            String left = pair[0];
            String right = pair[1];
            boolean isNegate = false;
            if ((left = left.trim()).length() == 0) {
                return false;
            }
            if (left.charAt(0) == '-') {
                isNegate = true;
                left = left.substring(1);
            }
            if (left.length() == 0) {
                return false;
            }
            Class<Tag> targetClass = null;
            switch (left.charAt(0)) {
                case 't': {
                    targetClass = Tag.class;
                    break;
                }
                case 'b': {
                    targetClass = Ebook.class;
                    break;
                }
                case 'n': {
                    targetClass = Note.class;
                    break;
                }
                case 'c': {
                    targetClass = Code.class;
                    break;
                }
                case 'd': {
                    targetClass = Doc.class;
                    break;
                }
                default: {
                    return false;
                }
            }
            String fieldName = left.length() > 1 && left.charAt(1) == '.' ? left.substring(2) : MECriteria.getDefaultFieldFor(targetClass);
            right = right.trim();
            if (right.length() < 2) {
                return false;
            }
            if (right.charAt(0) == '#') {
                if (right.length() > 1 && right.charAt(right.length() - 1) == '#') {
                    String value = right.substring(1, right.length() - 1);
                    if (value.length() < 2) {
                        return false;
                    }
                    try {
                        criteria.addContentCriteronForAll(targetClass, value);
                        continue;
                    }
                    catch (ParseException ex) {
                        return false;
                    }
                }
                return false;
            }
            if (right.charAt(0) == '\'') {
                if (right.length() == 1) {
                    return false;
                }
                if (right.charAt(right.length() - 1) == '\'') {
                    right = right.substring(1, right.length() - 1);
                } else {
                    return false;
                }
            }
            try {
                criteria.addCriterion(targetClass, fieldName, right);
            }
            catch (ParseException ex) {
                return false;
            }
        }
        return true;
    }

    public static Class<? extends Entity> hasTaggedEntity(Tag tag, Session s) {
        final ArrayList retHolder = new ArrayList();
        final CancelFlagHolder cancelVar = new CancelFlagHolder();
        AsyncListReceiver dummy = new AsyncListReceiver(){

            public void beginLoading() {
            }

            public void endLoading() {
            }

            public void appendList(List<Entity> lst) {
                if (!lst.isEmpty()) {
                    retHolder.add(lst.get(0).getClass());
                    cancelVar.setCancelled();
                }
            }
        };
        MECriteria c = new MECriteria(dummy, Doc.class, Note.class, Ebook.class, Code.class);
        c.addTagCriterion(tag, false);
        c.runCriteria(dummy, s, cancelVar);
        if (retHolder.isEmpty()) {
            return null;
        }
        return (Class)retHolder.get(0);
    }

    public static FullTextQuery wrapCriteria(Session s, Criteria criteria, Class<? extends Entity> targetCls, String contentQuery) {
        FullTextSession fullTextSession = Search.getFullTextSession((Session)s);
        QueryParser parser = new QueryParser("contents", fullTextSession.getSearchFactory().getAnalyzer(targetCls));
        Query luceneQuery = null;
        try {
            luceneQuery = parser.parse(String.format("%s AND %s:%s", contentQuery, "classtype", targetCls.getSimpleName()));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery(luceneQuery, new Class[0]);
        if (criteria != null) {
            fullTextQuery.setCriteriaQuery(criteria);
        }
        return fullTextQuery;
    }

    public static Criteria generateCriteria(Session s, Class<? extends Entity> targetCls, List<MECriterion> clsCriterion, METagCriterion tagCriterion) {
        Criteria ret = null;
        Criteria criteria = s.createCriteria(targetCls).setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        if (tagCriterion != null) {
            if (tagCriterion.tagId != null) {
                criteria.createCriteria("tags").createCriteria("targetEntity").add((Criterion)Restrictions.eq((String)"id", (Object)tagCriterion.tagId));
                ret = criteria;
            } else {
                criteria.add(Restrictions.isNull((String)"tags"));
                ret = criteria;
            }
        }
        for (MECriterion c : clsCriterion) {
            if (c.getField() == null || c.getField().equals("contents")) continue;
            if (c.isString()) {
                if (c.isExactMatch()) {
                    criteria.add((Criterion)Restrictions.like((String)c.getField(), (String)((String)c.getValue()), (MatchMode)MatchMode.ANYWHERE));
                    ret = criteria;
                    continue;
                }
                criteria.add(Restrictions.ilike((String)c.getField(), (String)((String)c.getValue()), (MatchMode)MatchMode.ANYWHERE));
                ret = criteria;
                continue;
            }
            criteria.add((Criterion)Restrictions.eq((String)c.getField(), (Object)c.getValue()));
            ret = criteria;
        }
        return ret;
    }
}

